/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "nmg" locale.
 */
public class LocalizedNamesImpl_nmg extends LocalizedNamesImpl {

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AC",
        "AF",
        "ZA",
        "EG",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AG",
        "AQ",
        "AR",
        "AM",
        "AW",
        "IL",
        "AX",
        "AZ",
        "AN",
        "BS",
        "BH",
        "BB",
        "BY",
        "BJ",
        "BL",
        "BO",
        "BA",
        "BW",
        "BQ",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "BT",
        "BV",
        "BE",
        "BZ",
        "BM",
        "BD",
        "CC",
        "CP",
        "CW",
        "CX",
        "DK",
        "DG",
        "DM",
        "EA",
        "EH",
        "EC",
        "ER",
        "ET",
        "EU",
        "FR",
        "FJ",
        "PH",
        "FI",
        "FO",
        "GA",
        "GM",
        "GH",
        "GG",
        "GI",
        "GL",
        "GD",
        "GR",
        "GS",
        "GP",
        "GU",
        "GT",
        "GN",
        "GW",
        "GQ",
        "PG",
        "GY",
        "GF",
        "HT",
        "HK",
        "HM",
        "IC",
        "IM",
        "IN",
        "ID",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IT",
        "JM",
        "DE",
        "JP",
        "JE",
        "DJ",
        "JO",
        "GE",
        "NC",
        "KH",
        "CM",
        "CA",
        "QA",
        "KZ",
        "KI",
        "CG",
        "CD",
        "KP",
        "KR",
        "CR",
        "CI",
        "KW",
        "HR",
        "CU",
        "KG",
        "CO",
        "KM",
        "KE",
        "LA",
        "LV",
        "LS",
        "LB",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MK",
        "MG",
        "MW",
        "MY",
        "MV",
        "ML",
        "MT",
        "MQ",
        "MA",
        "YT",
        "FK",
        "CV",
        "CK",
        "KY",
        "MH",
        "NF",
        "MP",
        "SB",
        "TC",
        "ME",
        "MF",
        "FM",
        "AE",
        "VI",
        "VG",
        "MO",
        "MC",
        "MU",
        "MR",
        "MZ",
        "MM",
        "MD",
        "MN",
        "MS",
        "MX",
        "NA",
        "NL",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "CZ",
        "DO",
        "GB",
        "IO",
        "NR",
        "NO",
        "OM",
        "AU",
        "AT",
        "PK",
        "PW",
        "PS",
        "PA",
        "PY",
        "ES",
        "PE",
        "PN",
        "PF",
        "PR",
        "PL",
        "PT",
        "QO",
        "RE",
        "RO",
        "RS",
        "RU",
        "RW",
        "KN",
        "SH",
        "LC",
        "PM",
        "VC",
        "SV",
        "WS",
        "AS",
        "SM",
        "ST",
        "SA",
        "SN",
        "CF",
        "SC",
        "CN",
        "SL",
        "SG",
        "CY",
        "SJ",
        "SK",
        "SI",
        "SO",
        "LK",
        "SS",
        "SD",
        "SR",
        "SE",
        "SZ",
        "CH",
        "SX",
        "SY",
        "TA",
        "TH",
        "TW",
        "TJ",
        "TZ",
        "TF",
        "TL",
        "TG",
        "TK",
        "TT",
        "TD",
        "CL",
        "TN",
        "TR",
        "TM",
        "TV",
        "TO",
        "UG",
        "UA",
        "UM",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VN",
        "VE",
        "WF",
        "XK",
        "YE",
        "ZM",
        "NZ",
        "ZW",
        "HN",
        "HU",
        "EE",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("AD", "Andɔ́ra");
    namesMap.put("AE", "Minlambɔ́ Nsaŋ́nsa mí Arabia");
    namesMap.put("AF", "Afganistaŋ");
    namesMap.put("AG", "Antíga bá Barbúda");
    namesMap.put("AI", "Anguílla");
    namesMap.put("AM", "Arménia");
    namesMap.put("AN", "B'Antilles bó Nedɛrland");
    namesMap.put("AR", "Argentína");
    namesMap.put("AS", "Samoa m ́Amɛ́rka");
    namesMap.put("AT", "Ötrish");
    namesMap.put("AU", "Östraliá");
    namesMap.put("AW", "Árúba");
    namesMap.put("AZ", "Azerbaïjaŋ");
    namesMap.put("BA", "Bosnia na Ɛrzegovina");
    namesMap.put("BB", "Barbado");
    namesMap.put("BD", "Bɛŋgladɛsh");
    namesMap.put("BE", "Bɛlgik");
    namesMap.put("BM", "Bɛrmuda");
    namesMap.put("BN", "Brunɛi");
    namesMap.put("BR", "Brésil");
    namesMap.put("BT", "Butaŋ");
    namesMap.put("BZ", "Bɛliz");
    namesMap.put("CA", "Kanada");
    namesMap.put("CD", "Kongó Zaïre");
    namesMap.put("CF", "Sentrafríka");
    namesMap.put("CG", "Kongo");
    namesMap.put("CH", "Switzɛrland");
    namesMap.put("CI", "Kote d´Ivoire");
    namesMap.put("CK", "Maŋ́ má Kook");
    namesMap.put("CL", "Tshili");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Shine");
    namesMap.put("CO", "Kɔlɔ́mbia");
    namesMap.put("CR", "Kosta Ríka");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Maŋ́ má Kapvɛr");
    namesMap.put("CY", "Sipria");
    namesMap.put("CZ", "Nlambɔ́ bó tschɛk");
    namesMap.put("DE", "Jaman");
    namesMap.put("DJ", "Jibúti");
    namesMap.put("DK", "Danemark");
    namesMap.put("DM", "Dominíka");
    namesMap.put("DO", "Nlambɔ́ Dominíka");
    namesMap.put("EC", "Ekuateur");
    namesMap.put("EE", "Ɛstonia");
    namesMap.put("EG", "Ägyptɛn");
    namesMap.put("ER", "Erytrea");
    namesMap.put("ES", "Paŋá");
    namesMap.put("ET", "Ethiopiá");
    namesMap.put("FI", "Finlande");
    namesMap.put("FJ", "Fijiá");
    namesMap.put("FK", "Maŋ má Falkland");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FR", "Fala");
    namesMap.put("GA", "Gabɔŋ");
    namesMap.put("GB", "Nlambɔ́ Ngɛlɛn");
    namesMap.put("GE", "Jɔrgia");
    namesMap.put("GF", "Guyane Fala");
    namesMap.put("GH", "Gána");
    namesMap.put("GI", "Gilbratar");
    namesMap.put("GN", "Guine");
    namesMap.put("GP", "Guadeloup");
    namesMap.put("GQ", "Guine Ekuatorial");
    namesMap.put("GR", "Grɛce");
    namesMap.put("GW", "Guine Bisso");
    namesMap.put("HN", "Ɔndúras");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HT", "Haïti");
    namesMap.put("HU", "Ɔngría");
    namesMap.put("IE", "Irland");
    namesMap.put("IL", "Äsrɛl");
    namesMap.put("IO", "Nlambɔ́ ngɛlɛn ma yí maŋ ntsiɛh");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Island");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Jɔrdania");
    namesMap.put("JP", "Japɔn");
    namesMap.put("KE", "Kɛnya");
    namesMap.put("KG", "Kyrgystaŋ");
    namesMap.put("KH", "Kambodia");
    namesMap.put("KM", "Kɔmɔr");
    namesMap.put("KN", "Saint Kitts na Nevis");
    namesMap.put("KP", "Koré yí bvuɔ");
    namesMap.put("KR", "Koré yí sí");
    namesMap.put("KW", "Kowɛit");
    namesMap.put("KY", "Maŋ́ má kumbi");
    namesMap.put("KZ", "Kazakstaŋ");
    namesMap.put("LB", "Libaŋ");
    namesMap.put("LI", "Lishenstein");
    namesMap.put("LS", "Lesoto");
    namesMap.put("LT", "Lituaniá");
    namesMap.put("MA", "Marɔk");
    namesMap.put("MC", "Monako");
    namesMap.put("MD", "Mɔldavia");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Maŋ́ má Marshall");
    namesMap.put("MK", "Macedonia");
    namesMap.put("MM", "Myanmar");
    namesMap.put("MN", "Mɔngolia");
    namesMap.put("MP", "Maŋ́ Mariá");
    namesMap.put("MQ", "Martinika");
    namesMap.put("MR", "Moritania");
    namesMap.put("MS", "Mɔnserrat");
    namesMap.put("MU", "Morisse");
    namesMap.put("MV", "Maldivia");
    namesMap.put("MX", "Mɛxik");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Kaledoni nwanah");
    namesMap.put("NF", "Maŋ́ má Nɔrfɔrk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Nedɛrland");
    namesMap.put("NO", "Nɔrvɛg");
    namesMap.put("NR", "Noru");
    namesMap.put("NU", "Niuɛ");
    namesMap.put("NZ", "Zeland nwanah");
    namesMap.put("PF", "Polynesia Fala");
    namesMap.put("PG", "Guine Papuasi");
    namesMap.put("PH", "Filipin");
    namesMap.put("PL", "Pɔlɔŋ");
    namesMap.put("PM", "Saint Peter ba Mikelɔn");
    namesMap.put("PN", "Pitkairn");
    namesMap.put("PR", "Puɛrto Riko");
    namesMap.put("PS", "Palɛstin");
    namesMap.put("PT", "Pɔrtugal");
    namesMap.put("PW", "Palo");
    namesMap.put("QA", "Katar");
    namesMap.put("RE", "Réuniɔn");
    namesMap.put("RO", "Roumania");
    namesMap.put("RU", "Russi");
    namesMap.put("SB", "Maŋ́ má Salomɔn");
    namesMap.put("SC", "Seychɛlle");
    namesMap.put("SD", "Sudaŋ");
    namesMap.put("SE", "Suɛd");
    namesMap.put("SG", "Singapur");
    namesMap.put("SH", "Saint Lina");
    namesMap.put("SL", "Sierra Leɔn");
    namesMap.put("SO", "Somália");
    namesMap.put("SR", "Surinam");
    namesMap.put("ST", "Sao Tomé ba Prinship");
    namesMap.put("SV", "Salvadɔr");
    namesMap.put("TC", "Maŋ́ má Turk na Kaiko");
    namesMap.put("TD", "Tshad");
    namesMap.put("TH", "Taïland");
    namesMap.put("TJ", "Tajikistaŋ");
    namesMap.put("TK", "Tokelo");
    namesMap.put("TL", "Timɔr tsindikēh");
    namesMap.put("TM", "Turkmɛnistaŋ");
    namesMap.put("TN", "Tunisiá");
    namesMap.put("TO", "Tɔnga");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad ba Tobágó");
    namesMap.put("TV", "Tuvalú");
    namesMap.put("TW", "Taïwan");
    namesMap.put("TZ", "Tanzánía");
    namesMap.put("UA", "Ukrɛn");
    namesMap.put("US", "Amɛŕka");
    namesMap.put("UZ", "Usbǝkistaŋ");
    namesMap.put("VA", "Vatikaŋ");
    namesMap.put("VC", "Saint Vincent ba Grenadines");
    namesMap.put("VE", "Vǝnǝzuela");
    namesMap.put("VG", "Minsilɛ́ mímaŋ mí ngɛ̄lɛ̄n");
    namesMap.put("VI", "Minsilɛ mí maŋ́ m´Amɛrka");
    namesMap.put("VN", "Viɛtnam");
    namesMap.put("WF", "Wallis ba Futuna");
    namesMap.put("YE", "Yǝmɛn");
    namesMap.put("YT", "Mayɔt");
    namesMap.put("ZA", "Afríka yí sí");
    namesMap.put("ZW", "Zimbabwǝ");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "AD": "Andɔ́ra",
        "AE": "Minlambɔ́ Nsaŋ́nsa mí Arabia",
        "AF": "Afganistaŋ",
        "AG": "Antíga bá Barbúda",
        "AI": "Anguílla",
        "AM": "Arménia",
        "AN": "B'Antilles bó Nedɛrland",
        "AR": "Argentína",
        "AS": "Samoa m ́Amɛ́rka",
        "AT": "Ötrish",
        "AU": "Östraliá",
        "AW": "Árúba",
        "AZ": "Azerbaïjaŋ",
        "BA": "Bosnia na Ɛrzegovina",
        "BB": "Barbado",
        "BD": "Bɛŋgladɛsh",
        "BE": "Bɛlgik",
        "BM": "Bɛrmuda",
        "BN": "Brunɛi",
        "BR": "Brésil",
        "BT": "Butaŋ",
        "BZ": "Bɛliz",
        "CA": "Kanada",
        "CD": "Kongó Zaïre",
        "CF": "Sentrafríka",
        "CG": "Kongo",
        "CH": "Switzɛrland",
        "CI": "Kote d´Ivoire",
        "CK": "Maŋ́ má Kook",
        "CL": "Tshili",
        "CM": "Kamerun",
        "CN": "Shine",
        "CO": "Kɔlɔ́mbia",
        "CR": "Kosta Ríka",
        "CU": "Kuba",
        "CV": "Maŋ́ má Kapvɛr",
        "CY": "Sipria",
        "CZ": "Nlambɔ́ bó tschɛk",
        "DE": "Jaman",
        "DJ": "Jibúti",
        "DK": "Danemark",
        "DM": "Dominíka",
        "DO": "Nlambɔ́ Dominíka",
        "EC": "Ekuateur",
        "EE": "Ɛstonia",
        "EG": "Ägyptɛn",
        "ER": "Erytrea",
        "ES": "Paŋá",
        "ET": "Ethiopiá",
        "FI": "Finlande",
        "FJ": "Fijiá",
        "FK": "Maŋ má Falkland",
        "FM": "Mikronesia",
        "FR": "Fala",
        "GA": "Gabɔŋ",
        "GB": "Nlambɔ́ Ngɛlɛn",
        "GE": "Jɔrgia",
        "GF": "Guyane Fala",
        "GH": "Gána",
        "GI": "Gilbratar",
        "GN": "Guine",
        "GP": "Guadeloup",
        "GQ": "Guine Ekuatorial",
        "GR": "Grɛce",
        "GW": "Guine Bisso",
        "HN": "Ɔndúras",
        "HR": "Kroasia",
        "HT": "Haïti",
        "HU": "Ɔngría",
        "IE": "Irland",
        "IL": "Äsrɛl",
        "IO": "Nlambɔ́ ngɛlɛn ma yí maŋ ntsiɛh",
        "IQ": "Irak",
        "IS": "Island",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Jɔrdania",
        "JP": "Japɔn",
        "KE": "Kɛnya",
        "KG": "Kyrgystaŋ",
        "KH": "Kambodia",
        "KM": "Kɔmɔr",
        "KN": "Saint Kitts na Nevis",
        "KP": "Koré yí bvuɔ",
        "KR": "Koré yí sí",
        "KW": "Kowɛit",
        "KY": "Maŋ́ má kumbi",
        "KZ": "Kazakstaŋ",
        "LB": "Libaŋ",
        "LI": "Lishenstein",
        "LS": "Lesoto",
        "LT": "Lituaniá",
        "MA": "Marɔk",
        "MC": "Monako",
        "MD": "Mɔldavia",
        "MG": "Madagaskar",
        "MH": "Maŋ́ má Marshall",
        "MK": "Macedonia",
        "MM": "Myanmar",
        "MN": "Mɔngolia",
        "MP": "Maŋ́ Mariá",
        "MQ": "Martinika",
        "MR": "Moritania",
        "MS": "Mɔnserrat",
        "MU": "Morisse",
        "MV": "Maldivia",
        "MX": "Mɛxik",
        "MZ": "Mozambik",
        "NC": "Kaledoni nwanah",
        "NF": "Maŋ́ má Nɔrfɔrk",
        "NI": "Nikaragua",
        "NL": "Nedɛrland",
        "NO": "Nɔrvɛg",
        "NR": "Noru",
        "NU": "Niuɛ",
        "NZ": "Zeland nwanah",
        "PF": "Polynesia Fala",
        "PG": "Guine Papuasi",
        "PH": "Filipin",
        "PL": "Pɔlɔŋ",
        "PM": "Saint Peter ba Mikelɔn",
        "PN": "Pitkairn",
        "PR": "Puɛrto Riko",
        "PS": "Palɛstin",
        "PT": "Pɔrtugal",
        "PW": "Palo",
        "QA": "Katar",
        "RE": "Réuniɔn",
        "RO": "Roumania",
        "RU": "Russi",
        "SB": "Maŋ́ má Salomɔn",
        "SC": "Seychɛlle",
        "SD": "Sudaŋ",
        "SE": "Suɛd",
        "SG": "Singapur",
        "SH": "Saint Lina",
        "SL": "Sierra Leɔn",
        "SO": "Somália",
        "SR": "Surinam",
        "ST": "Sao Tomé ba Prinship",
        "SV": "Salvadɔr",
        "TC": "Maŋ́ má Turk na Kaiko",
        "TD": "Tshad",
        "TH": "Taïland",
        "TJ": "Tajikistaŋ",
        "TK": "Tokelo",
        "TL": "Timɔr tsindikēh",
        "TM": "Turkmɛnistaŋ",
        "TN": "Tunisiá",
        "TO": "Tɔnga",
        "TR": "Turki",
        "TT": "Trinidad ba Tobágó",
        "TV": "Tuvalú",
        "TW": "Taïwan",
        "TZ": "Tanzánía",
        "UA": "Ukrɛn",
        "US": "Amɛŕka",
        "UZ": "Usbǝkistaŋ",
        "VA": "Vatikaŋ",
        "VC": "Saint Vincent ba Grenadines",
        "VE": "Vǝnǝzuela",
        "VG": "Minsilɛ́ mímaŋ mí ngɛ̄lɛ̄n",
        "VI": "Minsilɛ mí maŋ́ m´Amɛrka",
        "VN": "Viɛtnam",
        "WF": "Wallis ba Futuna",
        "YE": "Yǝmɛn",
        "YT": "Mayɔt",
        "ZA": "Afríka yí sí",
        "ZW": "Zimbabwǝ"
    };
  }-*/;
}
