/*
 * Copyright 2012 Google Inc.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.i18n.client.impl.cldr;

import com.google.gwt.core.client.JavaScriptObject;

// DO NOT EDIT - GENERATED FROM CLDR DATA

/**
 * Localized names for the "id" locale.
 */
public class LocalizedNamesImpl_id extends LocalizedNamesImpl {

  @Override
  public String[] loadLikelyRegionCodes() {
    return new String[] {
        "ID",
    };
  }

  @Override
  public String[] loadSortedRegionCodes() {
    return new String[] {
        "AF",
        "ZA",
        "AL",
        "DZ",
        "US",
        "AD",
        "AO",
        "AI",
        "AQ",
        "AG",
        "SA",
        "AR",
        "AM",
        "AW",
        "AU",
        "AT",
        "AZ",
        "BS",
        "BH",
        "BD",
        "BB",
        "NL",
        "BQ",
        "BY",
        "BE",
        "BZ",
        "BJ",
        "BM",
        "BT",
        "BO",
        "BA",
        "BW",
        "BR",
        "BN",
        "BG",
        "BF",
        "BI",
        "TD",
        "CZ",
        "EA",
        "CL",
        "CW",
        "DK",
        "DG",
        "DM",
        "EC",
        "SV",
        "ER",
        "EE",
        "ET",
        "FJ",
        "PH",
        "FI",
        "GA",
        "GM",
        "GE",
        "GS",
        "GH",
        "GI",
        "GD",
        "GL",
        "GP",
        "GU",
        "GT",
        "GG",
        "GN",
        "GW",
        "GQ",
        "GY",
        "GF",
        "HT",
        "HN",
        "HK",
        "HU",
        "IN",
        "ID",
        "GB",
        "IQ",
        "IR",
        "IE",
        "IS",
        "IL",
        "IT",
        "JM",
        "JP",
        "DE",
        "JE",
        "DJ",
        "NC",
        "KH",
        "CM",
        "CA",
        "KZ",
        "KE",
        "AX",
        "IC",
        "KY",
        "CC",
        "CK",
        "FO",
        "FK",
        "MP",
        "MH",
        "NF",
        "PN",
        "SB",
        "SJ",
        "UM",
        "TC",
        "VI",
        "VG",
        "WF",
        "KG",
        "KI",
        "CO",
        "KM",
        "CG",
        "CD",
        "KR",
        "KP",
        "XK",
        "CR",
        "HR",
        "CU",
        "KW",
        "LA",
        "LV",
        "LB",
        "LS",
        "LR",
        "LY",
        "LI",
        "LT",
        "LU",
        "MG",
        "MO",
        "MK",
        "MV",
        "MW",
        "MY",
        "ML",
        "MT",
        "MA",
        "MQ",
        "MR",
        "MU",
        "YT",
        "MX",
        "EG",
        "FM",
        "MD",
        "MC",
        "MN",
        "ME",
        "MS",
        "MZ",
        "MM",
        "NA",
        "NR",
        "NP",
        "NE",
        "NG",
        "NI",
        "NU",
        "NO",
        "OM",
        "QO",
        "PK",
        "PW",
        "PA",
        "CI",
        "PG",
        "PY",
        "UN",
        "PE",
        "PL",
        "PF",
        "PT",
        "FR",
        "PR",
        "AC",
        "BV",
        "CX",
        "CP",
        "HM",
        "IM",
        "QA",
        "CF",
        "DO",
        "RE",
        "RO",
        "RU",
        "RW",
        "EH",
        "BL",
        "SH",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "WS",
        "AS",
        "SM",
        "ST",
        "NZ",
        "SN",
        "RS",
        "SC",
        "SL",
        "SG",
        "SX",
        "CY",
        "SK",
        "SI",
        "SO",
        "ES",
        "LK",
        "SD",
        "SS",
        "SY",
        "SR",
        "SZ",
        "SE",
        "CH",
        "TW",
        "TJ",
        "CV",
        "TZ",
        "TH",
        "TL",
        "CN",
        "TG",
        "TK",
        "TO",
        "TT",
        "TA",
        "TN",
        "TR",
        "TM",
        "TV",
        "UG",
        "UA",
        "AE",
        "EU",
        "UY",
        "UZ",
        "VU",
        "VA",
        "VE",
        "VN",
        "IO",
        "TF",
        "PS",
        "XA",
        "XB",
        "YE",
        "JO",
        "GR",
        "ZM",
        "ZW",
        "EZ",
    };
  }

  @Override
  protected void loadNameMapJava() {
    super.loadNameMapJava();
    namesMap.put("001", "Dunia");
    namesMap.put("002", "Afrika");
    namesMap.put("003", "Amerika Utara");
    namesMap.put("005", "Amerika Selatan");
    namesMap.put("009", "Oseania");
    namesMap.put("011", "Afrika Bagian Barat");
    namesMap.put("013", "Amerika Tengah");
    namesMap.put("014", "Afrika Bagian Timur");
    namesMap.put("015", "Afrika Bagian Utara");
    namesMap.put("017", "Afrika Bagian Tengah");
    namesMap.put("018", "Afrika Bagian Selatan");
    namesMap.put("019", "Amerika");
    namesMap.put("021", "Amerika Bagian Utara");
    namesMap.put("029", "Kepulauan Karibia");
    namesMap.put("030", "Asia Bagian Timur");
    namesMap.put("034", "Asia Bagian Selatan");
    namesMap.put("035", "Asia Tenggara");
    namesMap.put("039", "Eropa Bagian Selatan");
    namesMap.put("057", "Wilayah Mikronesia");
    namesMap.put("061", "Polinesia");
    namesMap.put("143", "Asia Tengah");
    namesMap.put("145", "Asia Bagian Barat");
    namesMap.put("150", "Eropa");
    namesMap.put("151", "Eropa Bagian Timur");
    namesMap.put("154", "Eropa Bagian Utara");
    namesMap.put("155", "Eropa Bagian Barat");
    namesMap.put("202", "Afrika Sub-Sahara");
    namesMap.put("419", "Amerika Latin");
    namesMap.put("AC", "Pulau Ascension");
    namesMap.put("AE", "Uni Emirat Arab");
    namesMap.put("AF", "Afganistan");
    namesMap.put("AG", "Antigua dan Barbuda");
    namesMap.put("AQ", "Antartika");
    namesMap.put("AS", "Samoa Amerika");
    namesMap.put("AX", "Kepulauan Aland");
    namesMap.put("BA", "Bosnia dan Herzegovina");
    namesMap.put("BE", "Belgia");
    namesMap.put("BL", "Saint Barthélemy");
    namesMap.put("BQ", "Belanda Karibia");
    namesMap.put("BR", "Brasil");
    namesMap.put("BS", "Bahama");
    namesMap.put("BV", "Pulau Bouvet");
    namesMap.put("CA", "Kanada");
    namesMap.put("CC", "Kepulauan Cocos (Keeling)");
    namesMap.put("CD", "Kongo - Kinshasa");
    namesMap.put("CF", "Republik Afrika Tengah");
    namesMap.put("CG", "Kongo - Brazzaville");
    namesMap.put("CH", "Swiss");
    namesMap.put("CI", "Pantai Gading");
    namesMap.put("CK", "Kepulauan Cook");
    namesMap.put("CL", "Cile");
    namesMap.put("CM", "Kamerun");
    namesMap.put("CN", "Tiongkok");
    namesMap.put("CO", "Kolombia");
    namesMap.put("CP", "Pulau Clipperton");
    namesMap.put("CR", "Kosta Rika");
    namesMap.put("CU", "Kuba");
    namesMap.put("CV", "Tanjung Verde");
    namesMap.put("CX", "Pulau Christmas");
    namesMap.put("CY", "Siprus");
    namesMap.put("CZ", "Ceko");
    namesMap.put("DE", "Jerman");
    namesMap.put("DJ", "Jibuti");
    namesMap.put("DM", "Dominika");
    namesMap.put("DO", "Republik Dominika");
    namesMap.put("DZ", "Aljazair");
    namesMap.put("EA", "Ceuta dan Melilla");
    namesMap.put("EC", "Ekuador");
    namesMap.put("EG", "Mesir");
    namesMap.put("EH", "Sahara Barat");
    namesMap.put("ES", "Spanyol");
    namesMap.put("ET", "Etiopia");
    namesMap.put("EU", "Uni Eropa");
    namesMap.put("EZ", "Zona Euro");
    namesMap.put("FI", "Finlandia");
    namesMap.put("FK", "Kepulauan Malvinas");
    namesMap.put("FM", "Mikronesia");
    namesMap.put("FO", "Kepulauan Faroe");
    namesMap.put("FR", "Prancis");
    namesMap.put("GB", "Inggris Raya");
    namesMap.put("GF", "Guyana Prancis");
    namesMap.put("GL", "Grinlandia");
    namesMap.put("GQ", "Guinea Ekuatorial");
    namesMap.put("GR", "Yunani");
    namesMap.put("GS", "Georgia Selatan & Kep. Sandwich Selatan");
    namesMap.put("HK", "Hong Kong SAR Tiongkok");
    namesMap.put("HM", "Pulau Heard dan Kepulauan McDonald");
    namesMap.put("HR", "Kroasia");
    namesMap.put("HU", "Hungaria");
    namesMap.put("IC", "Kepulauan Canary");
    namesMap.put("IE", "Irlandia");
    namesMap.put("IM", "Pulau Man");
    namesMap.put("IO", "Wilayah Inggris di Samudra Hindia");
    namesMap.put("IQ", "Irak");
    namesMap.put("IS", "Islandia");
    namesMap.put("IT", "Italia");
    namesMap.put("JM", "Jamaika");
    namesMap.put("JO", "Yordania");
    namesMap.put("JP", "Jepang");
    namesMap.put("KG", "Kirgistan");
    namesMap.put("KH", "Kamboja");
    namesMap.put("KM", "Komoro");
    namesMap.put("KN", "Saint Kitts dan Nevis");
    namesMap.put("KP", "Korea Utara");
    namesMap.put("KR", "Korea Selatan");
    namesMap.put("KY", "Kepulauan Cayman");
    namesMap.put("KZ", "Kazakstan");
    namesMap.put("LC", "Saint Lucia");
    namesMap.put("LT", "Lituania");
    namesMap.put("LU", "Luksemburg");
    namesMap.put("LY", "Libia");
    namesMap.put("MA", "Maroko");
    namesMap.put("MC", "Monako");
    namesMap.put("MF", "Saint Martin");
    namesMap.put("MG", "Madagaskar");
    namesMap.put("MH", "Kepulauan Marshall");
    namesMap.put("MK", "Makedonia");
    namesMap.put("MO", "Makau SAR Tiongkok");
    namesMap.put("MP", "Kepulauan Mariana Utara");
    namesMap.put("MQ", "Martinik");
    namesMap.put("MV", "Maladewa");
    namesMap.put("MX", "Meksiko");
    namesMap.put("MZ", "Mozambik");
    namesMap.put("NC", "Kaledonia Baru");
    namesMap.put("NF", "Kepulauan Norfolk");
    namesMap.put("NI", "Nikaragua");
    namesMap.put("NL", "Belanda");
    namesMap.put("NO", "Norwegia");
    namesMap.put("NZ", "Selandia Baru");
    namesMap.put("PF", "Polinesia Prancis");
    namesMap.put("PG", "Papua Nugini");
    namesMap.put("PH", "Filipina");
    namesMap.put("PL", "Polandia");
    namesMap.put("PM", "Saint Pierre dan Miquelon");
    namesMap.put("PN", "Kepulauan Pitcairn");
    namesMap.put("PR", "Puerto Riko");
    namesMap.put("PS", "Wilayah Palestina");
    namesMap.put("QO", "Oseania Luar");
    namesMap.put("RO", "Rumania");
    namesMap.put("RU", "Rusia");
    namesMap.put("SA", "Arab Saudi");
    namesMap.put("SB", "Kepulauan Solomon");
    namesMap.put("SE", "Swedia");
    namesMap.put("SG", "Singapura");
    namesMap.put("SH", "Saint Helena");
    namesMap.put("SJ", "Kepulauan Svalbard dan Jan Mayen");
    namesMap.put("SS", "Sudan Selatan");
    namesMap.put("ST", "Sao Tome dan Principe");
    namesMap.put("SY", "Suriah");
    namesMap.put("TC", "Kepulauan Turks dan Caicos");
    namesMap.put("TD", "Cad");
    namesMap.put("TF", "Wilayah Kutub Selatan Prancis");
    namesMap.put("TL", "Timor Leste");
    namesMap.put("TM", "Turkimenistan");
    namesMap.put("TR", "Turki");
    namesMap.put("TT", "Trinidad dan Tobago");
    namesMap.put("UA", "Ukraina");
    namesMap.put("UM", "Kepulauan Terluar A.S.");
    namesMap.put("UN", "Perserikatan Bangsa-Bangsa");
    namesMap.put("US", "Amerika Serikat");
    namesMap.put("VA", "Vatikan");
    namesMap.put("VC", "Saint Vincent dan Grenadines");
    namesMap.put("VG", "Kepulauan Virgin Inggris");
    namesMap.put("VI", "Kepulauan Virgin A.S.");
    namesMap.put("WF", "Kepulauan Wallis dan Futuna");
    namesMap.put("YE", "Yaman");
    namesMap.put("ZA", "Afrika Selatan");
    namesMap.put("ZZ", "Wilayah Tidak Dikenal");
  }

  @Override
  protected JavaScriptObject loadNameMapNative() {
    return overrideMap(super.loadNameMapNative(), loadMyNameMap());
  }

  private native JavaScriptObject loadMyNameMap() /*-{
    return {
        "001": "Dunia",
        "002": "Afrika",
        "003": "Amerika Utara",
        "005": "Amerika Selatan",
        "009": "Oseania",
        "011": "Afrika Bagian Barat",
        "013": "Amerika Tengah",
        "014": "Afrika Bagian Timur",
        "015": "Afrika Bagian Utara",
        "017": "Afrika Bagian Tengah",
        "018": "Afrika Bagian Selatan",
        "019": "Amerika",
        "021": "Amerika Bagian Utara",
        "029": "Kepulauan Karibia",
        "030": "Asia Bagian Timur",
        "034": "Asia Bagian Selatan",
        "035": "Asia Tenggara",
        "039": "Eropa Bagian Selatan",
        "057": "Wilayah Mikronesia",
        "061": "Polinesia",
        "143": "Asia Tengah",
        "145": "Asia Bagian Barat",
        "150": "Eropa",
        "151": "Eropa Bagian Timur",
        "154": "Eropa Bagian Utara",
        "155": "Eropa Bagian Barat",
        "202": "Afrika Sub-Sahara",
        "419": "Amerika Latin",
        "AC": "Pulau Ascension",
        "AE": "Uni Emirat Arab",
        "AF": "Afganistan",
        "AG": "Antigua dan Barbuda",
        "AQ": "Antartika",
        "AS": "Samoa Amerika",
        "AX": "Kepulauan Aland",
        "BA": "Bosnia dan Herzegovina",
        "BE": "Belgia",
        "BL": "Saint Barthélemy",
        "BQ": "Belanda Karibia",
        "BR": "Brasil",
        "BS": "Bahama",
        "BV": "Pulau Bouvet",
        "CA": "Kanada",
        "CC": "Kepulauan Cocos (Keeling)",
        "CD": "Kongo - Kinshasa",
        "CF": "Republik Afrika Tengah",
        "CG": "Kongo - Brazzaville",
        "CH": "Swiss",
        "CI": "Pantai Gading",
        "CK": "Kepulauan Cook",
        "CL": "Cile",
        "CM": "Kamerun",
        "CN": "Tiongkok",
        "CO": "Kolombia",
        "CP": "Pulau Clipperton",
        "CR": "Kosta Rika",
        "CU": "Kuba",
        "CV": "Tanjung Verde",
        "CX": "Pulau Christmas",
        "CY": "Siprus",
        "CZ": "Ceko",
        "DE": "Jerman",
        "DJ": "Jibuti",
        "DM": "Dominika",
        "DO": "Republik Dominika",
        "DZ": "Aljazair",
        "EA": "Ceuta dan Melilla",
        "EC": "Ekuador",
        "EG": "Mesir",
        "EH": "Sahara Barat",
        "ES": "Spanyol",
        "ET": "Etiopia",
        "EU": "Uni Eropa",
        "EZ": "Zona Euro",
        "FI": "Finlandia",
        "FK": "Kepulauan Malvinas",
        "FM": "Mikronesia",
        "FO": "Kepulauan Faroe",
        "FR": "Prancis",
        "GB": "Inggris Raya",
        "GF": "Guyana Prancis",
        "GL": "Grinlandia",
        "GQ": "Guinea Ekuatorial",
        "GR": "Yunani",
        "GS": "Georgia Selatan & Kep. Sandwich Selatan",
        "HK": "Hong Kong SAR Tiongkok",
        "HM": "Pulau Heard dan Kepulauan McDonald",
        "HR": "Kroasia",
        "HU": "Hungaria",
        "IC": "Kepulauan Canary",
        "IE": "Irlandia",
        "IM": "Pulau Man",
        "IO": "Wilayah Inggris di Samudra Hindia",
        "IQ": "Irak",
        "IS": "Islandia",
        "IT": "Italia",
        "JM": "Jamaika",
        "JO": "Yordania",
        "JP": "Jepang",
        "KG": "Kirgistan",
        "KH": "Kamboja",
        "KM": "Komoro",
        "KN": "Saint Kitts dan Nevis",
        "KP": "Korea Utara",
        "KR": "Korea Selatan",
        "KY": "Kepulauan Cayman",
        "KZ": "Kazakstan",
        "LC": "Saint Lucia",
        "LT": "Lituania",
        "LU": "Luksemburg",
        "LY": "Libia",
        "MA": "Maroko",
        "MC": "Monako",
        "MF": "Saint Martin",
        "MG": "Madagaskar",
        "MH": "Kepulauan Marshall",
        "MK": "Makedonia",
        "MO": "Makau SAR Tiongkok",
        "MP": "Kepulauan Mariana Utara",
        "MQ": "Martinik",
        "MV": "Maladewa",
        "MX": "Meksiko",
        "MZ": "Mozambik",
        "NC": "Kaledonia Baru",
        "NF": "Kepulauan Norfolk",
        "NI": "Nikaragua",
        "NL": "Belanda",
        "NO": "Norwegia",
        "NZ": "Selandia Baru",
        "PF": "Polinesia Prancis",
        "PG": "Papua Nugini",
        "PH": "Filipina",
        "PL": "Polandia",
        "PM": "Saint Pierre dan Miquelon",
        "PN": "Kepulauan Pitcairn",
        "PR": "Puerto Riko",
        "PS": "Wilayah Palestina",
        "QO": "Oseania Luar",
        "RO": "Rumania",
        "RU": "Rusia",
        "SA": "Arab Saudi",
        "SB": "Kepulauan Solomon",
        "SE": "Swedia",
        "SG": "Singapura",
        "SH": "Saint Helena",
        "SJ": "Kepulauan Svalbard dan Jan Mayen",
        "SS": "Sudan Selatan",
        "ST": "Sao Tome dan Principe",
        "SY": "Suriah",
        "TC": "Kepulauan Turks dan Caicos",
        "TD": "Cad",
        "TF": "Wilayah Kutub Selatan Prancis",
        "TL": "Timor Leste",
        "TM": "Turkimenistan",
        "TR": "Turki",
        "TT": "Trinidad dan Tobago",
        "UA": "Ukraina",
        "UM": "Kepulauan Terluar A.S.",
        "UN": "Perserikatan Bangsa-Bangsa",
        "US": "Amerika Serikat",
        "VA": "Vatikan",
        "VC": "Saint Vincent dan Grenadines",
        "VG": "Kepulauan Virgin Inggris",
        "VI": "Kepulauan Virgin A.S.",
        "WF": "Kepulauan Wallis dan Futuna",
        "YE": "Yaman",
        "ZA": "Afrika Selatan",
        "ZZ": "Wilayah Tidak Dikenal"
    };
  }-*/;
}
