Contributing
============

We're really happy to get bug fixes and contributions to Stanford CoreNLP.

However, Stanford CoreNLP is copyright by Stanford. (Technically, by The Board of Trustees of The Leland Stanford Junior University.) As well as the open source GPL version of Stanford CoreNLP, it is available for licensing from Stanford.

In order for us to continue to be able to dual-license Stanford CoreNLP, we need to make sure that contributions from others do not restrict Stanford from separately licensing the code.

Therefore, we can accept contributions on any of the following terms:

 * If your contribution is a bug fix of 6 lines or less of new code, we will accept it on the basis that both you and us regard the contribution as de minimis, and not requiring further hassle.
 * You can declare that the contribution is in the public domain (in your commit message or pull request).
 * You can make your contribution available under a non-restrictive open source license, such as the Revised (or 3-clause) BSD license, with appropriate licensing information included with the submitted code.
 * You can sign and return to us a contributor license agreement (CLA), explicitly licensing us to be able to use the code.
   There is a [Contributor License Agreement for Individuals](http://nlp.stanford.edu/software/CLA/individual.html) and
   a [Contributor License Agreement for Corporations](http://nlp.stanford.edu/software/CLA/corporate.html).
   You can send them to us or contact us at: java-nlp-support@lists.stanford.edu .

You should do development against our master branch. The project's source code is in utf-8 character encoding. You should make sure that all unit tests still pass. (In general, you will not be able to run our integration tests, since they rely on resources in our filesystem.)
