/*
 * Decompiled with CFR 0.152.
 */
package org.junit.contrib.theories;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.AssumptionViolatedException;
import org.junit.contrib.theories.DataPoint;
import org.junit.contrib.theories.DataPoints;
import org.junit.contrib.theories.ParameterSignature;
import org.junit.contrib.theories.ParameterSupplier;
import org.junit.contrib.theories.ParametersSuppliedBy;
import org.junit.contrib.theories.PotentialAssignment;
import org.junit.contrib.theories.Theory;
import org.junit.contrib.theories.internal.Assignments;
import org.junit.contrib.theories.internal.ParameterizedAssertionError;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Theories
extends BlockJUnit4ClassRunner {
    public Theories(Class<?> klass) throws InitializationError {
        super(klass);
    }

    protected void collectInitializationErrors(List<Throwable> errors) {
        super.collectInitializationErrors(errors);
        this.validateDataPointFields(errors);
        this.validateDataPointMethods(errors);
    }

    private void validateDataPointFields(List<Throwable> errors) {
        for (Field each : this.getTestClass().getJavaClass().getDeclaredFields()) {
            if (each.getAnnotation(DataPoint.class) == null && each.getAnnotation(DataPoints.class) == null) continue;
            if (!Modifier.isStatic(each.getModifiers())) {
                errors.add(new Error("DataPoint field " + each.getName() + " must be static"));
            }
            if (Modifier.isPublic(each.getModifiers())) continue;
            errors.add(new Error("DataPoint field " + each.getName() + " must be public"));
        }
    }

    private void validateDataPointMethods(List<Throwable> errors) {
        for (Method each : this.getTestClass().getJavaClass().getDeclaredMethods()) {
            if (each.getAnnotation(DataPoint.class) == null && each.getAnnotation(DataPoints.class) == null) continue;
            if (!Modifier.isStatic(each.getModifiers())) {
                errors.add(new Error("DataPoint method " + each.getName() + " must be static"));
            }
            if (Modifier.isPublic(each.getModifiers())) continue;
            errors.add(new Error("DataPoint method " + each.getName() + " must be public"));
        }
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateOnlyOneConstructor(errors);
    }

    protected void validateTestMethods(List<Throwable> errors) {
        for (FrameworkMethod each : this.computeTestMethods()) {
            if (each.getAnnotation(Theory.class) != null) {
                each.validatePublicVoid(false, errors);
                each.validateNoTypeParametersOnArgs(errors);
            } else {
                each.validatePublicVoidNoArg(false, errors);
            }
            for (ParameterSignature sig : ParameterSignature.signatures(each.getMethod())) {
                ParametersSuppliedBy annotation = sig.findDeepAnnotation(ParametersSuppliedBy.class);
                if (annotation == null) continue;
                this.validateParameterSupplier(annotation.value(), errors);
            }
        }
    }

    private void validateParameterSupplier(Class<? extends ParameterSupplier> supplierClass, List<Throwable> errors) {
        Constructor<?>[] constructors = supplierClass.getConstructors();
        if (constructors.length != 1) {
            errors.add(new Error("ParameterSupplier " + supplierClass.getName() + " must have only one constructor (either empty or taking only a TestClass)"));
        } else {
            Class<?>[] paramTypes = constructors[0].getParameterTypes();
            if (paramTypes.length != 0 && !paramTypes[0].equals(TestClass.class)) {
                errors.add(new Error("ParameterSupplier " + supplierClass.getName() + " constructor must take either nothing or a single TestClass instance"));
            }
        }
    }

    protected List<FrameworkMethod> computeTestMethods() {
        ArrayList<FrameworkMethod> testMethods = new ArrayList<FrameworkMethod>(super.computeTestMethods());
        List theoryMethods = this.getTestClass().getAnnotatedMethods(Theory.class);
        testMethods.removeAll(theoryMethods);
        testMethods.addAll(theoryMethods);
        return testMethods;
    }

    public Statement methodBlock(FrameworkMethod method) {
        return new TheoryAnchor(method, this.getTestClass());
    }

    public static class TheoryAnchor
    extends Statement {
        private final FrameworkMethod fTestMethod;
        private final TestClass fTestClass;
        private final List<AssumptionViolatedException> fInvalidParameters = new ArrayList<AssumptionViolatedException>();
        private int successes = 0;

        public TheoryAnchor(FrameworkMethod method, TestClass testClass) {
            this.fTestMethod = method;
            this.fTestClass = testClass;
        }

        private TestClass getTestClass() {
            return this.fTestClass;
        }

        public void evaluate() throws Throwable {
            boolean hasTheoryAnnotation;
            this.runWithAssignment(Assignments.allUnassigned(this.fTestMethod.getMethod(), this.getTestClass()));
            boolean bl = hasTheoryAnnotation = this.fTestMethod.getAnnotation(Theory.class) != null;
            if (this.successes == 0 && hasTheoryAnnotation) {
                Assert.fail((String)("Never found parameters that satisfied method assumptions.  Violated assumptions: " + this.fInvalidParameters));
            }
        }

        protected void runWithAssignment(Assignments parameterAssignment) throws Throwable {
            if (!parameterAssignment.isComplete()) {
                this.runWithIncompleteAssignment(parameterAssignment);
            } else {
                this.runWithCompleteAssignment(parameterAssignment);
            }
        }

        protected void runWithIncompleteAssignment(Assignments incomplete) throws Throwable {
            for (PotentialAssignment each : incomplete.potentialsForNextUnassigned()) {
                this.runWithAssignment(incomplete.assignNext(each));
            }
        }

        protected void runWithCompleteAssignment(final Assignments complete) throws Throwable {
            new BlockJUnit4ClassRunner(this.getTestClass().getJavaClass()){

                protected void collectInitializationErrors(List<Throwable> errors) {
                }

                public Statement methodBlock(FrameworkMethod method) {
                    final Statement statement = super.methodBlock(method);
                    return new Statement(){

                        public void evaluate() throws Throwable {
                            try {
                                statement.evaluate();
                                TheoryAnchor.this.handleDataPointSuccess();
                            }
                            catch (AssumptionViolatedException e) {
                                TheoryAnchor.this.handleAssumptionViolation(e);
                            }
                            catch (Throwable e) {
                                TheoryAnchor.this.reportParameterizedError(e, complete.getArgumentStrings());
                            }
                        }
                    };
                }

                protected Statement methodInvoker(FrameworkMethod method, Object test) {
                    return TheoryAnchor.this.methodCompletesWithParameters(method, complete, test);
                }

                public Object createTest() throws Exception {
                    Object[] params = complete.getConstructorArguments();
                    if (!TheoryAnchor.this.nullsOk()) {
                        Assume.assumeNotNull((Object[])params);
                    }
                    return this.getTestClass().getOnlyConstructor().newInstance(params);
                }
            }.methodBlock(this.fTestMethod).evaluate();
        }

        private Statement methodCompletesWithParameters(final FrameworkMethod method, final Assignments complete, final Object freshInstance) {
            return new Statement(){

                public void evaluate() throws Throwable {
                    Object[] values = complete.getMethodArguments();
                    if (!TheoryAnchor.this.nullsOk()) {
                        Assume.assumeNotNull((Object[])values);
                    }
                    method.invokeExplosively(freshInstance, values);
                }
            };
        }

        protected void handleAssumptionViolation(AssumptionViolatedException e) {
            this.fInvalidParameters.add(e);
        }

        protected void reportParameterizedError(Throwable e, Object ... params) throws Throwable {
            if (params.length == 0) {
                throw e;
            }
            throw new ParameterizedAssertionError(e, this.fTestMethod.getName(), params);
        }

        private boolean nullsOk() {
            Theory annotation = this.fTestMethod.getMethod().getAnnotation(Theory.class);
            return annotation != null && annotation.nullsAccepted();
        }

        protected void handleDataPointSuccess() {
            ++this.successes;
        }
    }
}

