/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.typedef;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import org.javaruntype.typedef.BoundedTypeDefVariable;
import org.javaruntype.typedef.InnerClassTypeDefVariable;
import org.javaruntype.typedef.InnerNamedTypeDefVariable;
import org.javaruntype.typedef.InnerParameterizedTypeTypeDefVariable;
import org.javaruntype.typedef.InnerTypeDefVariable;
import org.javaruntype.typedef.InnerWildcardTypeDefVariable;
import org.javaruntype.typedef.NamedTypeDefVariable;
import org.javaruntype.typedef.TypeDef;
import org.javaruntype.typedef.TypeDefVariable;
import org.javaruntype.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeDefUtil {
    private static final Type[] OBJECT_BOUNDS = new Type[]{Object.class};

    static TypeDef forClass(Class<?> typeClass) {
        if (typeClass.isArray()) {
            throw new IllegalArgumentException("Cannot create TypeDef from array class");
        }
        TypeVariable<Class<?>>[] typeVariables = typeClass.getTypeParameters();
        TypeDefVariable[] typeDefVariables = new TypeDefVariable[typeVariables.length];
        for (int i = 0; i < typeVariables.length; ++i) {
            String variableName = typeVariables[i].getName();
            Object[] bounds = typeVariables[i].getBounds();
            if (Utils.isArrayEqual(OBJECT_BOUNDS, bounds)) {
                typeDefVariables[i] = new NamedTypeDefVariable(variableName);
                continue;
            }
            InnerTypeDefVariable[] innerVariables = new InnerTypeDefVariable[bounds.length];
            for (int j = 0; j < bounds.length; ++j) {
                innerVariables[j] = TypeDefUtil.getInnerTypeDefDeclaration((Type)bounds[j], 0);
            }
            typeDefVariables[i] = new BoundedTypeDefVariable(variableName, innerVariables);
        }
        return new TypeDef(typeClass, typeDefVariables);
    }

    private static InnerTypeDefVariable getInnerTypeDefDeclaration(Type typeDeclaration, int arrayDimensions) {
        if (typeDeclaration instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)typeDeclaration;
            Class typeClass = (Class)parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            InnerTypeDefVariable[] innerVariables = new InnerTypeDefVariable[typeArguments.length];
            for (int i = 0; i < typeArguments.length; ++i) {
                innerVariables[i] = TypeDefUtil.getInnerTypeDefDeclaration(typeArguments[i], 0);
            }
            return new InnerParameterizedTypeTypeDefVariable(typeClass, innerVariables, arrayDimensions);
        }
        if (typeDeclaration instanceof TypeVariable) {
            return new InnerNamedTypeDefVariable(((TypeVariable)typeDeclaration).getName(), arrayDimensions);
        }
        if (typeDeclaration instanceof GenericArrayType) {
            return TypeDefUtil.getInnerTypeDefDeclaration(((GenericArrayType)typeDeclaration).getGenericComponentType(), arrayDimensions + 1);
        }
        if (typeDeclaration instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)typeDeclaration;
            if (!Utils.isArrayEqual(OBJECT_BOUNDS, wildcardType.getUpperBounds())) {
                InnerTypeDefVariable upperBound = TypeDefUtil.getInnerTypeDefDeclaration(wildcardType.getUpperBounds()[0], 0);
                return new InnerWildcardTypeDefVariable(upperBound, null);
            }
            if (!Utils.isArrayEqual(OBJECT_BOUNDS, wildcardType.getLowerBounds())) {
                InnerTypeDefVariable lowerBound = TypeDefUtil.getInnerTypeDefDeclaration(wildcardType.getLowerBounds()[0], 0);
                return new InnerWildcardTypeDefVariable(null, lowerBound);
            }
            return new InnerWildcardTypeDefVariable(null, null);
        }
        return new InnerClassTypeDefVariable((Class)typeDeclaration, arrayDimensions);
    }

    private TypeDefUtil() {
    }
}

