/*
 * Decompiled with CFR 0.152.
 */
package org.javaruntype.type;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.antlr.runtime.tree.Tree;
import org.javaruntype.exceptions.TypeRecognitionException;
import org.javaruntype.exceptions.TypeValidationException;
import org.javaruntype.type.ExtendsTypeParameter;
import org.javaruntype.type.StandardTypeParameter;
import org.javaruntype.type.SuperTypeParameter;
import org.javaruntype.type.Type;
import org.javaruntype.type.TypeParameter;
import org.javaruntype.type.TypeParameters;
import org.javaruntype.type.TypeRegistry;
import org.javaruntype.type.Types;
import org.javaruntype.type.WildcardTypeParameter;
import org.javaruntype.type.parser.TypeLexer;
import org.javaruntype.type.parser.TypeParser;
import org.javaruntype.typedef.BoundedTypeDefVariable;
import org.javaruntype.typedef.InnerClassTypeDefVariable;
import org.javaruntype.typedef.InnerNamedTypeDefVariable;
import org.javaruntype.typedef.InnerParameterizedTypeTypeDefVariable;
import org.javaruntype.typedef.InnerTypeDefVariable;
import org.javaruntype.typedef.InnerWildcardTypeDefVariable;
import org.javaruntype.typedef.NamedTypeDefVariable;
import org.javaruntype.typedef.TypeDef;
import org.javaruntype.typedef.TypeDefVariable;
import org.javaruntype.typedef.TypeDefs;
import org.javaruntype.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TypeUtil {
    static Type<?> forName(String typeName) {
        try {
            String parsedTypeName = typeName.startsWith("class ") ? typeName.substring("class ".length()) : (typeName.startsWith("interface ") ? typeName.substring("interface ".length()) : typeName);
            TypeLexer lex = new TypeLexer((CharStream)new ANTLRStringStream(parsedTypeName));
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lex);
            TypeParser parser = new TypeParser((TokenStream)tokens);
            CommonTree tree = (CommonTree)parser.type().getTree();
            return TypeUtil.createTypeFromTree((Tree)tree);
        }
        catch (Exception e) {
            throw new TypeRecognitionException(typeName, e);
        }
    }

    private static Type<?> createTypeFromTree(Tree tree) throws ClassNotFoundException {
        int i;
        if (tree.getType() != 13) {
            throw new TypeRecognitionException("A class name was expected (was: " + tree.getType() + ")");
        }
        String className = tree.getText();
        Class<?> typeClass = null;
        try {
            typeClass = Utils.getClass(className);
        }
        catch (ClassNotFoundException e1) {
            try {
                typeClass = Utils.getClass("java.lang." + className);
            }
            catch (ClassNotFoundException e2) {
                try {
                    typeClass = Utils.getClass("java.util." + className);
                }
                catch (ClassNotFoundException e3) {
                    try {
                        typeClass = Utils.getClass("java.io." + className);
                    }
                    catch (ClassNotFoundException e4) {
                        try {
                            typeClass = Utils.getClass("java.math." + className);
                        }
                        catch (ClassNotFoundException e5) {
                            throw new ClassNotFoundException(className);
                        }
                    }
                }
            }
        }
        LinkedList<TypeParameter> typeParameters = new LinkedList<TypeParameter>();
        int arrayDimensions = 0;
        block15: for (i = 0; i < tree.getChildCount(); ++i) {
            Tree child = tree.getChild(i);
            if (child.getType() == 4) {
                ++arrayDimensions;
                continue;
            }
            switch (child.getType()) {
                case 5: {
                    typeParameters.add(WildcardTypeParameter.UNKNOWN);
                    continue block15;
                }
                case 11: {
                    Type<?> extendedType = TypeUtil.createTypeFromTree(child.getChild(0));
                    typeParameters.add(new ExtendsTypeParameter(extendedType));
                    continue block15;
                }
                case 12: {
                    Type<?> superType = TypeUtil.createTypeFromTree(child.getChild(0));
                    typeParameters.add(new SuperTypeParameter(superType));
                    continue block15;
                }
                default: {
                    Type<?> type = TypeUtil.createTypeFromTree(child);
                    typeParameters.add(new StandardTypeParameter(type));
                }
            }
        }
        if (typeParameters.size() == 0) {
            for (i = 0; i < typeClass.getTypeParameters().length; ++i) {
                typeParameters.add(WildcardTypeParameter.UNKNOWN);
            }
        }
        TypeParameter[] typeParametersArray = typeParameters.toArray(new TypeParameter[typeParameters.size()]);
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(typeClass, typeParametersArray, arrayDimensions);
    }

    static Class<?> computeRawClass(Class<?> componentClass, int arrayDimensions) {
        if (arrayDimensions == 0) {
            return componentClass;
        }
        int[] zeroDims = new int[arrayDimensions];
        Arrays.fill(zeroDims, 0);
        return Array.newInstance(componentClass, zeroDims).getClass();
    }

    static String createName(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(componentClass.getName());
        if (typeParameters.length > 0) {
            strBuilder.append("<");
            strBuilder.append(Utils.join(typeParameters, ","));
            strBuilder.append(">");
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            strBuilder.append("[]");
        }
        return strBuilder.toString();
    }

    static String createSimpleName(Class<?> componentClass, TypeParameter<?>[] typeParameters, int arrayDimensions) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(componentClass.getSimpleName());
        if (typeParameters.length > 0) {
            strBuilder.append("<");
            strBuilder.append(Utils.join(typeParameters, ","));
            strBuilder.append(">");
        }
        for (int i = 0; i < arrayDimensions; ++i) {
            strBuilder.append("[]");
        }
        return strBuilder.toString();
    }

    static <T> Type<T> decreaseArrayDimensions(Type<T[]> type) {
        if (!type.isArray()) {
            throw new IllegalStateException("Cannot get an array component type from a non-array type: " + type.getName());
        }
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(type.getComponentClass(), type.getTypeParametersArray(), type.getArrayDimensions() - 1);
    }

    static <T> Type<T[]> increaseArrayDimensions(Type<T> type) {
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(type.getComponentClass(), type.getTypeParametersArray(), type.getArrayDimensions() + 1);
    }

    static void validateTypeParameters(Type<?> type) {
        if (!TypeUtil.isTypeParametersValid(type)) {
            throw new TypeValidationException(type.getName() + " is not a valid type " + "according to definition " + type.getTypeDef());
        }
    }

    private static boolean isTypeParametersValid(Type<?> type) {
        TypeParameter<?>[] typeParameters;
        TypeDefVariable[] typeDefVariables = type.getTypeDef().getVariables();
        if (typeDefVariables.length != (typeParameters = type.getTypeParametersArray()).length) {
            return false;
        }
        HashMap checkedTypeParametersByName = new HashMap();
        for (int i = 0; i < typeDefVariables.length; ++i) {
            if (typeParameters[i] == null) {
                return false;
            }
            if (typeDefVariables[i] instanceof NamedTypeDefVariable) {
                checkedTypeParametersByName.put(typeDefVariables[i].getVariableName(), typeParameters[i]);
                continue;
            }
            BoundedTypeDefVariable boundedVar = (BoundedTypeDefVariable)typeDefVariables[i];
            String variableName = boundedVar.getVariableName();
            InnerTypeDefVariable[] innerVariables = boundedVar.getBounds();
            if (!(typeParameters[i] instanceof WildcardTypeParameter)) {
                List<Type<?>> extendedTypes = TypeUtil.resolveFormalExtendedTypes(checkedTypeParametersByName, variableName, typeParameters[i], innerVariables);
                if (extendedTypes == null) {
                    return false;
                }
                for (Type<?> extendedType : extendedTypes) {
                    if (extendedType.isAssignableFrom(typeParameters[i].getType())) continue;
                    return false;
                }
            }
            checkedTypeParametersByName.put(typeDefVariables[i].getVariableName(), typeParameters[i]);
        }
        return true;
    }

    private static List<Type<?>> resolveFormalExtendedTypes(Map<String, TypeParameter<?>> checkedTypeParametersByName, String currentVariableName, TypeParameter<?> currentTypeParameter, InnerTypeDefVariable[] innerVariables) {
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        LinkedList types = new LinkedList();
        for (int i = 0; i < innerVariables.length; ++i) {
            if (innerVariables[i] instanceof InnerClassTypeDefVariable) {
                InnerClassTypeDefVariable classVariable = (InnerClassTypeDefVariable)innerVariables[i];
                Type<?> innerType = TypeUtil.getRawTypeForClass(classVariable.getComponentClass(), classVariable.getArrayDimensions());
                types.add(innerType);
                continue;
            }
            if (innerVariables[i] instanceof InnerNamedTypeDefVariable) {
                InnerNamedTypeDefVariable innerVariable = (InnerNamedTypeDefVariable)innerVariables[i];
                TypeParameter<?> linkedTypeParameter = checkedTypeParametersByName.get(innerVariable.getVariableName());
                if (linkedTypeParameter == null) {
                    return null;
                }
                if (linkedTypeParameter instanceof WildcardTypeParameter) continue;
                if (linkedTypeParameter instanceof StandardTypeParameter) {
                    types.add(linkedTypeParameter.getType());
                    continue;
                }
                if (!(linkedTypeParameter instanceof ExtendsTypeParameter)) continue;
                types.add(linkedTypeParameter.getType());
                continue;
            }
            if (innerVariables[i] instanceof InnerWildcardTypeDefVariable) {
                throw new IllegalStateException("Wildcard should not appear at first level of 'extends' clause in type definition");
            }
            InnerParameterizedTypeTypeDefVariable parameterizedVariable = (InnerParameterizedTypeTypeDefVariable)innerVariables[i];
            TypeParameter<?>[] typeParameters = TypeUtil.resolveInnerParameterizedType(checkedTypeParametersByName, currentVariableName, currentTypeParameter, parameterizedVariable.getVariables());
            if (typeParameters == null) {
                return null;
            }
            Class<?> componentClass = parameterizedVariable.getComponentClass();
            int arrayDimensions = parameterizedVariable.getArrayDimensions();
            Type<?> parameterizedType = typeRegistry.getTypeWithoutValidation(componentClass, typeParameters, arrayDimensions);
            types.add(parameterizedType);
        }
        return types;
    }

    private static TypeParameter<?>[] resolveInnerParameterizedType(Map<String, TypeParameter<?>> checkedTypeParametersByName, String currentVariableName, TypeParameter<?> currentTypeParameter, InnerTypeDefVariable[] innerVariables) {
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        TypeParameter[] typeParameters = new TypeParameter[innerVariables.length];
        for (int i = 0; i < innerVariables.length; ++i) {
            if (innerVariables[i] instanceof InnerClassTypeDefVariable) {
                InnerClassTypeDefVariable classVariable = (InnerClassTypeDefVariable)innerVariables[i];
                Type<?> innerType = TypeUtil.getRawTypeForClass(classVariable.getComponentClass(), classVariable.getArrayDimensions());
                typeParameters[i] = new StandardTypeParameter(innerType);
                continue;
            }
            if (innerVariables[i] instanceof InnerNamedTypeDefVariable) {
                InnerNamedTypeDefVariable innerVariable = (InnerNamedTypeDefVariable)innerVariables[i];
                TypeParameter<?> linkedTypeParameter = checkedTypeParametersByName.get(innerVariable.getVariableName());
                if (linkedTypeParameter == null) {
                    if (innerVariable.getVariableName().equals(currentVariableName)) {
                        linkedTypeParameter = currentTypeParameter;
                    } else {
                        return null;
                    }
                }
                if (linkedTypeParameter instanceof WildcardTypeParameter || linkedTypeParameter instanceof ExtendsTypeParameter || linkedTypeParameter instanceof SuperTypeParameter) {
                    return null;
                }
                Type<?> containedType = linkedTypeParameter.getType();
                int newArrayDimensions = containedType.getArrayDimensions() + innerVariable.getArrayDimensions();
                Type<?> newType = typeRegistry.getTypeWithoutValidation(containedType.getComponentClass(), containedType.getTypeParametersArray(), newArrayDimensions);
                typeParameters[i] = new StandardTypeParameter(newType);
                continue;
            }
            if (innerVariables[i] instanceof InnerWildcardTypeDefVariable) {
                InnerWildcardTypeDefVariable wildcardVariable = (InnerWildcardTypeDefVariable)innerVariables[i];
                if (wildcardVariable.isUnbound()) {
                    typeParameters[i] = WildcardTypeParameter.UNKNOWN;
                    continue;
                }
                InnerTypeDefVariable bound = null;
                bound = wildcardVariable.hasUpperBound() ? wildcardVariable.getUpperBound() : wildcardVariable.getLowerBound();
                TypeParameter<?>[] resolvedTypeParameters = TypeUtil.resolveInnerParameterizedType(checkedTypeParametersByName, currentVariableName, currentTypeParameter, new InnerTypeDefVariable[]{bound});
                if (resolvedTypeParameters == null) {
                    return null;
                }
                if (resolvedTypeParameters.length != 1) {
                    throw new IllegalStateException("Wildcard variable is supposed to have a resolvable upper bound");
                }
                if (!(resolvedTypeParameters[0] instanceof StandardTypeParameter)) {
                    throw new IllegalStateException("Wildcard variable is supposed to have a resolvable upper bound in the form of a Standard Type parameter");
                }
                Type type = ((StandardTypeParameter)resolvedTypeParameters[0]).getType();
                if (wildcardVariable.hasUpperBound()) {
                    typeParameters[i] = new ExtendsTypeParameter(type);
                    continue;
                }
                typeParameters[i] = new SuperTypeParameter(type);
                continue;
            }
            InnerParameterizedTypeTypeDefVariable parameterizedVariable = (InnerParameterizedTypeTypeDefVariable)innerVariables[i];
            TypeParameter<?>[] innerTypeParameters = TypeUtil.resolveInnerParameterizedType(checkedTypeParametersByName, currentVariableName, currentTypeParameter, parameterizedVariable.getVariables());
            if (innerTypeParameters == null) {
                return null;
            }
            Class<?> componentClass = parameterizedVariable.getComponentClass();
            int arrayDimensions = parameterizedVariable.getArrayDimensions();
            Type<?> parameterizedType = typeRegistry.getTypeWithoutValidation(componentClass, innerTypeParameters, arrayDimensions);
            typeParameters[i] = new StandardTypeParameter(parameterizedType);
        }
        return typeParameters;
    }

    static Type<?> getRawTypeForClass(Class<?> typeClass) {
        return TypeUtil.getRawTypeForClass(typeClass, 0);
    }

    private static Type<?> getRawTypeForClass(Class<?> typeClass, int arrayDimensions) {
        Class<?> componentClass = typeClass;
        int newArrayDimensions = arrayDimensions;
        while (componentClass.isArray()) {
            componentClass = componentClass.getComponentType();
            ++newArrayDimensions;
        }
        TypeDef typeDef = TypeDefs.forClass(componentClass);
        TypeDefVariable[] variables = typeDef.getVariables();
        TypeParameter[] typeParameters = new TypeParameter[variables.length];
        for (int i = 0; i < variables.length; ++i) {
            typeParameters[i] = WildcardTypeParameter.UNKNOWN;
        }
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(componentClass, typeParameters, newArrayDimensions);
    }

    static Set<Type<?>> getExtendedTypes(Type<?> type) {
        Class<?> componentClass;
        java.lang.reflect.Type superclassTypeDeclaration;
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        HashSet equivalenceSet = new HashSet();
        if (Object.class.equals(type.getComponentClass())) {
            int currentArrayDim = type.getArrayDimensions();
            while (currentArrayDim > 0) {
                equivalenceSet.add(typeRegistry.getTypeWithoutValidation(Object.class, new TypeParameter[0], --currentArrayDim));
            }
            return equivalenceSet;
        }
        if (type.isInterface()) {
            equivalenceSet.add(typeRegistry.getRawTypeForClass(Object.class));
        }
        if ((superclassTypeDeclaration = (componentClass = type.getComponentClass()).getGenericSuperclass()) != null) {
            Type<?> superclassType = TypeUtil.resolveExtendedTypeByDeclaration(type, superclassTypeDeclaration);
            equivalenceSet.add(superclassType);
            equivalenceSet.addAll(typeRegistry.getExtendedTypes(superclassType));
        }
        for (java.lang.reflect.Type interfaceTypeDeclaration : componentClass.getGenericInterfaces()) {
            Type<?> interfaceType = TypeUtil.resolveExtendedTypeByDeclaration(type, interfaceTypeDeclaration);
            equivalenceSet.add(interfaceType);
            equivalenceSet.addAll(typeRegistry.getExtendedTypes(interfaceType));
        }
        return Collections.unmodifiableSet(equivalenceSet);
    }

    private static Type<?> resolveExtendedTypeByDeclaration(Type<?> originalType, java.lang.reflect.Type typeDeclaration) {
        HashMap typeParametersMap = new HashMap();
        Class componentClass = null;
        if (typeDeclaration instanceof ParameterizedType) {
            ParameterizedType parameterizedTypeDeclaration = (ParameterizedType)typeDeclaration;
            java.lang.reflect.Type[] parameterizedTypeDeclarationArguments = parameterizedTypeDeclaration.getActualTypeArguments();
            componentClass = (Class)parameterizedTypeDeclaration.getRawType();
            TypeVariable<Class<T>>[] componentClassTypeParameters = componentClass.getTypeParameters();
            for (int i = 0; i < parameterizedTypeDeclarationArguments.length; ++i) {
                TypeParameter<?> typeParameter = TypeUtil.resolveEquivalentTypeParameterByDeclaration(originalType, parameterizedTypeDeclarationArguments[i], 0);
                typeParametersMap.put(componentClassTypeParameters[i].getName(), typeParameter);
            }
        } else {
            componentClass = (Class)typeDeclaration;
            for (int i = 0; i < componentClass.getTypeParameters().length; ++i) {
                typeParametersMap.put(componentClass.getTypeParameters()[i].getName(), WildcardTypeParameter.UNKNOWN);
            }
        }
        TypeDef typeDef = TypeDefs.forClass(componentClass);
        TypeParameter[] typeParameters = new TypeParameter[typeDef.getVariables().length];
        for (int i = 0; i < typeDef.getVariables().length; ++i) {
            typeParameters[i] = (TypeParameter)typeParametersMap.get(typeDef.getVariables()[i].getVariableName());
        }
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getTypeWithoutValidation(componentClass, typeParameters, originalType.getArrayDimensions());
    }

    private static TypeParameter<?> resolveEquivalentTypeParameterByDeclaration(Type<?> originalType, java.lang.reflect.Type typeDeclaration, int arrayDimensions) {
        if (typeDeclaration instanceof TypeVariable) {
            String argumentName = ((TypeVariable)typeDeclaration).getName();
            TypeParameter<?> typeParameter = originalType.getTypeParameterForVariable(argumentName);
            if (typeParameter instanceof WildcardTypeParameter) {
                return typeParameter;
            }
            if (arrayDimensions == 0) {
                return typeParameter;
            }
            Type<?> containedType = typeParameter.getType();
            int newArrayDimensions = containedType.getArrayDimensions() + arrayDimensions;
            TypeRegistry typeRegistry = TypeRegistry.getInstance();
            Type<?> newType = typeRegistry.getTypeWithoutValidation(containedType.getComponentClass(), containedType.getTypeParametersArray(), newArrayDimensions);
            if (typeParameter instanceof StandardTypeParameter) {
                return new StandardTypeParameter(newType);
            }
            if (typeParameter instanceof ExtendsTypeParameter) {
                return new ExtendsTypeParameter(newType);
            }
            return new SuperTypeParameter(newType);
        }
        if (typeDeclaration instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)typeDeclaration;
            return TypeUtil.resolveEquivalentTypeParameterByDeclaration(originalType, genericArrayType.getGenericComponentType(), arrayDimensions + 1);
        }
        Type<?> baseType = originalType;
        if (baseType.isArray()) {
            TypeRegistry typeRegistry = TypeRegistry.getInstance();
            baseType = typeRegistry.getType(baseType.getComponentClass(), baseType.getTypeParametersArray(), arrayDimensions);
        }
        Type<?> parameterizedTypeDeclarationArgumentType = TypeUtil.resolveExtendedTypeByDeclaration(baseType, typeDeclaration);
        return new StandardTypeParameter(parameterizedTypeDeclarationArgumentType);
    }

    static Type<?> getTypeWithParameters(Class<?> componentClass, TypeParameter<?> ... typeParameters) {
        int arrayDimensions = 0;
        Class<?> newTypeComponentClass = componentClass;
        while (newTypeComponentClass.isArray()) {
            ++arrayDimensions;
            newTypeComponentClass = newTypeComponentClass.getComponentType();
        }
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        return typeRegistry.getType(newTypeComponentClass, typeParameters, arrayDimensions);
    }

    static boolean isAssignableFrom(Type<?> type, Type<?> fromType) {
        if (type.equals(fromType)) {
            return true;
        }
        if (type.getComponentClass().equals(Object.class) && type.getArrayDimensions() <= fromType.getArrayDimensions()) {
            return true;
        }
        if (TypeUtil.isTypeAssignableFrom(type, fromType)) {
            return true;
        }
        TypeRegistry typeRegistry = TypeRegistry.getInstance();
        Set<Type<?>> extendedTypes = typeRegistry.getExtendedTypes(fromType);
        for (Type<?> extendedType : extendedTypes) {
            if (!TypeUtil.isTypeAssignableFrom(type, extendedType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isTypeAssignableFrom(Type<?> type, Type<?> fromType) {
        if (type.getArrayDimensions() != fromType.getArrayDimensions()) {
            return false;
        }
        if (!type.getComponentClass().isAssignableFrom(fromType.getComponentClass())) {
            return false;
        }
        if (type.getTypeParametersArray().length != fromType.getTypeParametersArray().length) {
            return false;
        }
        for (int i = 0; i < type.getTypeParametersArray().length; ++i) {
            if (type.getTypeParametersArray()[i].isAssignableFrom(fromType.getTypeParametersArray()[i])) continue;
            return false;
        }
        return true;
    }

    static Type<?> getRawTypeForType(Type<?> type) {
        return TypeUtil.getRawTypeForClass(type.getComponentClass(), type.getArrayDimensions());
    }

    public static TypeParameter<?> createFromJavaLangReflectTypeParameter(java.lang.reflect.Type originalType, java.lang.reflect.Type type, Map<String, Type<?>> variableSubstitutions) {
        if (type instanceof Class) {
            return TypeParameters.forType(TypeUtil.createFromJavaLangReflectType(originalType, type, variableSubstitutions));
        }
        if (type instanceof GenericArrayType) {
            return TypeParameters.forType(TypeUtil.createFromJavaLangReflectType(originalType, type, variableSubstitutions));
        }
        if (type instanceof ParameterizedType) {
            return TypeParameters.forType(TypeUtil.createFromJavaLangReflectType(originalType, type, variableSubstitutions));
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            java.lang.reflect.Type[] bounds = typeVariable.getBounds();
            Type<?> correspondingType = variableSubstitutions.get(typeVariable.getName());
            if (correspondingType == null) {
                throw new TypeValidationException("No variable substitution established for variable \"" + typeVariable.getName() + "\" in type \"" + originalType + "\"");
            }
            for (java.lang.reflect.Type bound : bounds) {
                Type<?> boundType = TypeUtil.createFromJavaLangReflectType(originalType, bound, variableSubstitutions);
                if (boundType.isAssignableFrom(correspondingType)) continue;
                throw new TypeValidationException("Variable substitution established for variable \"" + typeVariable.getName() + "\" in type \"" + originalType + "\" is " + "\"" + correspondingType + "\", which does not conform to upper bound \"extends " + boundType + "\"");
            }
            return TypeParameters.forType(correspondingType);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds() != null && wildcardType.getLowerBounds().length > 0) {
                java.lang.reflect.Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds.length > 1) {
                    throw new TypeValidationException("Type parameter \"" + type + "\" cannot " + "have more than one bound at this point in type \"" + originalType + "\"");
                }
                return TypeParameters.forSuperType(TypeUtil.createFromJavaLangReflectType(originalType, lowerBounds[0], variableSubstitutions));
            }
            if (wildcardType.getUpperBounds() != null && wildcardType.getUpperBounds().length > 0) {
                java.lang.reflect.Type[] upperBounds = wildcardType.getUpperBounds();
                if (upperBounds.length > 1) {
                    throw new TypeValidationException("Type parameter \"" + type + "\" cannot " + "have more than one bound at this point in type \"" + originalType + "\"");
                }
                return TypeParameters.forExtendsType(TypeUtil.createFromJavaLangReflectType(originalType, upperBounds[0], variableSubstitutions));
            }
            return TypeParameters.forUnknown();
        }
        throw new TypeValidationException("Specified \"" + type + "\" in type \"" + originalType + "\" is of class \"" + type.getClass() + "\", which is " + "not a recognized java.lang.reflect.Type implementation.");
    }

    public static Type<?> createFromJavaLangReflectType(java.lang.reflect.Type originalType, java.lang.reflect.Type type, Map<String, Type<?>> variableSubstitutions) {
        if (type instanceof Class) {
            Class classType = (Class)type;
            return Types.forClass(classType);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType genericArrayType = (GenericArrayType)type;
            Type<?> componentType = TypeUtil.createFromJavaLangReflectType(originalType, genericArrayType.getGenericComponentType(), variableSubstitutions);
            TypeRegistry typeRegistry = TypeRegistry.getInstance();
            return typeRegistry.getType(componentType.getComponentClass(), componentType.getTypeParametersArray(), componentType.getArrayDimensions() + 1);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            java.lang.reflect.Type[] actualTypeParameters = parameterizedType.getActualTypeArguments();
            TypeParameter[] typeParameters = new TypeParameter[actualTypeParameters.length];
            for (int i = 0; i < actualTypeParameters.length; ++i) {
                typeParameters[i] = TypeUtil.createFromJavaLangReflectTypeParameter(originalType, actualTypeParameters[i], variableSubstitutions);
            }
            Type<?> rawType = TypeUtil.createFromJavaLangReflectType(originalType, parameterizedType.getRawType(), variableSubstitutions);
            TypeRegistry typeRegistry = TypeRegistry.getInstance();
            return typeRegistry.getType(rawType.getComponentClass(), typeParameters, rawType.getArrayDimensions());
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            java.lang.reflect.Type[] bounds = typeVariable.getBounds();
            Type<?> correspondingType = variableSubstitutions.get(typeVariable.getName());
            if (correspondingType == null) {
                throw new TypeValidationException("No variable substitution established for variable \"" + typeVariable.getName() + "\" in type \"" + originalType + "\"");
            }
            for (java.lang.reflect.Type bound : bounds) {
                Type<?> boundType = TypeUtil.createFromJavaLangReflectType(originalType, bound, variableSubstitutions);
                if (boundType.isAssignableFrom(correspondingType)) continue;
                throw new TypeValidationException("Variable substitution established for variable \"" + typeVariable.getName() + "\" in type \"" + originalType + "\" is " + "\"" + correspondingType + "\", which does not conform to upper bound \"extends " + boundType + "\"");
            }
            return correspondingType;
        }
        if (type instanceof WildcardType) {
            throw new TypeValidationException("Cannot convert wildcard \"" + type + "\" in type \"" + originalType + "\" into a javaRuntype type.");
        }
        throw new TypeValidationException("Specified \"" + type + "\" in type \"" + originalType + "\" is of class \"" + type.getClass() + "\", which is " + "not a recognized java.lang.reflect.Type implementation.");
    }

    private TypeUtil() {
    }
}

