/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene49;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

class Lucene49NormsConsumer
extends DocValuesConsumer {
    static final byte DELTA_COMPRESSED = 0;
    static final byte TABLE_COMPRESSED = 1;
    static final byte CONST_COMPRESSED = 2;
    static final byte UNCOMPRESSED = 3;
    static final int BLOCK_SIZE = 16384;
    IndexOutput data;
    IndexOutput meta;
    final int maxDoc;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene49NormsConsumer(SegmentWriteState state, String dataCodec, String dataExtension, String metaCodec, String metaExtension) throws IOException {
        this.maxDoc = state.segmentInfo.getDocCount();
        boolean success = false;
        try {
            String dataName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, dataExtension);
            this.data = state.directory.createOutput(dataName, state.context);
            CodecUtil.writeHeader(this.data, dataCodec, 0);
            String metaName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, metaExtension);
            this.meta = state.directory.createOutput(metaName, state.context);
            CodecUtil.writeHeader(this.meta, metaCodec, 0);
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    @Override
    public void addNumericField(FieldInfo field, Iterable<Number> values) throws IOException {
        this.meta.writeVInt(field.number);
        long minValue = Long.MAX_VALUE;
        long maxValue = Long.MIN_VALUE;
        NormMap uniqueValues = new NormMap();
        long count = 0L;
        for (Number nv : values) {
            if (nv == null) {
                throw new IllegalStateException("illegal norms data for field " + field.name + ", got null for value: " + count);
            }
            long v = nv.longValue();
            minValue = Math.min(minValue, v);
            maxValue = Math.max(maxValue, v);
            if (uniqueValues != null && uniqueValues.add(v) && uniqueValues.size > 256) {
                uniqueValues = null;
            }
            ++count;
        }
        if (count != (long)this.maxDoc) {
            throw new IllegalStateException("illegal norms data for field " + field.name + ", expected " + this.maxDoc + " values, got " + count);
        }
        if (uniqueValues != null && uniqueValues.size == 1) {
            this.meta.writeByte((byte)2);
            this.meta.writeLong(minValue);
        } else if (uniqueValues != null) {
            PackedInts.Format format = PackedInts.Format.PACKED_SINGLE_BLOCK;
            int bitsPerValue = PackedInts.bitsRequired(uniqueValues.size - 1);
            if (bitsPerValue == 3) {
                bitsPerValue = 4;
            } else if (bitsPerValue > 4) {
                bitsPerValue = 8;
            }
            if (bitsPerValue == 8 && minValue >= -128L && maxValue <= 127L) {
                this.meta.writeByte((byte)3);
                this.meta.writeLong(this.data.getFilePointer());
                for (Number nv : values) {
                    this.data.writeByte(nv == null ? (byte)0 : (byte)nv.longValue());
                }
            } else {
                int i;
                this.meta.writeByte((byte)1);
                this.meta.writeLong(this.data.getFilePointer());
                this.data.writeVInt(2);
                long[] decode = uniqueValues.getDecodeTable();
                int size = 1 << bitsPerValue;
                this.data.writeVInt(size);
                for (i = 0; i < decode.length; ++i) {
                    this.data.writeLong(decode[i]);
                }
                for (i = decode.length; i < size; ++i) {
                    this.data.writeLong(0L);
                }
                this.data.writeVInt(format.getId());
                this.data.writeVInt(bitsPerValue);
                PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.data, format, this.maxDoc, bitsPerValue, 1024);
                for (Number nv : values) {
                    writer.add(uniqueValues.getOrd(nv.longValue()));
                }
                writer.finish();
            }
        } else {
            this.meta.writeByte((byte)0);
            this.meta.writeLong(this.data.getFilePointer());
            this.data.writeVInt(2);
            this.data.writeVInt(16384);
            BlockPackedWriter writer = new BlockPackedWriter(this.data, 16384);
            for (Number nv : values) {
                writer.add(nv.longValue());
            }
            writer.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        block7: {
            block6: {
                boolean success = false;
                try {
                    if (this.meta != null) {
                        this.meta.writeVInt(-1);
                        CodecUtil.writeFooter(this.meta);
                    }
                    if (this.data != null) {
                        CodecUtil.writeFooter(this.data);
                    }
                    if (!(success = true)) break block6;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close(this.data, this.meta);
                    } else {
                        IOUtils.closeWhileHandlingException(this.data, this.meta);
                    }
                    this.data = null;
                    this.meta = null;
                    throw throwable;
                }
                IOUtils.close(this.data, this.meta);
                break block7;
            }
            IOUtils.closeWhileHandlingException(this.data, this.meta);
        }
        this.data = null;
        this.meta = null;
    }

    @Override
    public void addBinaryField(FieldInfo field, Iterable<BytesRef> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrd) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedSetField(FieldInfo field, Iterable<BytesRef> values, Iterable<Number> docToOrdCount, Iterable<Number> ords) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addSortedNumericField(FieldInfo field, Iterable<Number> docToValueCount, Iterable<Number> values) throws IOException {
        throw new UnsupportedOperationException();
    }

    static {
        boolean bl = $assertionsDisabled = !Lucene49NormsConsumer.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(1)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(2)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !PackedInts.Format.PACKED_SINGLE_BLOCK.isSupported(4)) {
            throw new AssertionError();
        }
    }

    static class NormMap {
        final short[] singleByteRange = new short[256];
        final Map<Long, Short> other = new HashMap<Long, Short>();
        int size;

        NormMap() {
            Arrays.fill(this.singleByteRange, (short)-1);
        }

        public boolean add(long l) {
            assert (this.size <= 256);
            if (l >= -128L && l <= 127L) {
                int index = (int)(l + 128L);
                short previous = this.singleByteRange[index];
                if (previous < 0) {
                    this.singleByteRange[index] = (short)this.size;
                    ++this.size;
                    return true;
                }
                return false;
            }
            if (!this.other.containsKey(l)) {
                this.other.put(l, (short)this.size);
                ++this.size;
                return true;
            }
            return false;
        }

        public int getOrd(long l) {
            if (l >= -128L && l <= 127L) {
                int index = (int)(l + 128L);
                return this.singleByteRange[index];
            }
            return this.other.get(l).shortValue();
        }

        public long[] getDecodeTable() {
            long[] decode = new long[this.size];
            for (int i = 0; i < this.singleByteRange.length; ++i) {
                short s = this.singleByteRange[i];
                if (s < 0) continue;
                decode[s] = i - 128;
            }
            for (Map.Entry<Long, Short> entry : this.other.entrySet()) {
                decode[entry.getValue().shortValue()] = entry.getKey();
            }
            return decode;
        }
    }
}

