/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.internal;

import com.pholser.junit.quickcheck.ForAll;
import com.pholser.junit.quickcheck.From;
import com.pholser.junit.quickcheck.SuchThat;
import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.generator.GeneratorConfiguration;
import com.pholser.junit.quickcheck.internal.Reflection;
import com.pholser.junit.quickcheck.internal.SampleSizer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.javaruntype.type.Types;

public class ParameterContext {
    private static final String EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE = "The generator %s named in @%s on parameter of type %s does not produce a type-compatible object";
    private final Type parameterType;
    private final List<Generator<?>> explicits = new ArrayList();
    private int configuredSampleSize;
    private SampleSizer sampleSizer;
    private int discardRatio;
    private String constraint;
    private Map<Class<? extends Annotation>, Annotation> configurations = new HashMap<Class<? extends Annotation>, Annotation>();

    public ParameterContext(Type parameterType) {
        this.parameterType = parameterType;
    }

    public ParameterContext annotate(AnnotatedElement element) {
        this.addQuantifier(element.getAnnotation(ForAll.class));
        this.addConstraint(element.getAnnotation(SuchThat.class));
        From explicitGenerators = element.getAnnotation(From.class);
        if (explicitGenerators != null) {
            this.addGenerators(explicitGenerators);
        }
        this.addConfigurations(Reflection.markedAnnotations(Arrays.asList(element.getAnnotations()), GeneratorConfiguration.class));
        return this;
    }

    public ParameterContext addQuantifier(ForAll quantifier) {
        if (quantifier != null) {
            this.configuredSampleSize = quantifier.sampleSize();
            this.discardRatio = quantifier.discardRatio();
        }
        return this;
    }

    public ParameterContext addConstraint(SuchThat expression) {
        if (expression != null) {
            this.constraint = expression.value();
        }
        return this;
    }

    public ParameterContext addGenerators(From generators) {
        for (Class<? extends Generator> each : generators.value()) {
            Generator<?> generator = this.makeGenerator(each);
            this.ensureCorrectType(generator);
            this.explicits.add(generator);
        }
        return this;
    }

    private Generator<?> makeGenerator(Class<? extends Generator> generatorType) {
        Constructor<? extends Generator> ctor = Reflection.findConstructor(generatorType, Class.class);
        if (ctor != null) {
            return Reflection.instantiate(ctor, this.rawParameterType());
        }
        return Reflection.instantiate(generatorType);
    }

    private Class<?> rawParameterType() {
        if (this.parameterType instanceof ParameterizedType) {
            return (Class)((ParameterizedType)this.parameterType).getRawType();
        }
        return (Class)this.parameterType;
    }

    public ParameterContext addConfigurations(List<Annotation> generatorConfigurations) {
        for (Annotation each : generatorConfigurations) {
            this.addConfiguration(each.annotationType(), each);
        }
        return this;
    }

    public void addConfiguration(Class<? extends Annotation> annotationType, Annotation configuration) {
        this.configurations.put(annotationType, configuration);
    }

    private void ensureCorrectType(Generator<?> generator) {
        org.javaruntype.type.Type parameterTypeToken = Types.forJavaLangReflectType((Type)this.parameterType);
        for (Class<?> each : generator.types()) {
            if (Reflection.maybeWrap(parameterTypeToken.getRawClass()).isAssignableFrom(Reflection.maybeWrap(each))) continue;
            throw new IllegalArgumentException(String.format(EXPLICIT_GENERATOR_TYPE_MISMATCH_MESSAGE, each, From.class.getName(), this.parameterType));
        }
    }

    public Type parameterType() {
        return this.parameterType;
    }

    public int sampleSize() {
        if (this.sampleSizer == null) {
            this.sampleSizer = new SampleSizer(this.configuredSampleSize, this);
        }
        return this.sampleSizer.sampleSize();
    }

    public int discardRatio() {
        return this.discardRatio;
    }

    public String constraint() {
        return this.constraint;
    }

    public List<Generator<?>> explicitGenerators() {
        return Collections.unmodifiableList(this.explicits);
    }

    public Map<Class<? extends Annotation>, Annotation> configurations() {
        return Collections.unmodifiableMap(this.configurations);
    }
}

