/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.salt.element;

import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.salt.Positionner2;
import net.sourceforge.plantuml.salt.element.ElementPyramid;
import net.sourceforge.plantuml.salt.element.TableStrategy;
import net.sourceforge.plantuml.salt.factory.ScrollStrategy;
import net.sourceforge.plantuml.style.ISkinSimple;

public class ElementPyramidScrolled
extends ElementPyramid {
    private final double v1 = 15.0;
    private final double v2 = 12.0;
    private final ScrollStrategy scrollStrategy;

    public ElementPyramidScrolled(Positionner2 positionner, ISkinSimple spriteContainer, ScrollStrategy scrollStrategy) {
        super(positionner, TableStrategy.DRAW_OUTSIDE, null, spriteContainer);
        this.scrollStrategy = scrollStrategy;
    }

    @Override
    public XDimension2D getPreferredDimension(StringBounder stringBounder, double x, double y) {
        XDimension2D result = super.getPreferredDimension(stringBounder, x, y);
        if (this.scrollStrategy == ScrollStrategy.HORIZONTAL_ONLY) {
            return result.delta(0.0, 30.0);
        }
        if (this.scrollStrategy == ScrollStrategy.VERTICAL_ONLY) {
            return result.delta(30.0, 0.0);
        }
        return result.delta(30.0);
    }

    @Override
    public void drawU(UGraphic ug, int zIndex, XDimension2D dimToUse) {
        super.drawU(ug, zIndex, dimToUse);
        ug = ug.apply(this.getBlack());
        XDimension2D dim = super.getPreferredDimension(ug.getStringBounder(), 0.0, 0.0);
        if (this.scrollStrategy == ScrollStrategy.BOTH || this.scrollStrategy == ScrollStrategy.VERTICAL_ONLY) {
            this.drawV(ug.apply(UTranslate.dx(dim.getWidth() + 4.0)), 15.0, dim.getHeight());
        }
        if (this.scrollStrategy == ScrollStrategy.BOTH || this.scrollStrategy == ScrollStrategy.HORIZONTAL_ONLY) {
            this.drawH(ug.apply(UTranslate.dy(dim.getHeight() + 4.0)), dim.getWidth(), 15.0);
        }
    }

    private UPath getTr0() {
        UPath poly = new UPath();
        poly.moveTo(3.0, 0.0);
        poly.lineTo(6.0, 5.0);
        poly.lineTo(0.0, 5.0);
        poly.lineTo(3.0, 0.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr180() {
        UPath poly = new UPath();
        poly.moveTo(3.0, 5.0);
        poly.lineTo(6.0, 0.0);
        poly.lineTo(0.0, 0.0);
        poly.lineTo(3.0, 5.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr90() {
        UPath poly = new UPath();
        poly.moveTo(0.0, 3.0);
        poly.lineTo(5.0, 6.0);
        poly.lineTo(5.0, 0.0);
        poly.lineTo(0.0, 3.0);
        poly.closePath();
        return poly;
    }

    private UPath getTr270() {
        UPath poly = new UPath();
        poly.moveTo(5.0, 3.0);
        poly.lineTo(0.0, 6.0);
        poly.lineTo(0.0, 0.0);
        poly.lineTo(5.0, 3.0);
        poly.closePath();
        return poly;
    }

    private void drawV(UGraphic ug, double width, double height) {
        ug.draw(new URectangle(width, height));
        ug.apply(UTranslate.dy(12.0)).draw(ULine.hline(width));
        ug.apply(UTranslate.dy(height - 12.0)).draw(ULine.hline(width));
        ug.apply(new UTranslate(4.0, 4.0)).apply(this.getBlack().bg()).draw(this.getTr0());
        ug.apply(new UTranslate(4.0, height - 12.0 + 4.0)).apply(this.getBlack().bg()).draw(this.getTr180());
    }

    private void drawH(UGraphic ug, double width, double height) {
        ug.draw(new URectangle(width, height));
        ug.apply(UTranslate.dx(12.0)).draw(ULine.vline(height));
        ug.apply(UTranslate.dx(width - 12.0)).draw(ULine.vline(height));
        ug.apply(new UTranslate(4.0, 4.0)).apply(this.getBlack().bg()).draw(this.getTr90());
        ug.apply(new UTranslate(width - 12.0 + 4.0, 4.0)).apply(this.getBlack().bg()).draw(this.getTr270());
    }
}

