/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.ebnf.ETile;
import net.sourceforge.plantuml.klimt.CopyForegroundColorToBackgroundColor;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;

public class ETileWithCircles
extends ETile {
    private static final double SIZE = 8.0;
    private final double deltax = 30.0;
    private final ETile orig;
    private final HColor lineColor;

    public ETileWithCircles(ETile orig, HColor lineColor) {
        this.orig = orig;
        this.lineColor = lineColor;
    }

    @Override
    public double getWidth(StringBounder stringBounder) {
        return this.orig.getWidth(stringBounder) + 60.0;
    }

    @Override
    public double getH1(StringBounder stringBounder) {
        return this.orig.getH1(stringBounder);
    }

    @Override
    public double getH2(StringBounder stringBounder) {
        return this.orig.getH2(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        double linePos = this.getH1(ug.getStringBounder());
        XDimension2D fullDim = this.calculateDimension(ug.getStringBounder());
        ug = ug.apply(this.lineColor).apply(new UStroke(1.5));
        this.orig.drawU(ug.apply(UTranslate.dx(30.0)));
        UEllipse circle = new UEllipse(8.0, 8.0);
        ug.apply(new UStroke(2.0)).apply(new UTranslate(0.0, linePos - 4.0)).draw(circle);
        ug.apply(new UStroke(1.0)).apply(new CopyForegroundColorToBackgroundColor()).apply(new UTranslate(fullDim.getWidth() - 4.0, linePos - 4.0)).draw(circle);
        ug = ug.apply(new UStroke(1.5));
        this.drawHlineDirected(ug, linePos, 8.0, 30.0, 0.5);
        this.drawHlineDirected(ug, linePos, fullDim.getWidth() - 30.0, fullDim.getWidth() - 4.0, 0.5);
    }

    @Override
    public void push(ETile tile) {
        throw new UnsupportedOperationException();
    }
}

