/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.help;

import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.help.Help;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandHelpColor
extends SingleLineCommand2<Help> {
    public CommandHelpColor() {
        super(CommandHelpColor.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHelpColor.class.getName(), RegexLeaf.start(), new RegexLeaf("help"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("colors?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
        diagram.add("<b>Help on colors");
        diagram.add(" ");
        diagram.add("The code of this command is located in <i>net.sourceforge.plantuml.help</i> package.");
        diagram.add("You may improve it on <i>https://github.com/plantuml/plantuml/tree/master/src/net/sourceforge/plantuml/help</i>");
        diagram.add(" ");
        diagram.add(" The possible colors are :");
        for (String type : HColorSet.instance().names()) {
            diagram.add("* " + type);
        }
        return CommandExecutionResult.ok();
    }
}

