/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.descdiagram.command;

import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.descdiagram.DescriptionDiagram;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandArchimate
extends SingleLineCommand2<DescriptionDiagram> {
    public CommandArchimate() {
        super(CommandArchimate.getRegexConcat());
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandArchimate.class.getName(), RegexLeaf.start(), new RegexLeaf("SYMBOL", "archimate"), RegexLeaf.spaceOneOrMore(), CommandArchimate.color().getRegex(), RegexLeaf.spaceOneOrMore(), new RegexOr(new RegexLeaf("CODE1", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%g].+?[%g])"), new RegexConcat(new RegexLeaf("DISPLAY2", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE2", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE2", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("CODE3", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE3", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("DISPLAY3", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])")), new RegexConcat(new RegexLeaf("DISPLAY4", "([%g].+?[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\]|[%pLN_.]+)"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("STEREOTYPE4", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("CODE4", "([%pLN_.]+|\\(\\)[%s]*[%pLN_.]+|\\(\\)[%s]*[%g][^%g]+[%g]|:[^:]+:/?|\\([^()]+\\)/?|\\[[^\\[\\]]+\\])"))), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(?:\\<\\<([-\\w]+)\\>\\>)"))), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(DescriptionDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
        String codeRaw = arg.getLazzy("CODE", 0);
        String idShort = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(codeRaw);
        Ident ident = diagram.buildLeafIdent(idShort);
        Code code = diagram.buildCode(idShort);
        String icon = arg.getLazzy("STEREOTYPE", 0);
        ILeaf entity = diagram.getOrCreateLeaf(ident, code, LeafType.DESCRIPTION, USymbols.ARCHIMATE);
        String displayRaw = arg.getLazzy("DISPLAY", 0);
        String display = displayRaw;
        if (display == null) {
            display = code.getName();
        }
        display = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(display);
        entity.setDisplay(Display.getWithNewlines(display));
        entity.setUSymbol(USymbols.ARCHIMATE);
        if (icon != null) {
            entity.setStereotype(Stereotype.build("<<$archimate/" + icon + ">>", diagram.getSkinParam().getCircledCharacterRadius(), diagram.getSkinParam().getFont(null, false, FontParam.CIRCLED_CHARACTER), diagram.getSkinParam().getIHtmlColorSet()));
        }
        Colors colors = CommandArchimate.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        entity.setColors(colors);
        return CommandExecutionResult.ok();
    }
}

