/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.legacy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.creole.Neutron;
import net.sourceforge.plantuml.creole.Parser;
import net.sourceforge.plantuml.creole.atom.Atom;
import net.sourceforge.plantuml.creole.legacy.StripeRaw;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class StripeCode
implements StripeRaw {
    private final FontConfiguration fontConfiguration;
    private final List<String> raw = new ArrayList<String>();
    private boolean terminated;

    public StripeCode(FontConfiguration fontConfiguration) {
        this.fontConfiguration = fontConfiguration;
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this);
    }

    @Override
    public Atom getLHeader() {
        return null;
    }

    @Override
    public boolean addAndCheckTermination(String line) {
        if (Parser.isCodeEnd(line)) {
            this.terminated = true;
            return true;
        }
        this.raw.add(line);
        return false;
    }

    @Override
    public final boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        double width = 0.0;
        double height = 0.0;
        for (String s : this.raw) {
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            width = Math.max(width, dim.getWidth());
            height += dim.getHeight();
        }
        return new XDimension2D(width, height);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public void drawU(UGraphic ug) {
        double y = 0.0;
        for (String s : this.raw) {
            UText shape = new UText(s, this.fontConfiguration);
            StringBounder stringBounder = ug.getStringBounder();
            XDimension2D dim = stringBounder.calculateDimension(this.fontConfiguration.getFont(), s);
            ug.apply(UTranslate.dy((y += dim.getHeight()) - shape.getDescent(stringBounder))).draw(shape);
        }
    }

    @Override
    public List<Neutron> getNeutrons() {
        return Arrays.asList(Neutron.create(this));
    }
}

