/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.regex;

public class FoxSignature {
    private static final long[] masks;
    private static final long MASK_SPACES;
    private static final long MASK_SPECIAL1;

    public static long getSpecialSpaces() {
        return MASK_SPACES;
    }

    public static long getSpecial1() {
        return MASK_SPECIAL1;
    }

    public static void printMe() {
        for (int i = 0; i < masks.length; ++i) {
            if (masks[i] <= 0L) continue;
            char ch = (char)i;
            System.err.println("ch=" + ch + " " + masks[i]);
        }
    }

    private static long getMask(char ch) {
        if (ch < masks.length) {
            return masks[ch];
        }
        if (ch == '\u00a0') {
            return MASK_SPACES;
        }
        return 0L;
    }

    public static long getFoxSignatureFromRealString(String s) {
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            result |= FoxSignature.getMask(s.charAt(i));
        }
        return result;
    }

    public static long getFoxSignatureFromRegex(String s) {
        long result = 0L;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) == '.') {
                if (s.charAt(i + 1) == '+' || s.charAt(i + 1) == '*') {
                    ++i;
                    continue;
                }
                throw new IllegalArgumentException(s);
            }
            if (s.charAt(i) == '\\') {
                if (s.charAt(i + 1) == 'b') {
                    ++i;
                    continue;
                }
                if (!Character.isLetterOrDigit(s.charAt(i + 1))) continue;
                throw new IllegalArgumentException(s);
            }
            if (i + 1 < s.length() && (s.charAt(i + 1) == '?' || s.charAt(i + 1) == '*')) {
                ++i;
                continue;
            }
            result |= FoxSignature.getMask(s.charAt(i));
            if (i + 1 >= s.length() || s.charAt(i + 1) != '+') continue;
            ++i;
        }
        return result;
    }

    public static String backToString(long check) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < masks.length; ++i) {
            if (masks[i] == 0L || (check & masks[i]) == 0L) continue;
            char ch = (char)i;
            sb.append(ch);
        }
        return sb.toString();
    }

    static {
        long m;
        masks = new long[127];
        String full = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~";
        MASK_SPACES = m = 1L;
        MASK_SPECIAL1 = m <<= 1;
        m <<= 1;
        for (int i = 0; i < "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~".length(); ++i) {
            char ch = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0!\"#$%&'()*+,-./:;<=>?@[\\]^_{|}~".charAt(i);
            FoxSignature.masks[ch] = m;
            if (ch >= 'A' && ch <= 'Z') {
                ch = (char)(ch + 32);
                FoxSignature.masks[ch] = m;
            } else if (ch == '.' || ch == '=' || ch == '-' || ch == '~') {
                char c = ch;
                masks[c] = masks[c] | MASK_SPECIAL1;
            }
            m <<= 1;
        }
        FoxSignature.masks[32] = MASK_SPACES;
        FoxSignature.masks[9] = MASK_SPACES;
        FoxSignature.masks[13] = MASK_SPACES;
        FoxSignature.masks[10] = MASK_SPACES;
        FoxSignature.masks[12] = MASK_SPACES;
    }
}

