/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command.note;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.UrlMode;
import net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkArg;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.ugraphic.color.NoSuchColorException;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public final class CommandFactoryNoteActivity
implements SingleMultiFactoryCommand<ActivityDiagram> {
    private IRegex getRegexConcatMultiLine() {
        return RegexConcat.build(CommandFactoryNoteActivity.class.getName() + "multi", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    private IRegex getRegexConcatSingleLine() {
        return RegexConcat.build(CommandFactoryNoteActivity.class.getName() + "single", RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("POSITION", "(right|left|top|bottom)"), RegexLeaf.spaceZeroOrMore(), ColorParser.exp1(), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(":"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("NOTE", "(.*)"), RegexLeaf.end());
    }

    @Override
    public Command<ActivityDiagram> createMultiLine(boolean withBracket) {
        return new CommandMultilines2<ActivityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE, Trim.BOTH){

            @Override
            public String getPatternEnd() {
                return "^[%s]*end[%s]?note$";
            }

            @Override
            public final CommandExecutionResult executeNow(ActivityDiagram diagram, BlocLines lines) throws NoSuchColorException {
                RegexResult arg = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
                lines = lines.subExtract(1, 1);
                lines = lines.removeEmptyColumns();
                Display strings = lines.toDisplay();
                Url url = null;
                if (strings.size() > 0) {
                    UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
                    url = urlBuilder.getUrl(strings.get(0).toString());
                }
                if (url != null) {
                    strings = strings.subList(1, strings.size());
                }
                String codeString = diagram.getUniqueSequence("GMN");
                Ident ident = diagram.buildLeafIdent(codeString);
                Code code = diagram.buildCode(codeString);
                ILeaf note = diagram.createLeaf(ident, code, strings, LeafType.NOTE, null);
                if (url != null) {
                    note.addUrl(url);
                }
                return CommandFactoryNoteActivity.this.executeInternal(diagram, arg, note);
            }
        };
    }

    @Override
    public Command<ActivityDiagram> createSingleLine() {
        return new SingleLineCommand2<ActivityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(ActivityDiagram diagram, LineLocation location, RegexResult arg) throws NoSuchColorException {
                String tmp = diagram.getUniqueSequence("GN");
                Ident ident = diagram.buildLeafIdent(tmp);
                Code code = diagram.buildCode(tmp);
                IEntity note = diagram.createNote(ident, code, Display.getWithNewlines(arg.get("NOTE", 0)));
                return CommandFactoryNoteActivity.this.executeInternal(diagram, arg, note);
            }
        };
    }

    private CommandExecutionResult executeInternal(ActivityDiagram diagram, RegexResult arg, IEntity note) throws NoSuchColorException {
        Link link;
        String s = arg.get("COLOR", 0);
        note.setSpecificColorTOBEREMOVED(ColorType.BACK, s == null ? null : diagram.getSkinParam().getIHtmlColorSet().getColor(s));
        IEntity activity = diagram.getLastEntityConsulted();
        if (activity == null) {
            activity = diagram.getStart();
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(arg.get("POSITION", 0))).withRankdir(diagram.getSkinParam().getRankdir());
        LinkType type = new LinkType(LinkDecor.NONE, LinkDecor.NONE).goDashed();
        if (position == Position.RIGHT) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), activity, note, type, LinkArg.noDisplay(1));
        } else if (position == Position.LEFT) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), note, activity, type, LinkArg.noDisplay(1));
        } else if (position == Position.BOTTOM) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), activity, note, type, LinkArg.noDisplay(2));
        } else if (position == Position.TOP) {
            link = new Link(diagram.getIEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), note, activity, type, LinkArg.noDisplay(2));
        } else {
            throw new IllegalArgumentException();
        }
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

