/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.DisplayPositioned;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandCaption
extends SingleLineCommand2<TitledDiagram> {
    public static final CommandCaption ME = new CommandCaption();

    private CommandCaption() {
        super(CommandCaption.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCaption.class.getName(), RegexLeaf.start(), new RegexLeaf("caption"), new RegexLeaf("(?:[%s]*:[%s]*|[%s]+)"), new RegexOr(new RegexLeaf("DISPLAY1", "[%g](.*)[%g]"), new RegexLeaf("DISPLAY2", "(.*[%pLN_.].*)")), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(TitledDiagram diagram, LineLocation location, RegexResult arg) {
        Display s = Display.getWithNewlines(arg.getLazzy("DISPLAY", 0));
        diagram.setCaption(DisplayPositioned.single(s, HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM));
        return CommandExecutionResult.ok();
    }
}

