/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.baraye;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.baraye.CucaDiagram;
import net.sourceforge.plantuml.baraye.EntityImp;
import net.sourceforge.plantuml.baraye.IEntity;
import net.sourceforge.plantuml.baraye.IGroup;
import net.sourceforge.plantuml.baraye.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodierJSon;
import net.sourceforge.plantuml.cucadiagram.BodierMap;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupRoot;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.HideOrShow2;
import net.sourceforge.plantuml.cucadiagram.Ident;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotag;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.Together;
import net.sourceforge.plantuml.cucadiagram.entity.IEntityFactory;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.skin.VisibilityModifier;

public final class EntityFactory
implements IEntityFactory {
    private final Map<String, ILeaf> leafsByCode;
    private final Map<String, IGroup> groupsByCode;
    public final Map<Ident, ILeaf> leafs2 = new LinkedHashMap<Ident, ILeaf>();
    public final Map<Ident, IGroup> groups2 = new LinkedHashMap<Ident, IGroup>();
    private final List<Link> links = new ArrayList<Link>();
    private int rawLayout;
    private final IGroup rootGroup = new GroupRoot(this);
    private final List<HideOrShow2> hides2;
    private final List<HideOrShow2> removed;
    public final CucaDiagram namespaceSeparator;
    private Map<IGroup, ILeaf> emptyGroupsAsNode = new HashMap<IGroup, ILeaf>();

    public ILeaf getLeafForEmptyGroup(IGroup g) {
        return this.emptyGroupsAsNode.get(g);
    }

    public ILeaf createLeafForEmptyGroup(IGroup g, ISkinParam skinParam) {
        ILeaf folder = this.createLeaf(null, g.getIdent(), g.getCode(), g.getDisplay(), LeafType.EMPTY_PACKAGE, g.getParentContainer(), null, this.namespaceSeparator.getNamespaceSeparator());
        ((EntityImp)folder).setOriginalGroup(g);
        USymbol symbol = g.getUSymbol();
        folder.setUSymbol(symbol);
        folder.setStereotype(g.getStereotype());
        folder.setColors(g.getColors());
        if (g.getUrl99() != null) {
            folder.addUrl(g.getUrl99());
        }
        for (Stereotag tag : g.stereotags()) {
            folder.addStereotag(tag);
        }
        this.emptyGroupsAsNode.put(g, folder);
        return folder;
    }

    public EntityFactory(List<HideOrShow2> hides2, List<HideOrShow2> removed, CucaDiagram namespaceSeparator) {
        this.hides2 = hides2;
        this.removed = removed;
        this.namespaceSeparator = namespaceSeparator;
        this.leafsByCode = new LinkedHashMap<String, ILeaf>();
        this.groupsByCode = new LinkedHashMap<String, IGroup>();
    }

    public boolean isHidden(ILeaf leaf) {
        IEntity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other instanceof ILeaf) {
            return this.isHidden((ILeaf)other);
        }
        boolean hidden = false;
        for (HideOrShow2 hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    @Override
    public boolean isRemoved(Stereotype stereotype) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, stereotype);
        }
        return result;
    }

    public boolean isRemoved(ILeaf leaf) {
        IEntity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other instanceof ILeaf) {
            return this.isRemoved((ILeaf)other);
        }
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    private IEntity isNoteWithSingleLinkAttachedTo(ILeaf note) {
        if (note.getLeafType() != LeafType.NOTE) {
            return null;
        }
        assert (note.getLeafType() == LeafType.NOTE);
        IEntity other = null;
        for (Link link : this.getLinks()) {
            if (link.getType().isInvisible() || !link.contains(note)) continue;
            if (other != null) {
                return null;
            }
            other = link.getOther(note);
            if (other.getLeafType() != LeafType.NOTE) continue;
            return null;
        }
        return other;
    }

    public boolean isRemovedIgnoreUnlinked(ILeaf leaf) {
        boolean result = false;
        for (HideOrShow2 hide : this.removed) {
            if (hide.isAboutUnlinked()) continue;
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public ILeaf createLeaf(Together together, Ident ident, Code code, Display display, LeafType entityType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        Bodier bodier = Objects.requireNonNull(entityType) == LeafType.MAP ? new BodierMap() : (Objects.requireNonNull(entityType) == LeafType.JSON ? new BodierJSon() : BodyFactory.createLeaf(entityType, hides));
        EntityImp result = new EntityImp(ident, code, this, bodier, parentContainer, entityType, namespaceSeparator, this.rawLayout);
        bodier.setLeaf(result);
        result.setDisplay(display);
        result.setTogether(together);
        return result;
    }

    public IGroup createGroup(Ident ident, Code code, Display display, Code namespace, GroupType groupType, IGroup parentContainer, Set<VisibilityModifier> hides, String namespaceSeparator) {
        Objects.requireNonNull(groupType);
        for (Map.Entry<Ident, IGroup> ent : this.groups2.entrySet()) {
            if (!ent.getKey().equals(ident)) continue;
            return ent.getValue();
        }
        Bodier bodier = BodyFactory.createGroup(hides);
        EntityImp result = new EntityImp(ident, code, this, bodier, parentContainer, groupType, namespace, namespaceSeparator, this.rawLayout);
        if (!Display.isNull(display)) {
            result.setDisplay(display);
        }
        return result;
    }

    public void addLeaf(ILeaf entity) {
        this.leafsByCode.put(entity.getCodeGetName(), entity);
        this.leafs2.put(entity.getIdent(), entity);
    }

    public void addGroup(IGroup group) {
        this.groupsByCode.put(group.getCodeGetName(), group);
        this.groups2.put(group.getIdent(), group);
    }

    private void ensureParentIsCreated(Ident ident) {
        if (this.groups2.get(ident.parent()) != null) {
            return;
        }
        this.getParentContainer(ident, null);
    }

    public void removeGroup(String name) {
        IEntity removed2;
        IEntity removed = Objects.requireNonNull(this.groupsByCode.remove(name));
        if (removed != (removed2 = (IEntity)this.groups2.remove(removed.getIdent()))) {
            EntityFactory.bigError();
        }
    }

    public void removeGroup(Ident ident) {
        Objects.requireNonNull(this.groups2.remove(Objects.requireNonNull(ident)));
    }

    public static void bigError() {
    }

    public void removeLeaf(String name) {
        IEntity removed2;
        IEntity removed = Objects.requireNonNull(this.leafsByCode.remove(Objects.requireNonNull(name)));
        if (removed != (removed2 = (IEntity)this.leafs2.remove(removed.getIdent()))) {
            EntityFactory.bigError();
        }
    }

    public void removeLeaf(Ident ident) {
        IEntity removed = this.leafs2.remove(Objects.requireNonNull(ident));
        if (removed == null) {
            System.err.println("leafs2=" + this.leafs2.keySet());
            throw new IllegalArgumentException(ident.toString());
        }
    }

    public IGroup muteToGroup(String name, Code namespace, GroupType type, IGroup parent) {
        ILeaf leaf = this.leafsByCode.get(name);
        ((EntityImp)leaf).muteToGroup(namespace, type, parent);
        IGroup result = (IGroup)((Object)leaf);
        this.removeLeaf(name);
        return result;
    }

    public IGroup getRootGroup() {
        return this.rootGroup;
    }

    public final ILeaf getLeafStrict(Ident ident) {
        return this.leafs2.get(ident);
    }

    public Ident buildFullyQualified(Ident currentPath, Ident id) {
        if (!currentPath.equals(id) && (this.leafs2.containsKey(id) || this.groups2.containsKey(id))) {
            return id;
        }
        if (id.size() > 1) {
            return id;
        }
        return currentPath.add(id);
    }

    public final IGroup getGroupStrict(Ident ident) {
        if (this.namespaceSeparator.getNamespaceSeparator() == null) {
            return this.getGroupVerySmart(ident);
        }
        IGroup result = this.groups2.get(ident);
        return result;
    }

    public final IGroup getGroupVerySmart(Ident ident) {
        IGroup result = this.groups2.get(ident);
        if (result == null) {
            for (Map.Entry<Ident, IGroup> ent : this.groups2.entrySet()) {
                if (!ent.getKey().getLast().equals(ident.getLast())) continue;
                return ent.getValue();
            }
        }
        return result;
    }

    public final ILeaf getLeaf(Code code) {
        ILeaf result = this.leafsByCode.get(code.getName());
        if (result != null && result != this.leafs2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        for (ILeaf tmp : this.leafsByCode.values()) {
            if (!tmp.getIdent().equals(code)) continue;
            return tmp;
        }
        return result;
    }

    public final IGroup getGroup(Code code) {
        IGroup result = this.groupsByCode.get(code.getName());
        if (result != null && result != this.groups2.get(result.getIdent())) {
            EntityFactory.bigError();
        }
        return result;
    }

    @Override
    public final Collection<ILeaf> leafs() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafsByCode.values());
        if (!new ArrayList<ILeaf>(result).equals(new ArrayList<ILeaf>(this.leafs2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groupsByCode.values());
        if (!new ArrayList<IGroup>(result).equals(new ArrayList<IGroup>(this.groups2()))) {
            EntityFactory.bigError();
        }
        return result;
    }

    public final Collection<IGroup> groups2() {
        Collection<IGroup> result = Collections.unmodifiableCollection(this.groups2.values());
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<ILeaf> leafs2() {
        Collection<ILeaf> result = Collections.unmodifiableCollection(this.leafs2.values());
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public IGroup getParentContainer(Ident ident, IGroup parentContainer) {
        return Objects.requireNonNull(parentContainer);
    }

    public CucaDiagram getDiagram() {
        return this.namespaceSeparator;
    }
}

