/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.posimo;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.posimo.Block;
import net.sourceforge.plantuml.posimo.Cluster;
import net.sourceforge.plantuml.posimo.Clusterable;
import net.sourceforge.plantuml.posimo.Label;
import net.sourceforge.plantuml.posimo.Path;

public class SimpleDrawer {
    private final Cluster root;
    private final Collection<Path> paths;

    public SimpleDrawer(Cluster root, Collection<Path> paths) {
        this.root = root;
        this.paths = paths;
    }

    public void draw(Graphics2D g2d) {
        g2d.setColor(Color.BLACK);
        for (Clusterable clusterable : this.root.getContents()) {
            Block b = (Block)clusterable;
            XPoint2D pos = b.getPosition();
            XDimension2D dim = b.getSize();
            this.drawRect(g2d, pos, dim);
        }
        g2d.setColor(Color.GREEN);
        for (Path path : this.paths) {
            Label label = path.getLabel();
            XPoint2D labelPos = label.getPosition();
            XDimension2D labelDim = label.getSize();
            this.drawRect(g2d, labelPos, labelDim);
        }
        g2d.setColor(Color.RED);
        for (Path path : this.paths) {
            path.getDotPath().draw(g2d, 0.0, 0.0);
        }
        for (Cluster cluster : this.root.getSubClusters()) {
            new SimpleDrawer(cluster, new ArrayList<Path>()).draw(g2d);
        }
    }

    private void drawRectCentered(Graphics2D g2d, XPoint2D pos, XDimension2D dim) {
        Rectangle2D.Double rect = new Rectangle2D.Double(pos.getX() - dim.getWidth() / 2.0, pos.getY() - dim.getHeight() / 2.0, dim.getWidth(), dim.getHeight());
        g2d.draw(rect);
    }

    private void drawRect(Graphics2D g2d, XPoint2D pos, XDimension2D dim) {
        Rectangle2D.Double rect = new Rectangle2D.Double(pos.getX(), pos.getY(), dim.getWidth(), dim.getHeight());
        g2d.draw(rect);
    }
}

