/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.util.Objects;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.graphic.AbstractTextBlock;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.SymbolContext;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import net.sourceforge.plantuml.ugraphic.UTranslate;

abstract class USymbolSimpleAbstract
extends USymbol {
    USymbolSimpleAbstract() {
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        Objects.requireNonNull(stereotype);
        final TextBlock stickman = this.getDrawing(symbolContext);
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                StringBounder stringBounder = ug.getStringBounder();
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                XDimension2D dimStickMan = stickman.calculateDimension(stringBounder);
                XDimension2D dimTotal = this.calculateDimension(stringBounder);
                double stickmanX = (dimTotal.getWidth() - dimStickMan.getWidth()) / 2.0;
                double stickmanY = dimStereo.getHeight();
                ug = symbolContext.apply(ug);
                stickman.drawU(ug.apply(new UTranslate(stickmanX, stickmanY)));
                double labelX = (dimTotal.getWidth() - dimLabel.getWidth()) / 2.0;
                double labelY = dimStickMan.getHeight() + dimStereo.getHeight();
                UGraphic ug2 = UGraphicStencil.create(ug, dimLabel);
                label.drawU(ug2.apply(new UTranslate(labelX, labelY)));
                double stereoX = (dimTotal.getWidth() - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(UTranslate.dx(stereoX)));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                XDimension2D dimActor = stickman.calculateDimension(stringBounder);
                return XDimension2D.mergeLayoutT12B3(dimStereo, dimActor, dimLabel);
            }
        };
    }

    protected abstract TextBlock getDrawing(SymbolContext var1);

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, SymbolContext symbolContext, HorizontalAlignment stereoAlignment) {
        throw new UnsupportedOperationException();
    }
}

