/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.braille;

import java.util.ArrayList;
import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.braille.BrailleGrid;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public class DriverPolygonBraille
implements UDriver<UPolygon, BrailleGrid> {
    private final ClipContainer clipContainer;

    public DriverPolygonBraille(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UPolygon shape, double x, double y, ColorMapper mapper, UParam param, BrailleGrid grid) {
        ArrayList<XPoint2D> points = new ArrayList<XPoint2D>();
        boolean i = false;
        for (XPoint2D pt : shape.getPoints()) {
            points.add(new UTranslate(x, y).getTranslated(pt));
        }
        UClip clip = this.clipContainer.getClip();
        if (clip != null) {
            for (XPoint2D pt : points) {
                if (clip.isInside(pt)) continue;
                return;
            }
        }
        grid.drawPolygon(points);
    }
}

