/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.asciiart;

import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.asciiart.AbstractComponentText;
import net.sourceforge.plantuml.asciiart.AsciiShape;
import net.sourceforge.plantuml.asciiart.UmlCharArea;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.Context2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextActor
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;
    private final AsciiShape shape;

    public ComponentTextActor(ComponentType type, Display stringsToDisplay, FileFormat fileFormat, AsciiShape shape) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
        this.shape = shape;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        XDimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        charArea.fillRect(' ', 0, 0, width, height);
        int xman = width / 2 - 1;
        if (this.type == ComponentType.ACTOR_HEAD) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawStringsLRUnicode(this.stringsToDisplay.asList(), 1, this.getHeight());
                charArea.drawShape(AsciiShape.STICKMAN_UNICODE, xman, 0);
            } else {
                charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 1, this.getHeight());
                charArea.drawShape(AsciiShape.STICKMAN, xman, 0);
            }
        } else if (this.type == ComponentType.ACTOR_TAIL) {
            if (this.fileFormat == FileFormat.UTXT) {
                charArea.drawStringsLRUnicode(this.stringsToDisplay.asList(), 1, 0);
                charArea.drawShape(AsciiShape.STICKMAN_UNICODE, xman, 1);
            } else {
                charArea.drawStringsLRSimple(this.stringsToDisplay.asList(), 1, 0);
                charArea.drawShape(AsciiShape.STICKMAN, xman, 1);
            }
        } else assert (false);
    }

    private int getHeight() {
        if (this.fileFormat == FileFormat.UTXT) {
            return AsciiShape.STICKMAN_UNICODE.getHeight();
        }
        return AsciiShape.STICKMAN.getHeight();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + this.getHeight();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

