/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.Branch;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidthCentered;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside2;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.Rainbow;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

class FtileSwitch
extends AbstractFtile {
    private final double xSeparation = 20.0;
    private final List<Ftile> tiles;
    private final Rainbow arrowColor;

    private FtileSwitch(List<Double> inlabelSizes, List<Ftile> tiles, Rainbow arrowColor) {
        super(tiles.get(0).skinParam());
        this.tiles = new ArrayList<Ftile>(tiles);
        this.arrowColor = arrowColor;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        HashSet<Swimlane> result = new HashSet<Swimlane>();
        if (this.getSwimlaneIn() != null) {
            result.add(this.getSwimlaneIn());
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tiles.get(0).getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.getSwimlaneIn();
    }

    static Ftile create(Swimlane swimlane, HColor borderColor, HColor backColor, Rainbow arrowColor, FtileFactory ftileFactory, ConditionStyle conditionStyle, List<Branch> thens, FontConfiguration fcArrow, LinkRendering topInlinkRendering, LinkRendering afterEndwhile, FontConfiguration fcTest) {
        Objects.requireNonNull(afterEndwhile);
        ArrayList<Ftile> tiles = new ArrayList<Ftile>();
        for (Branch branch : thens) {
            tiles.add(new FtileMinWidthCentered(branch.getFtile(), 30.0));
        }
        ArrayList<Double> inlabelSizes = new ArrayList<Double>();
        for (Branch branch : thens) {
            TextBlock tb1 = branch.getDisplayPositive().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
            TextBlock tbTest = branch.getLabelTest().create(fcTest, ftileFactory.skinParam().getDefaultTextAlignment(HorizontalAlignment.LEFT), ftileFactory.skinParam());
            HColor diamondColor = branch.getColor() == null ? backColor : branch.getColor();
            FtileDiamondInside2 diamond = new FtileDiamondInside2(tbTest, branch.skinParam(), diamondColor, borderColor, swimlane);
            TextBlock tbInlabel = null;
            if (Display.isNull(branch.getInlabel())) {
                inlabelSizes.add(0.0);
            } else {
                tbInlabel = branch.getInlabel().create(fcArrow, HorizontalAlignment.LEFT, ftileFactory.skinParam());
                inlabelSizes.add(tbInlabel.calculateDimension(ftileFactory.getStringBounder()).getWidth());
                diamond = diamond.withWest(tbInlabel);
            }
            diamond = diamond.withNorth(tb1);
        }
        return new FtileSwitch(inlabelSizes, tiles, arrowColor);
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        ArrayList<Ftile> result = new ArrayList<Ftile>(this.tiles);
        return Collections.unmodifiableList(result);
    }

    @Override
    public UTranslate getTranslateFor(Ftile child, StringBounder stringBounder) {
        if (this.tiles.contains(child)) {
            return this.getTranslate1(child, stringBounder);
        }
        throw new UnsupportedOperationException();
    }

    private UTranslate getTranslate1(Ftile tile, StringBounder stringBounder) {
        double x1 = 0.0;
        for (Ftile candidate : this.tiles) {
            FtileGeometry dim1 = candidate.calculateDimension(stringBounder);
            if (candidate == tile) {
                return new UTranslate(x1, 25.0);
            }
            x1 += dim1.getWidth() + 20.0;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        for (Ftile tile : this.tiles) {
            ug.apply(this.getTranslate1(tile, stringBounder)).draw(tile);
        }
    }

    private FtileGeometry calculateDimensionInternal(StringBounder stringBounder) {
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (Ftile couple : this.tiles) {
            result = result.mergeLR(couple.calculateDimension(stringBounder));
        }
        result = result.delta(20.0 * (double)(this.tiles.size() - 1), 100.0);
        return new FtileGeometry(result, result.getWidth() / 2.0, 0.0);
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        FtileGeometry dimTotal = this.calculateDimensionInternal(stringBounder);
        ArrayList<Ftile> all = new ArrayList<Ftile>(this.tiles);
        for (Ftile tmp : all) {
            if (!tmp.calculateDimension(stringBounder).hasPointOut()) continue;
            return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0, ((XDimension2D)dimTotal).getHeight());
        }
        return new FtileGeometry(dimTotal, ((XDimension2D)dimTotal).getWidth() / 2.0, 0.0);
    }
}

