/*
 * Decompiled with CFR 0.152.
 */
package org.fontbox.ttf;

import java.io.IOException;
import org.fontbox.ttf.HorizontalHeaderTable;
import org.fontbox.ttf.MaximumProfileTable;
import org.fontbox.ttf.TTFDataStream;
import org.fontbox.ttf.TTFTable;
import org.fontbox.ttf.TrueTypeFont;

public class HorizontalMetricsTable
extends TTFTable {
    public static final String TAG = "hmtx";
    private int[] advanceWidth;
    private short[] leftSideBearing;
    private short[] nonHorizontalLeftSideBearing;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        HorizontalHeaderTable hHeader = ttf.getHorizontalHeader();
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        int numHMetrics = hHeader.getNumberOfHMetrics();
        int numGlyphs = maxp.getNumGlyphs();
        this.advanceWidth = new int[numHMetrics];
        this.leftSideBearing = new short[numHMetrics];
        int i = 0;
        while (i < numHMetrics) {
            this.advanceWidth[i] = data.readUnsignedShort();
            this.leftSideBearing[i] = data.readSignedShort();
            ++i;
        }
        int numberNonHorizontal = numGlyphs - numHMetrics;
        this.nonHorizontalLeftSideBearing = new short[numberNonHorizontal];
        int i2 = 0;
        while (i2 < numberNonHorizontal) {
            this.nonHorizontalLeftSideBearing[i2] = data.readSignedShort();
            ++i2;
        }
    }

    public int[] getAdvanceWidth() {
        return this.advanceWidth;
    }

    public void setAdvanceWidth(int[] advanceWidthValue) {
        this.advanceWidth = advanceWidthValue;
    }
}

