/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;

public class OriginatorIdentifierOrKey
extends ASN1Encodable {
    private DEREncodable id;

    public OriginatorIdentifierOrKey(IssuerAndSerialNumber issuerAndSerialNumber) {
        this.id = issuerAndSerialNumber;
    }

    public OriginatorIdentifierOrKey(ASN1OctetString aSN1OctetString) {
        this.id = new DERTaggedObject(false, 0, aSN1OctetString);
    }

    public OriginatorIdentifierOrKey(OriginatorPublicKey originatorPublicKey) {
        this.id = new DERTaggedObject(false, 1, originatorPublicKey);
    }

    public OriginatorIdentifierOrKey(DERObject dERObject) {
        this.id = dERObject;
    }

    public static OriginatorIdentifierOrKey getInstance(ASN1TaggedObject aSN1TaggedObject, boolean bl) {
        if (!bl) {
            throw new IllegalArgumentException("Can't implicitly tag OriginatorIdentifierOrKey");
        }
        return OriginatorIdentifierOrKey.getInstance(aSN1TaggedObject.getObject());
    }

    public static OriginatorIdentifierOrKey getInstance(Object object) {
        if (object == null || object instanceof OriginatorIdentifierOrKey) {
            return (OriginatorIdentifierOrKey)object;
        }
        if (object instanceof DERObject) {
            return new OriginatorIdentifierOrKey((DERObject)object);
        }
        throw new IllegalArgumentException("Invalid OriginatorIdentifierOrKey: " + object.getClass().getName());
    }

    public DEREncodable getId() {
        return this.id;
    }

    public DERObject toASN1Object() {
        return this.id.getDERObject();
    }
}

