/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;

public class BasicComponentParameter
implements Serializable,
Parameter {
    public static final BasicComponentParameter BASIC_DEFAULT = new BasicComponentParameter();
    private Object componentKey;

    public BasicComponentParameter(Object componentKey) {
        this.componentKey = componentKey;
    }

    public BasicComponentParameter() {
    }

    public boolean isResolvable(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        return this.resolveAdapter(container2, adapter, expectedType) != null;
    }

    public Object resolveInstance(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter componentAdapter = this.resolveAdapter(container2, adapter, expectedType);
        if (componentAdapter != null) {
            return container2.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private ComponentAdapter resolveAdapter(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result2 = this.getTargetAdapter(container2, expectedType, adapter);
        if (result2 == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result2.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result2.getComponentImplementation().getField("TYPE");
                    Class type2 = (Class)field.get(result2.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type2)) {
                        return result2;
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (IllegalArgumentException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (ClassCastException e) {
                    // empty catch block
                }
            }
            return null;
        }
        return result2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container2, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container2.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container2.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container2.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List found = container2.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        Iterator iterator2 = found.iterator();
        while (iterator2.hasNext()) {
            ComponentAdapter work = (ComponentAdapter)iterator2.next();
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found.remove(exclude);
        if (found.size() == 0) {
            if (container2.getParent() != null) {
                return container2.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found.size() == 1) {
            return (ComponentAdapter)found.get(0);
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = ((ComponentAdapter)found.get(i)).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

