/*
 * Decompiled with CFR 0.152.
 */
package org.jdom;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.EmptyIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.ImmutableAttribute;
import org.jdom.ImmutableElement;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jetbrains.annotations.NotNull;

class ImmutableSameTypeAttributeList
implements List<Attribute> {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private final String[] myNameValues;
    private final AttributeType myType;
    private final Namespace myNs;

    ImmutableSameTypeAttributeList(@NotNull String[] nameValues, AttributeType type2, @NotNull Namespace ns) {
        if (nameValues == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(0);
        }
        if (ns == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(1);
        }
        this.myNameValues = nameValues.length == 0 ? EMPTY_STRING_ARRAY : nameValues;
        this.myType = type2;
        this.myNs = ns;
    }

    @Override
    public Attribute get(int index2) {
        return new ImmutableAttribute(this.myNameValues[index2 * 2], this.myNameValues[index2 * 2 + 1], this.myType, this.myNs);
    }

    Attribute get(String name, Namespace namespace) {
        if (!this.myNs.equals(namespace)) {
            return null;
        }
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String aname = this.myNameValues[i];
            if (!aname.equals(name)) continue;
            return this.get(i / 2);
        }
        return null;
    }

    String getValue(String name, Namespace namespace, String def) {
        if (!this.myNs.equals(namespace)) {
            return def;
        }
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String aname = this.myNameValues[i];
            if (!aname.equals(name)) continue;
            return this.myNameValues[i + 1];
        }
        return def;
    }

    @Override
    public int size() {
        return this.myNameValues.length / 2;
    }

    public String toString() {
        return this.toList().toString();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size(); ++i) {
            if (!Comparing.equal(0, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.size() - 1; i >= 0; --i) {
            if (!Comparing.equal(0, this.get(i))) continue;
            return i;
        }
        return -1;
    }

    @Override
    @NotNull
    public Iterator<Attribute> iterator() {
        if (this.isEmpty()) {
            EmptyIterator<Attribute> emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                ImmutableSameTypeAttributeList.$$$reportNull$$$0(2);
            }
            return emptyIterator;
        }
        Iterator<Attribute> iterator2 = new Iterator<Attribute>(){
            int i;

            @Override
            public boolean hasNext() {
                return this.i < ImmutableSameTypeAttributeList.this.size();
            }

            @Override
            public Attribute next() {
                return ImmutableSameTypeAttributeList.this.get(this.i++);
            }

            @Override
            public void remove() {
                throw ImmutableElement.immutableError(ImmutableSameTypeAttributeList.this);
            }
        };
        if (iterator2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(3);
        }
        return iterator2;
    }

    @Override
    @NotNull
    public List<Attribute> subList(int fromIndex, int toIndex) {
        List<Attribute> list2 = this.toList().subList(fromIndex, toIndex);
        if (list2 == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(4);
        }
        return list2;
    }

    private List<Attribute> toList() {
        ArrayList<Attribute> list2 = new ArrayList<Attribute>(this.size());
        for (int i = 0; i < this.size(); ++i) {
            list2.add(this.get(i));
        }
        return list2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List) || this.size() != ((List)o).size()) {
            return false;
        }
        if (this.size() == 0) {
            return true;
        }
        if (o instanceof ImmutableSameTypeAttributeList) {
            ImmutableSameTypeAttributeList io = (ImmutableSameTypeAttributeList)o;
            return this.myType == io.myType && this.myNs.equals(io.myNs) && Arrays.equals(this.myNameValues, io.myNameValues);
        }
        List l = (List)o;
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String name = this.myNameValues[i];
            String value = this.myNameValues[i + 1];
            Attribute a2 = (Attribute)l.get(i / 2);
            if (Comparing.equal(name, a2.getName()) && Comparing.equal(value, a2.getValue()) && Comparing.equal(this.myType, a2.getAttributeType()) && Comparing.equal(this.myNs, a2.getNamespace())) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result2 = 1;
        for (int i = 0; i < this.myNameValues.length; i += 2) {
            String name = this.myNameValues[i];
            String value = this.myNameValues[i + 1];
            result2 = result2 * 31 + JDOMInterner.computeAttributeHashCode(name, value);
        }
        return result2;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] objectArray = this.toList().toArray(new Attribute[0]);
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(5);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        if (a == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(6);
        }
        Object[] objectArray = this.toArray();
        if (objectArray == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(8);
        }
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean add(Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void add(int index2, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(9);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends Attribute> collection) {
        if (collection == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(10);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public void clear() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute remove(int index2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public Attribute set(int index2, Attribute obj) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator() {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    @NotNull
    public ListIterator<Attribute> listIterator(int index2) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean remove(Object o) {
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(11);
        }
        throw ImmutableElement.immutableError(this);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            ImmutableSameTypeAttributeList.$$$reportNull$$$0(12);
        }
        throw ImmutableElement.immutableError(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameValues";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ns";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 8: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jdom/ImmutableSameTypeAttributeList";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "subList";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

