/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.contracts.parsing.effects;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.EffectDeclaration;
import org.jetbrains.kotlin.contracts.description.InvocationKind;
import org.jetbrains.kotlin.contracts.description.expressions.VariableReference;
import org.jetbrains.kotlin.contracts.parsing.AbstractPsiEffectParser;
import org.jetbrains.kotlin.contracts.parsing.ContractsDslNames;
import org.jetbrains.kotlin.contracts.parsing.PsiContractParserDispatcher;
import org.jetbrains.kotlin.contracts.parsing.PsiContractsUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.DefaultValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ExpressionValueArgument;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedValueArgument;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0016\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/contracts/parsing/effects/PsiCallsEffectParser;", "Lorg/jetbrains/kotlin/contracts/parsing/AbstractPsiEffectParser;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "contractParserDispatcher", "Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;", "(Lorg/jetbrains/kotlin/resolve/BindingTrace;Lorg/jetbrains/kotlin/contracts/parsing/PsiContractParserDispatcher;)V", "tryParseEffect", "Lorg/jetbrains/kotlin/contracts/description/EffectDeclaration;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "toInvocationKind", "Lorg/jetbrains/kotlin/contracts/description/InvocationKind;", "frontend"})
public final class PsiCallsEffectParser
extends AbstractPsiEffectParser {
    @Override
    @Nullable
    public EffectDeclaration tryParseEffect(@NotNull KtExpression expression2) {
        Object object;
        ResolvedValueArgument kindArgument;
        Intrinsics.checkParameterIsNotNull(expression2, "expression");
        KtElement ktElement = expression2;
        BindingContext bindingContext = this.getTrace().getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> resolvedCall3 = resolvedCall2;
        CallableDescriptor descriptor2 = resolvedCall3.getResultingDescriptor();
        if (!PsiContractsUtilsKt.isCallsInPlaceEffectDescriptor(descriptor2)) {
            return null;
        }
        VariableReference variableReference = this.getContractParserDispatcher().parseVariable(PsiContractsUtilsKt.firstArgumentAsExpressionOrNull(resolvedCall3));
        if (variableReference == null) {
            return null;
        }
        VariableReference lambda2 = variableReference;
        List<ResolvedValueArgument> list2 = resolvedCall3.getValueArgumentsByIndex();
        ResolvedValueArgument resolvedValueArgument = kindArgument = list2 != null ? CollectionsKt.getOrNull(list2, 1) : null;
        if (resolvedValueArgument instanceof DefaultValueArgument) {
            object = InvocationKind.UNKNOWN;
        } else if (resolvedValueArgument instanceof ExpressionValueArgument) {
            object = ((ExpressionValueArgument)kindArgument).getValueArgument();
            if (object == null || (object = object.getArgumentExpression()) == null || (object = this.toInvocationKind((KtExpression)object, this.getTrace())) == null) {
                return null;
            }
        } else {
            return null;
        }
        InvocationKind kind = object;
        return new CallsEffectDeclaration(lambda2, kind);
    }

    private final InvocationKind toInvocationKind(@NotNull KtExpression $receiver, BindingTrace trace) {
        KtElement ktElement = $receiver;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkExpressionValueIsNotNull(bindingContext, "trace.bindingContext");
        ResolvedCall<? extends CallableDescriptor> resolvedCall2 = CallUtilKt.getResolvedCall(ktElement, bindingContext);
        if (resolvedCall2 == null || (resolvedCall2 = resolvedCall2.getResultingDescriptor()) == null) {
            return null;
        }
        ResolvedCall<? extends CallableDescriptor> descriptor2 = resolvedCall2;
        if (!PsiContractsUtilsKt.isInvocationKindEnum(SequencesKt.first(DescriptorUtilsKt.getParents((DeclarationDescriptor)((Object)descriptor2))))) {
            return null;
        }
        Name name = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((Object)descriptor2)).shortName();
        return Intrinsics.areEqual(name, ContractsDslNames.INSTANCE.getAT_MOST_ONCE_KIND()) ? InvocationKind.AT_MOST_ONCE : (Intrinsics.areEqual(name, ContractsDslNames.INSTANCE.getEXACTLY_ONCE_KIND()) ? InvocationKind.EXACTLY_ONCE : (Intrinsics.areEqual(name, ContractsDslNames.INSTANCE.getAT_LEAST_ONCE_KIND()) ? InvocationKind.AT_LEAST_ONCE : (Intrinsics.areEqual(name, ContractsDslNames.INSTANCE.getUNKNOWN_KIND()) ? InvocationKind.UNKNOWN : null)));
    }

    public PsiCallsEffectParser(@NotNull BindingTrace trace, @NotNull PsiContractParserDispatcher contractParserDispatcher) {
        Intrinsics.checkParameterIsNotNull(trace, "trace");
        Intrinsics.checkParameterIsNotNull(contractParserDispatcher, "contractParserDispatcher");
        super(trace, contractParserDispatcher);
    }
}

