/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower;

import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.lower.DeclarationIrBuilder;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrBuildersKt;
import org.jetbrains.kotlin.ir.builders.Scope;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrExpressionBodyImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrIfThenElseImpl;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u00020\u0010*\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0014\u0010\u0014\u001a\u00020\u0015*\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/LateinitLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "generateParameterNameInAssertion", "", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;Z)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "throwErrorFunction", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrBlock;", "Lorg/jetbrains/kotlin/ir/builders/IrBuilderWithScope;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "throwUninitializedPropertyAccessException", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "backingFieldSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrFieldSymbol;", "backend-common"})
public final class LateinitLowering
implements FileLoweringPass {
    private final IrFunctionSymbol throwErrorFunction;
    @NotNull
    private final CommonBackendContext context;
    private final boolean generateParameterNameInAssertion;

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkParameterIsNotNull(irFile, "irFile");
        IrElementTransformerVoidKt.transformChildrenVoid(irFile, new IrElementTransformerVoid(this){
            final /* synthetic */ LateinitLowering this$0;

            @NotNull
            public IrStatement visitProperty(@NotNull IrProperty declaration) {
                Intrinsics.checkParameterIsNotNull(declaration, "declaration");
                if (declaration.getDescriptor().isLateInit()) {
                    CallableMemberDescriptor.Kind kind = declaration.getDescriptor().getKind();
                    Intrinsics.checkExpressionValueIsNotNull((Object)((Object)kind), "declaration.descriptor.kind");
                    if (kind.isReal()) {
                        IrField irField = declaration.getBackingField();
                        if (irField == null) {
                            Intrinsics.throwNpe();
                        }
                        IrFieldSymbol irFieldSymbol = (IrFieldSymbol)irField.getSymbol();
                        IrFunction irFunction = declaration.getGetter();
                        if (irFunction == null) {
                            Intrinsics.throwNpe();
                        }
                        this.transformGetter(irFieldSymbol, irFunction);
                    }
                }
                return declaration;
            }

            private final void transformGetter(IrFieldSymbol backingFieldSymbol, IrFunction getter2) {
                IrGetValueImpl irGetValueImpl;
                DeclarationIrBuilder irBuilder;
                DeclarationIrBuilder declarationIrBuilder;
                boolean bl;
                KotlinType type2 = ((PropertyDescriptor)backingFieldSymbol.getDescriptor()).getType();
                boolean bl2 = bl = !KotlinBuiltIns.isPrimitiveType(type2);
                if (_Assertions.ENABLED && !bl) {
                    String string = "'lateinit' modifier is not allowed on primitive types";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                int startOffset = getter2.getStartOffset();
                int endOffset = getter2.getEndOffset();
                DeclarationIrBuilder $receiver = declarationIrBuilder = (irBuilder = LowerUtilsKt.createIrBuilder(this.this$0.getContext(), getter2.getSymbol(), startOffset, endOffset));
                IrBuilderWithScope irBuilderWithScope = $receiver;
                KotlinType kotlinType = type2;
                Intrinsics.checkExpressionValueIsNotNull(kotlinType, "type");
                IrBlock block = LateinitLowering.access$irBlock(this.this$0, irBuilderWithScope, kotlinType);
                Scope scope = $receiver.getScope();
                IrBuilderWithScope irBuilderWithScope2 = $receiver;
                IrValueParameter irValueParameter = getter2.getDispatchReceiverParameter();
                if (irValueParameter != null) {
                    IrValueParameter irValueParameter2 = irValueParameter;
                    IrBuilderWithScope irBuilderWithScope3 = irBuilderWithScope2;
                    Scope scope2 = scope;
                    IrValueParameter it = irValueParameter2;
                    IrGetValueImpl irGetValueImpl2 = ExpressionHelpersKt.irGet($receiver, (IrValueSymbol)it.getSymbol());
                    scope = scope2;
                    irBuilderWithScope2 = irBuilderWithScope3;
                    irGetValueImpl = irGetValueImpl2;
                } else {
                    irGetValueImpl = null;
                }
                IrVariable resultVar = Scope.createTemporaryVariable$default(scope, IrBuildersKt.irGetField(irBuilderWithScope2, irGetValueImpl, backingFieldSymbol), null, false, null, 14, null);
                block.getStatements().add(resultVar);
                IrBuilderWithScope irBuilderWithScope4 = $receiver;
                SimpleType simpleType2 = $receiver.getContext().getBuiltIns().getNothingType();
                Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.nothingType");
                IrIfThenElseImpl throwIfNull = ExpressionHelpersKt.irIfThenElse(irBuilderWithScope4, simpleType2, ExpressionHelpersKt.irNotEquals($receiver, ExpressionHelpersKt.irGet($receiver, (IrValueSymbol)resultVar.getSymbol()), ExpressionHelpersKt.irNull($receiver)), ExpressionHelpersKt.irReturn($receiver, ExpressionHelpersKt.irGet($receiver, (IrValueSymbol)resultVar.getSymbol())), LateinitLowering.access$throwUninitializedPropertyAccessException(this.this$0, $receiver, backingFieldSymbol));
                block.getStatements().add(throwIfNull);
                getter2.setBody(new IrExpressionBodyImpl(startOffset, endOffset, block));
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final IrCall throwUninitializedPropertyAccessException(@NotNull IrBuilderWithScope $receiver, IrFieldSymbol backingFieldSymbol) {
        IrCall irCall;
        IrCall $receiver2 = irCall = ExpressionHelpersKt.irCall($receiver, this.throwErrorFunction);
        if (this.generateParameterNameInAssertion) {
            SimpleType simpleType2 = $receiver.getContext().getBuiltIns().getStringType();
            Intrinsics.checkExpressionValueIsNotNull(simpleType2, "context.builtIns.stringType");
            KotlinType kotlinType = simpleType2;
            String string = ((PropertyDescriptor)backingFieldSymbol.getDescriptor()).getName().asString();
            Intrinsics.checkExpressionValueIsNotNull(string, "backingFieldSymbol.descriptor.name.asString()");
            $receiver2.putValueArgument(0, IrConstImpl.Companion.string(-1, -1, kotlinType, string));
        }
        return irCall;
    }

    private final IrBlock irBlock(@NotNull IrBuilderWithScope $receiver, KotlinType type2) {
        return new IrBlockImpl($receiver.getStartOffset(), $receiver.getEndOffset(), type2, null, 8, null);
    }

    @NotNull
    public final CommonBackendContext getContext() {
        return this.context;
    }

    public LateinitLowering(@NotNull CommonBackendContext context, boolean generateParameterNameInAssertion) {
        Intrinsics.checkParameterIsNotNull(context, "context");
        this.context = context;
        this.generateParameterNameInAssertion = generateParameterNameInAssertion;
        this.throwErrorFunction = this.context.getIr().getSymbols().getThrowUninitializedPropertyAccessException();
    }

    public /* synthetic */ LateinitLowering(CommonBackendContext commonBackendContext, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(commonBackendContext, bl);
    }

    @NotNull
    public static final /* synthetic */ IrBlock access$irBlock(LateinitLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull KotlinType type2) {
        return $this.irBlock($receiver, type2);
    }

    @NotNull
    public static final /* synthetic */ IrCall access$throwUninitializedPropertyAccessException(LateinitLowering $this, @NotNull IrBuilderWithScope $receiver, @NotNull IrFieldSymbol backingFieldSymbol) {
        return $this.throwUninitializedPropertyAccessException($receiver, backingFieldSymbol);
    }
}

