/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.utils;

import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModalityUtilsKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.js.translate.context.Namer;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.tasks.DynamicCallsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

public final class JsDescriptorUtils {
    private static final Set<String> FAKE_CLASSES = ContainerUtil.immutableSet(StandardNames.FqNames.any.asString());

    private JsDescriptorUtils() {
    }

    private static int valueParametersCount(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(0);
        }
        return functionDescriptor.getValueParameters().size();
    }

    public static boolean hasParameters(@NotNull FunctionDescriptor functionDescriptor) {
        if (functionDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(1);
        }
        return JsDescriptorUtils.valueParametersCount(functionDescriptor) > 0;
    }

    public static boolean isCompareTo(@NotNull CallableDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(2);
        }
        return descriptor2.getName().equals(OperatorNameConventions.COMPARE_TO);
    }

    @Nullable
    public static ClassDescriptor findAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        if (superclassDescriptors == null) {
            JsDescriptorUtils.$$$reportNull$$$0(3);
        }
        for (ClassDescriptor descriptor2 : superclassDescriptors) {
            if (descriptor2.getKind() != ClassKind.CLASS && descriptor2.getKind() != ClassKind.ENUM_CLASS) continue;
            return descriptor2;
        }
        return null;
    }

    @Nullable
    public static ClassDescriptor getSuperclass(@NotNull ClassDescriptor classDescriptor2) {
        if (classDescriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(4);
        }
        return JsDescriptorUtils.findAncestorClass(DescriptorUtils.getSuperclassDescriptors(classDescriptor2));
    }

    @NotNull
    public static List<KotlinType> getSupertypesWithoutFakes(ClassDescriptor descriptor2) {
        Collection<KotlinType> supertypes2 = descriptor2.getTypeConstructor().getSupertypes();
        List<KotlinType> list2 = ContainerUtil.filter(supertypes2, type2 -> {
            ClassDescriptor classDescriptor2 = DescriptorUtils.getClassDescriptorForType(type2);
            return !FAKE_CLASSES.contains(DescriptorUtils.getFqNameSafe(classDescriptor2).asString()) && (classDescriptor2.getKind() != ClassKind.INTERFACE || !AnnotationsUtils.isNativeObject(classDescriptor2));
        });
        if (list2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public static DeclarationDescriptor getContainingDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(6);
        }
        DeclarationDescriptor containing = descriptor2.getContainingDeclaration();
        assert (containing != null) : "Should be called on objects that have containing declaration.";
        DeclarationDescriptor declarationDescriptor = containing;
        if (declarationDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(7);
        }
        return declarationDescriptor;
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            JsDescriptorUtils.$$$reportNull$$$0(8);
        }
        DeclarationDescriptor declarationDescriptor = JsDescriptorUtils.getDeclarationDescriptorForReceiver(receiverParameter);
        return JsDescriptorUtils.getReceiverParameterForDeclaration(declarationDescriptor);
    }

    @NotNull
    private static DeclarationDescriptor getDeclarationDescriptorForReceiver(@NotNull ReceiverValue receiverParameter) {
        if (receiverParameter == null) {
            JsDescriptorUtils.$$$reportNull$$$0(9);
        }
        if (receiverParameter instanceof ImplicitReceiver) {
            DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiverParameter).getDeclarationDescriptor();
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor.getOriginal();
            if (declarationDescriptor2 == null) {
                JsDescriptorUtils.$$$reportNull$$$0(10);
            }
            return declarationDescriptor2;
        }
        throw new UnsupportedOperationException("Unsupported receiver type: " + receiverParameter.getClass() + ", receiverParameter = " + receiverParameter);
    }

    @NotNull
    public static ReceiverParameterDescriptor getReceiverParameterForDeclaration(DeclarationDescriptor declarationDescriptor) {
        if (declarationDescriptor instanceof ClassDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((ClassDescriptor)declarationDescriptor).getThisAsReceiverParameter();
            if (receiverParameterDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(11);
            }
            return receiverParameterDescriptor;
        }
        if (declarationDescriptor instanceof CallableMemberDescriptor) {
            ReceiverParameterDescriptor receiverDescriptor = ((CallableMemberDescriptor)declarationDescriptor).getExtensionReceiverParameter();
            assert (receiverDescriptor != null);
            ReceiverParameterDescriptor receiverParameterDescriptor = receiverDescriptor;
            if (receiverParameterDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(12);
            }
            return receiverParameterDescriptor;
        }
        throw new UnsupportedOperationException("Unsupported declaration type: " + declarationDescriptor.getClass() + ", declarationDescriptor = " + declarationDescriptor);
    }

    private static boolean isDefaultAccessor(@Nullable PropertyAccessorDescriptor accessorDescriptor) {
        return accessorDescriptor == null || accessorDescriptor.isDefault() && (!(accessorDescriptor instanceof PropertySetterDescriptor) || !accessorDescriptor.getCorrespondingProperty().isLateInit());
    }

    public static boolean sideEffectsPossibleOnRead(@NotNull PropertyDescriptor property) {
        if (property == null) {
            JsDescriptorUtils.$$$reportNull$$$0(13);
        }
        return DynamicCallsKt.isDynamic(property) || !JsDescriptorUtils.isDefaultAccessor(property.getGetter()) || ModalityUtilsKt.isOverridableOrOverrides(property) || JsDescriptorUtils.isStaticInitializationPossible(property);
    }

    private static boolean isStaticInitializationPossible(PropertyDescriptor property) {
        DeclarationDescriptor container = property.getContainingDeclaration();
        return container instanceof PackageFragmentDescriptor || DescriptorUtils.isObject(container);
    }

    public static boolean isSimpleFinalProperty(@NotNull PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(14);
        }
        return !DescriptorUtils.isExtension(propertyDescriptor) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getGetter()) && JsDescriptorUtils.isDefaultAccessor(propertyDescriptor.getSetter()) && !TranslationUtils.shouldAccessViaFunctions((CallableDescriptor)propertyDescriptor) && !ModalityUtilsKt.isOverridableOrOverrides(propertyDescriptor);
    }

    @NotNull
    public static String getModuleName(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(15);
        }
        return JsDescriptorUtils.getModuleName(DescriptorUtils.getContainingModule(JsDescriptorUtils.findRealInlineDeclaration(descriptor2)));
    }

    @NotNull
    public static String getModuleName(@NotNull ModuleDescriptor module2) {
        if (module2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(16);
        }
        if (module2.getName().equals(KotlinBuiltIns.BUILTINS_MODULE_NAME)) {
            String string2 = Namer.KOTLIN_LOWER_NAME;
            if (string2 == null) {
                JsDescriptorUtils.$$$reportNull$$$0(17);
            }
            return string2;
        }
        String moduleName = module2.getName().asString();
        String string3 = moduleName.substring(1, moduleName.length() - 1);
        if (string3 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(18);
        }
        return string3;
    }

    @NotNull
    public static DeclarationDescriptor findRealInlineDeclaration(@NotNull DeclarationDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(19);
        }
        if (descriptor2 instanceof FunctionDescriptor) {
            FunctionDescriptor d = (FunctionDescriptor)descriptor2;
            if (d.getKind().isReal() || !d.isInline()) {
                DeclarationDescriptor declarationDescriptor = descriptor2;
                if (declarationDescriptor == null) {
                    JsDescriptorUtils.$$$reportNull$$$0(20);
                }
                return declarationDescriptor;
            }
            CallableMemberDescriptor real = JsDescriptorUtils.findRealDeclaration(d);
            assert (real != null) : "Couldn't find definition of a fake inline descriptor " + descriptor2;
            CallableMemberDescriptor callableMemberDescriptor = real;
            if (callableMemberDescriptor == null) {
                JsDescriptorUtils.$$$reportNull$$$0(21);
            }
            return callableMemberDescriptor;
        }
        DeclarationDescriptor declarationDescriptor = descriptor2;
        if (declarationDescriptor == null) {
            JsDescriptorUtils.$$$reportNull$$$0(22);
        }
        return declarationDescriptor;
    }

    @Nullable
    public static CallableMemberDescriptor findRealDeclaration(@NotNull CallableMemberDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(23);
        }
        if (descriptor2.getModality() == Modality.ABSTRACT) {
            return null;
        }
        if (descriptor2.getKind().isReal()) {
            return descriptor2;
        }
        for (CallableMemberDescriptor callableMemberDescriptor : descriptor2.getOverriddenDescriptors()) {
            CallableMemberDescriptor child = JsDescriptorUtils.findRealDeclaration(callableMemberDescriptor);
            if (child == null) continue;
            return child;
        }
        return null;
    }

    public static boolean isImmediateSubtypeOfError(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(24);
        }
        if (!JsDescriptorUtils.isExceptionClass(descriptor2)) {
            return false;
        }
        ClassDescriptor superClass = DescriptorUtilsKt.getSuperClassOrAny(descriptor2);
        return TypeUtilsKt.isNotNullThrowable(superClass.getDefaultType()) || AnnotationsUtils.isNativeObject(superClass);
    }

    public static boolean isExceptionClass(@NotNull ClassDescriptor descriptor2) {
        if (descriptor2 == null) {
            JsDescriptorUtils.$$$reportNull$$$0(25);
        }
        ModuleDescriptor module2 = DescriptorUtils.getContainingModule(descriptor2);
        return TypeUtilsKt.isSubtypeOf(descriptor2.getDefaultType(), module2.getBuiltIns().getThrowable().getDefaultType());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionDescriptor";
                break;
            }
            case 2: 
            case 6: 
            case 15: 
            case 19: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superclassDescriptors";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classDescriptor";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "receiverParameter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyDescriptor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/js/translate/utils/JsDescriptorUtils";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupertypesWithoutFakes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingDeclaration";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationDescriptorForReceiver";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getReceiverParameterForDeclaration";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleName";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findRealInlineDeclaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "valueParametersCount";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasParameters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isCompareTo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorClass";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSuperclass";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getContainingDeclaration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getReceiverParameterForReceiver";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationDescriptorForReceiver";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "sideEffectsPossibleOnRead";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isSimpleFinalProperty";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findRealInlineDeclaration";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findRealDeclaration";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isImmediateSubtypeOfError";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionClass";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

