/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.PossiblyDumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public abstract class DumbService {
    public static final Topic<DumbModeListener> DUMB_MODE = new Topic<DumbModeListener>("dumb mode", DumbModeListener.class, Topic.BroadcastDirection.NONE);

    public abstract boolean isDumb();

    public static boolean isDumb(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(0);
        }
        return DumbService.getInstance(project).isDumb();
    }

    public abstract void waitForSmartMode();

    public void runReadActionInSmartMode(@NotNull Runnable r) {
        boolean success;
        if (r == null) {
            DumbService.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            r.run();
            return;
        }
        do {
            this.waitForSmartMode();
        } while (!(success = ReadAction.compute(() -> {
            if (this.getProject().isDisposed()) {
                throw new ProcessCanceledException();
            }
            if (this.isDumb()) {
                return false;
            }
            r.run();
            return true;
        }).booleanValue()));
    }

    public static DumbService getInstance(@NotNull Project project) {
        if (project == null) {
            DumbService.$$$reportNull$$$0(13);
        }
        return project.getService(DumbService.class);
    }

    @NotNull
    public <T> List<T> filterByDumbAwareness(T @NotNull [] array2) {
        if (array2 == null) {
            DumbService.$$$reportNull$$$0(14);
        }
        List<T> list2 = this.filterByDumbAwareness(Arrays.asList(array2));
        if (list2 == null) {
            DumbService.$$$reportNull$$$0(15);
        }
        return list2;
    }

    @Contract(pure=true)
    @NotNull
    public <T> List<T> filterByDumbAwareness(@NotNull Collection<? extends T> collection) {
        if (collection == null) {
            DumbService.$$$reportNull$$$0(16);
        }
        if (this.isDumb()) {
            ArrayList<T> result2 = new ArrayList<T>(collection.size());
            for (T element : collection) {
                if (!DumbService.isDumbAware(element)) continue;
                result2.add(element);
            }
            ArrayList<T> arrayList = result2;
            if (arrayList == null) {
                DumbService.$$$reportNull$$$0(17);
            }
            return arrayList;
        }
        return collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
    }

    public abstract void completeJustSubmittedTasks();

    public abstract Project getProject();

    @Contract(value="null -> false", pure=true)
    public static boolean isDumbAware(Object o) {
        if (o instanceof PossiblyDumbAware) {
            return ((PossiblyDumbAware)o).isDumbAware();
        }
        return o instanceof DumbAware;
    }

    public abstract boolean isAlternativeResolveEnabled();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionPoint";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "r";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentToDisable";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "permission";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/project/DumbService";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDumbAwareExtensions";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "filterByDumbAwareness";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isDumb";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDumbAwareExtensions";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "runReadActionInSmartMode";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "tryRunReadActionInSmartMode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "repeatUntilPassesInSmartMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterByDumbAwareness";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "makeDumbAware";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withAlternativeResolveEnabled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "computeWithAlternativeResolveEnabled";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runWithAlternativeResolveEnabled";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "allowStartingDumbModeInside";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 15: 
            case 17: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface DumbModeListener {
    }
}

