/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableRangeMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.googlejavaformat.Input;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaOutput;
import com.google.googlejavaformat.java.JavacTokens;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public final class JavaInput
extends Input {
    private final String text;
    private int kN;
    private final ImmutableMap<Integer, Integer> positionToColumnMap;
    private final ImmutableList<Token> tokens;
    private final ImmutableRangeMap<Integer, Token> positionTokenMap;
    private final Token[] kToToken;
    private JCTree.JCCompilationUnit unit;

    public JavaInput(String text) throws FormatterException {
        this.text = (String)Preconditions.checkNotNull((Object)text);
        this.setLines((ImmutableList<String>)ImmutableList.copyOf(Newlines.lineIterator(text)));
        ImmutableList<Tok> toks = this.buildToks(text);
        this.positionToColumnMap = JavaInput.makePositionToColumnMap(toks);
        this.tokens = JavaInput.buildTokens(toks);
        ImmutableRangeMap.Builder tokenLocations = ImmutableRangeMap.builder();
        for (Token token : this.tokens) {
            Input.Tok end = JavaOutput.endTok(token);
            int upper = end.getPosition();
            if (!end.getText().isEmpty()) {
                upper += end.length() - 1;
            }
            tokenLocations.put(Range.closed((Comparable)Integer.valueOf(JavaOutput.startTok(token).getPosition()), (Comparable)Integer.valueOf(upper)), (Object)token);
        }
        this.positionTokenMap = tokenLocations.build();
        this.kToToken = new Token[this.kN + 1];
        for (Token token : this.tokens) {
            for (Input.Tok tok : token.getToksBefore()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
            this.kToToken[token.getTok().getIndex()] = token;
            for (Input.Tok tok : token.getToksAfter()) {
                if (tok.getIndex() < 0) continue;
                this.kToToken[tok.getIndex()] = token;
            }
        }
    }

    private static ImmutableMap<Integer, Integer> makePositionToColumnMap(List<Tok> toks) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Tok tok : toks) {
            builder.put((Object)tok.getPosition(), (Object)tok.getColumn());
        }
        return builder.build();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public ImmutableMap<Integer, Integer> getPositionToColumnMap() {
        return this.positionToColumnMap;
    }

    private ImmutableList<Tok> buildToks(String text) throws FormatterException {
        ImmutableList<Tok> toks = JavaInput.buildToks(text, (ImmutableSet<Tokens.TokenKind>)ImmutableSet.of());
        this.kN = ((Tok)Iterables.getLast(toks)).getIndex();
        this.computeRanges((List<? extends Input.Tok>)toks);
        return toks;
    }

    static ImmutableList<Tok> buildToks(final String text, ImmutableSet<Tokens.TokenKind> stopTokens) throws FormatterException {
        JavacTokens.RawTok t;
        stopTokens = ImmutableSet.builder().addAll(stopTokens).add((Object)Tokens.TokenKind.EOF).build();
        Context context = new Context();
        Options.instance(context).put("--enable-preview", "true");
        new JavacFileManager(context, true, StandardCharsets.UTF_8);
        DiagnosticCollector diagnosticCollector = new DiagnosticCollector();
        context.put(DiagnosticListener.class, diagnosticCollector);
        Log log = Log.instance(context);
        log.useSource(new SimpleJavaFileObject(URI.create("Source.java"), JavaFileObject.Kind.SOURCE){

            @Override
            public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                return text;
            }
        });
        Log.DeferredDiagnosticHandler diagnostics = new Log.DeferredDiagnosticHandler(log);
        ImmutableList<JavacTokens.RawTok> rawToks = JavacTokens.getTokens(text, context, (Set<Tokens.TokenKind>)stopTokens);
        if (diagnostics.getDiagnostics().stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.ERROR)) {
            return ImmutableList.of((Object)new Tok(0, "", "", 0, 0, true, null));
        }
        int kN = 0;
        ArrayList<Tok> toks = new ArrayList<Tok>();
        int charI = 0;
        int columnI = 0;
        UnmodifiableIterator unmodifiableIterator = rawToks.iterator();
        while (unmodifiableIterator.hasNext() && !stopTokens.contains((Object)(t = (JavacTokens.RawTok)unmodifiableIterator.next()).kind())) {
            boolean isNumbered;
            boolean isToken;
            int charI0 = t.pos();
            String originalTokText = text.substring(charI0, t.endPos());
            String tokText = t.kind() == Tokens.TokenKind.STRINGLITERAL ? t.stringVal() : originalTokText;
            char tokText0 = tokText.charAt(0);
            String extraNewline = null;
            ArrayList<String> strings = new ArrayList<String>();
            if (Character.isWhitespace(tokText0)) {
                isToken = false;
                isNumbered = false;
                Iterator<String> it = Newlines.lineIterator(originalTokText);
                while (it.hasNext()) {
                    String line = it.next();
                    String newline = Newlines.getLineEnding(line);
                    if (newline != null) {
                        String spaces = line.substring(0, line.length() - newline.length());
                        if (!spaces.isEmpty()) {
                            strings.add(spaces);
                        }
                        strings.add(newline);
                        continue;
                    }
                    if (line.isEmpty()) continue;
                    strings.add(line);
                }
            } else if (tokText.startsWith("'") || tokText.startsWith("\"")) {
                isToken = true;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (tokText.startsWith("//") || tokText.startsWith("/*")) {
                if (tokText.startsWith("//") && (originalTokText.endsWith("\n") || originalTokText.endsWith("\r"))) {
                    extraNewline = Newlines.getLineEnding(originalTokText);
                    tokText = tokText.substring(0, tokText.length() - extraNewline.length());
                    originalTokText = originalTokText.substring(0, originalTokText.length() - extraNewline.length());
                }
                isToken = false;
                isNumbered = true;
                strings.add(originalTokText);
            } else if (Character.isJavaIdentifierStart(tokText0) || Character.isDigit(tokText0) || tokText0 == '.' && tokText.length() > 1 && Character.isDigit(tokText.charAt(1))) {
                isToken = true;
                isNumbered = true;
                strings.add(tokText);
            } else {
                isToken = true;
                isNumbered = true;
                for (Object c : (Object)tokText.toCharArray()) {
                    strings.add(String.valueOf((char)c));
                }
            }
            if (strings.size() == 1) {
                toks.add(new Tok(isNumbered ? kN++ : -1, originalTokText, tokText, charI, columnI, isToken, t.kind()));
                charI += originalTokText.length();
                columnI = JavaInput.updateColumn(columnI, originalTokText);
            } else {
                if (strings.size() != 1 && !tokText.equals(originalTokText)) {
                    throw new FormatterException("Unicode escapes not allowed in whitespace or multi-character operators");
                }
                for (String str : strings) {
                    toks.add(new Tok(isNumbered ? kN++ : -1, str, str, charI, columnI, isToken, null));
                    charI += str.length();
                    columnI = JavaInput.updateColumn(columnI, originalTokText);
                }
            }
            if (extraNewline == null) continue;
            toks.add(new Tok(-1, extraNewline, extraNewline, charI, columnI, false, null));
            columnI = 0;
            charI += extraNewline.length();
        }
        toks.add(new Tok(kN, "", "", charI, columnI, true, null));
        return ImmutableList.copyOf(toks);
    }

    private static int updateColumn(int columnI, String originalTokText) {
        Integer last = (Integer)Iterators.getLast(Newlines.lineOffsetIterator(originalTokText));
        columnI = last > 0 ? originalTokText.length() - last : (columnI += originalTokText.length());
        return columnI;
    }

    /*
     * Unable to fully structure code
     */
    private static ImmutableList<Token> buildTokens(List<Tok> toks) {
        tokens = ImmutableList.builder();
        k = 0;
        kN = toks.size();
        toksBefore = ImmutableList.builder();
        block14: while (k < kN) {
            while (!toks.get(k).isToken()) {
                tok = toks.get(k++);
                toksBefore.add((Object)tok);
                if (!JavaInput.isParamComment(tok)) continue;
                while (toks.get(k).isNewline()) {
                    ++k;
                }
            }
            tok = toks.get(k++);
            toksAfter = ImmutableList.builder();
            block17: while (k < kN && !toks.get(k).isToken()) {
                if (!toks.get(k).isSlashStarComment()) ** GOTO lbl-1000
                var7_7 = tok.getText();
                var8_8 = -1;
                switch (var7_7.hashCode()) {
                    case 40: {
                        if (!var7_7.equals("(")) break;
                        var8_8 = 0;
                        break;
                    }
                    case 60: {
                        if (!var7_7.equals("<")) break;
                        var8_8 = 1;
                        break;
                    }
                    case 46: {
                        if (!var7_7.equals(".")) break;
                        var8_8 = 2;
                    }
                }
                switch (var8_8) {
                    case 0: 
                    case 1: 
                    case 2: {
                        break block17;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        if (toks.get(k).isJavadocComment()) {
                            var7_7 = tok.getText();
                            var8_8 = -1;
                            switch (var7_7.hashCode()) {
                                case 59: {
                                    if (!var7_7.equals(";")) break;
                                    var8_8 = 0;
                                }
                            }
                            switch (var8_8) {
                                case 0: {
                                    break block17;
                                }
                            }
                        }
                        if (JavaInput.isParamComment(toks.get(k))) {
                            tokens.add((Object)new Token((List<Tok>)toksBefore.build(), tok, (List<Tok>)toksAfter.build()));
                            toksBefore = ImmutableList.builder().add((Object)toks.get(k++));
                            while (toks.get(k).isNewline()) {
                                ++k;
                            }
                            continue block14;
                        }
                        nonTokenAfter = toks.get(k++);
                        toksAfter.add((Object)nonTokenAfter);
                        if (!Newlines.containsBreaks(nonTokenAfter.getText())) continue block17;
                        break block17;
                    }
                }
            }
            tokens.add((Object)new Token((List<Tok>)toksBefore.build(), tok, (List<Tok>)toksAfter.build()));
            toksBefore = ImmutableList.builder();
        }
        return tokens.build();
    }

    private static boolean isParamComment(Tok tok) {
        return tok.isSlashStarComment() && tok.getText().matches("\\/\\*[A-Za-z0-9\\s_\\-]+=\\s*\\*\\/");
    }

    Range<Integer> characterRangeToTokenRange(int offset, int length) throws FormatterException {
        ImmutableCollection enclosed;
        int requiredLength = offset + length;
        if (requiredLength > this.text.length()) {
            throw new FormatterException(String.format("error: invalid length %d, offset + length (%d) is outside the file", length, requiredLength));
        }
        if (length < 0) {
            return EMPTY_RANGE;
        }
        if (length == 0) {
            length = 1;
        }
        if ((enclosed = this.getPositionTokenMap().subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(offset), (Comparable)Integer.valueOf(offset + length))).asMapOfRanges().values()).isEmpty()) {
            return EMPTY_RANGE;
        }
        return Range.closedOpen((Comparable)Integer.valueOf(((Token)enclosed.iterator().next()).getTok().getIndex()), (Comparable)Integer.valueOf(((Token)Iterables.getLast((Iterable)enclosed)).getTok().getIndex() + 1));
    }

    @Override
    public int getkN() {
        return this.kN;
    }

    @Override
    public Token getToken(int k) {
        return this.kToToken[k];
    }

    @Override
    public ImmutableList<? extends Input.Token> getTokens() {
        return this.tokens;
    }

    public ImmutableRangeMap<Integer, Token> getPositionTokenMap() {
        return this.positionTokenMap;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tokens", this.tokens).add("super", (Object)super.toString()).toString();
    }

    @Override
    public int getLineNumber(int inputPosition) {
        Verify.verifyNotNull((Object)this.unit, (String)"Expected compilation unit to be set.", (Object[])new Object[0]);
        return this.unit.getLineMap().getLineNumber(inputPosition);
    }

    @Override
    public int getColumnNumber(int inputPosition) {
        Verify.verifyNotNull((Object)this.unit, (String)"Expected compilation unit to be set.", (Object[])new Object[0]);
        return this.unit.getLineMap().getColumnNumber(inputPosition);
    }

    public void setCompilationUnit(JCTree.JCCompilationUnit unit) {
        this.unit = unit;
    }

    public RangeSet<Integer> characterRangesToTokenRanges(Collection<Range<Integer>> characterRanges) throws FormatterException {
        TreeRangeSet tokenRangeSet = TreeRangeSet.create();
        for (Range<Integer> characterRange0 : characterRanges) {
            Range characterRange = characterRange0.canonical(DiscreteDomain.integers());
            tokenRangeSet.add(this.characterRangeToTokenRange((Integer)characterRange.lowerEndpoint(), (Integer)characterRange.upperEndpoint() - (Integer)characterRange.lowerEndpoint()));
        }
        return tokenRangeSet;
    }

    static final class Token
    implements Input.Token {
        private final Tok tok;
        private final ImmutableList<Tok> toksBefore;
        private final ImmutableList<Tok> toksAfter;

        Token(List<Tok> toksBefore, Tok tok, List<Tok> toksAfter) {
            this.toksBefore = ImmutableList.copyOf(toksBefore);
            this.tok = tok;
            this.toksAfter = ImmutableList.copyOf(toksAfter);
        }

        @Override
        public Tok getTok() {
            return this.tok;
        }

        @Override
        public ImmutableList<? extends Input.Tok> getToksBefore() {
            return this.toksBefore;
        }

        @Override
        public ImmutableList<? extends Input.Tok> getToksAfter() {
            return this.toksAfter;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("tok", (Object)this.tok).add("toksBefore", this.toksBefore).add("toksAfter", this.toksAfter).toString();
        }
    }

    static final class Tok
    implements Input.Tok {
        private final int index;
        private final String originalText;
        private final String text;
        private final int position;
        private final int columnI;
        private final boolean isToken;
        private final Tokens.TokenKind kind;

        Tok(int index, String originalText, String text, int position, int columnI, boolean isToken, Tokens.TokenKind kind) {
            this.index = index;
            this.originalText = originalText;
            this.text = text;
            this.position = position;
            this.columnI = columnI;
            this.isToken = isToken;
            this.kind = kind;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        public String getOriginalText() {
            return this.originalText;
        }

        @Override
        public int length() {
            return this.originalText.length();
        }

        @Override
        public int getPosition() {
            return this.position;
        }

        @Override
        public int getColumn() {
            return this.columnI;
        }

        boolean isToken() {
            return this.isToken;
        }

        @Override
        public boolean isNewline() {
            return Newlines.isNewline(this.text);
        }

        @Override
        public boolean isSlashSlashComment() {
            return this.text.startsWith("//");
        }

        @Override
        public boolean isSlashStarComment() {
            return this.text.startsWith("/*");
        }

        @Override
        public boolean isJavadocComment() {
            return this.text.startsWith("/**") && this.text.charAt("/**".length()) != '*' && this.text.length() > 4;
        }

        @Override
        public boolean isComment() {
            return this.isSlashSlashComment() || this.isSlashStarComment();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("text", (Object)this.text).add("position", this.position).add("columnI", this.columnI).add("isToken", this.isToken).toString();
        }

        public Tokens.TokenKind kind() {
            return this.kind;
        }
    }
}

