/*
 * Decompiled with CFR 0.152.
 */
package org.javacs.kt;

import java.io.Closeable;
import java.net.URI;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionContext;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SemanticTokens;
import org.eclipse.lsp4j.SemanticTokensParams;
import org.eclipse.lsp4j.SemanticTokensRangeParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextDocumentPositionParams;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.javacs.kt.CompiledFile;
import org.javacs.kt.CompilerClassPath;
import org.javacs.kt.Configuration;
import org.javacs.kt.Logger;
import org.javacs.kt.LoggerKt;
import org.javacs.kt.SourceFiles;
import org.javacs.kt.SourcePath;
import org.javacs.kt.URIContentProvider;
import org.javacs.kt.codeaction.CodeActionKt;
import org.javacs.kt.completion.CompletionsKt;
import org.javacs.kt.definition.GoToDefinitionKt;
import org.javacs.kt.diagnostic.ConvertDiagnosticKt;
import org.javacs.kt.formatting.FormattingService;
import org.javacs.kt.highlight.DocumentHighlightKt;
import org.javacs.kt.hover.HoversKt;
import org.javacs.kt.index.SymbolIndex;
import org.javacs.kt.inlayhints.InlayHintKt;
import org.javacs.kt.position.PositionKt;
import org.javacs.kt.references.FindReferencesKt;
import org.javacs.kt.rename.RenameKt;
import org.javacs.kt.semantictokens.SemanticTokensKt;
import org.javacs.kt.signaturehelp.SignatureHelpKt;
import org.javacs.kt.symbols.SymbolsKt;
import org.javacs.kt.util.AsyncExecutor;
import org.javacs.kt.util.Debouncer;
import org.javacs.kt.util.TemporaryDirectory;
import org.javacs.kt.util.URIsKt;
import org.javacs.kt.util.UtilsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u0002:\u0002\u009f\u0001B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010>\u001a\u00020*2\u0006\u0010\u0011\u001a\u00020\u0012J&\u0010?\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020#\u0018\u00010@2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020EH\u0002J.\u0010?\u001a\u0010\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020#\u0018\u00010@2\u0006\u0010F\u001a\u00020;2\u0006\u0010B\u001a\u00020G2\u0006\u0010D\u001a\u00020EH\u0002J(\u0010H\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020L\u0012\u0004\u0012\u00020M0K0J0I2\u0006\u0010N\u001a\u00020OH\u0016J\u001c\u0010P\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Q0J0I2\u0006\u0010N\u001a\u00020RH\u0016J\u0018\u0010S\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010T0I2\u0006\u0010B\u001a\u00020UH\u0016J\u001c\u0010V\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0J0I2\u0006\u0010B\u001a\u00020XH\u0016J\u001c\u0010Y\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0J0I2\u0006\u0010N\u001a\u00020[H\u0016J.\u0010\\\u001a \u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020]0J\u0012\n\u0012\b\u0012\u0004\u0012\u00020^0J0K0I2\u0006\u0010B\u001a\u00020_H\u0016J\u001c\u0010`\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0J0I2\u0006\u0010N\u001a\u00020aH\u0016J\u001c\u0010b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020c0J0I2\u0006\u0010N\u001a\u00020dH\u0016J-\u0010e\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010f g*\f\u0012\u0006\u0012\u0004\u0018\u00010f\u0018\u00010I0I2\u0006\u0010N\u001a\u00020hH\u0016\u00a2\u0006\u0002\u0010iJ(\u0010j\u001a\u001a\u0012\u0016\u0012\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020k0J\u0012\u0004\u0012\u00020l0K0I2\u0006\u0010B\u001a\u00020mH\u0016J\u0016\u0010n\u001a\b\u0012\u0004\u0012\u00020k0I2\u0006\u0010o\u001a\u00020kH\u0016J(\u0010p\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020q\u0012\u0004\u0012\u00020r0K0J0I2\u0006\u0010N\u001a\u00020sH\u0016J\u0010\u0010t\u001a\u00020*2\u0006\u0010N\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020*2\u0006\u0010N\u001a\u00020wH\u0016J\u0018\u0010x\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010y0I2\u0006\u0010B\u001a\u00020zH\u0016J\u0010\u0010{\u001a\u00020*2\u0006\u0010N\u001a\u00020|H\u0016J\u001c\u0010}\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020Z0J0I2\u0006\u0010N\u001a\u00020~H\u0016J\u0011\u0010\u007f\u001a\u00020*2\u0007\u0010N\u001a\u00030\u0080\u0001H\u0016J<\u0010\u0081\u0001\u001a&\u0012\f\u0012\n\u0012\u0004\u0012\u00020]\u0018\u00010J g*\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020]\u0018\u00010J\u0018\u00010I0I2\u0007\u0010B\u001a\u00030\u0082\u0001H\u0016\u00a2\u0006\u0003\u0010\u0083\u0001J@\u0010\u0084\u0001\u001a*\u0012\u000e\u0012\f g*\u0005\u0018\u00010\u0085\u00010\u0085\u0001 g*\u0014\u0012\u000e\u0012\f g*\u0005\u0018\u00010\u0085\u00010\u0085\u0001\u0018\u00010I0I2\u0007\u0010N\u001a\u00030\u0086\u0001H\u0016\u00a2\u0006\u0003\u0010\u0087\u0001J@\u0010\u0088\u0001\u001a*\u0012\u000e\u0012\f g*\u0005\u0018\u00010\u0085\u00010\u0085\u0001 g*\u0014\u0012\u000e\u0012\f g*\u0005\u0018\u00010\u0085\u00010\u0085\u0001\u0018\u00010I0I2\u0007\u0010N\u001a\u00030\u0089\u0001H\u0016\u00a2\u0006\u0003\u0010\u008a\u0001J\u0017\u0010\u008b\u0001\u001a\b\u0012\u0004\u0012\u00020c0I2\u0006\u0010o\u001a\u00020cH\u0016J\u0011\u0010\u008c\u0001\u001a\u00020;2\u0006\u0010B\u001a\u00020CH\u0002J\u0007\u0010\u008d\u0001\u001a\u00020*J\u0007\u0010\u008e\u0001\u001a\u00020*J\u000f\u0010\u008f\u0001\u001a\b\u0012\u0004\u0012\u00020\u001f0JH\u0002J\u0012\u0010\u0090\u0001\u001a\u00020*2\u0007\u0010\u0091\u0001\u001a\u00020\u001fH\u0002J\u0012\u0010\u0092\u0001\u001a\u00020*2\u0007\u0010\u0093\u0001\u001a\u00020\u001fH\u0002J\u0018\u0010\u0094\u0001\u001a\u00020*2\r\u0010\u0095\u0001\u001a\b\u0012\u0004\u0012\u0002080)H\u0002J#\u0010\u0096\u0001\u001a\u00020*2\u000e\u0010\u0097\u0001\u001a\t\u0012\u0004\u0012\u00020\u001f0\u0098\u00012\b\u0010\u0099\u0001\u001a\u00030\u009a\u0001H\u0002J\u0012\u0010\u009b\u0001\u001a\u00020*2\u0007\u0010\u0091\u0001\u001a\u00020\u001fH\u0002J\u0012\u0010\u009c\u0001\u001a\u00020*2\u0007\u0010\u009d\u0001\u001a\u000208H\u0002J\t\u0010\u009e\u0001\u001a\u00020*H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R0\u0010+\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u0004\u0018\u000101*\u0002028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u001a\u00100\u001a\u0004\u0018\u000101*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00106R\u0018\u00107\u001a\u000208*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b7\u00109R\u0018\u0010:\u001a\u00020;*\u0002058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u0010=\u00a8\u0006\u00a0\u0001"}, d2={"Lorg/javacs/kt/KotlinTextDocumentService;", "Lorg/eclipse/lsp4j/services/TextDocumentService;", "Ljava/io/Closeable;", "sf", "Lorg/javacs/kt/SourceFiles;", "sp", "Lorg/javacs/kt/SourcePath;", "config", "Lorg/javacs/kt/Configuration;", "tempDirectory", "Lorg/javacs/kt/util/TemporaryDirectory;", "uriContentProvider", "Lorg/javacs/kt/URIContentProvider;", "cp", "Lorg/javacs/kt/CompilerClassPath;", "<init>", "(Lorg/javacs/kt/SourceFiles;Lorg/javacs/kt/SourcePath;Lorg/javacs/kt/Configuration;Lorg/javacs/kt/util/TemporaryDirectory;Lorg/javacs/kt/URIContentProvider;Lorg/javacs/kt/CompilerClassPath;)V", "client", "Lorg/eclipse/lsp4j/services/LanguageClient;", "async", "Lorg/javacs/kt/util/AsyncExecutor;", "formattingService", "Lorg/javacs/kt/formatting/FormattingService;", "debounceLint", "Lorg/javacs/kt/util/Debouncer;", "getDebounceLint", "()Lorg/javacs/kt/util/Debouncer;", "setDebounceLint", "(Lorg/javacs/kt/util/Debouncer;)V", "lintTodo", "", "Ljava/net/URI;", "getLintTodo", "()Ljava/util/Set;", "lintCount", "", "getLintCount", "()I", "setLintCount", "(I)V", "callback", "Lkotlin/Function0;", "", "lintRecompilationCallback", "getLintRecompilationCallback", "()Lkotlin/jvm/functions/Function0;", "setLintRecompilationCallback", "(Lkotlin/jvm/functions/Function0;)V", "filePath", "Ljava/nio/file/Path;", "Lorg/eclipse/lsp4j/TextDocumentItem;", "getFilePath", "(Lorg/eclipse/lsp4j/TextDocumentItem;)Ljava/nio/file/Path;", "Lorg/eclipse/lsp4j/TextDocumentIdentifier;", "(Lorg/eclipse/lsp4j/TextDocumentIdentifier;)Ljava/nio/file/Path;", "isKotlinScript", "", "(Lorg/eclipse/lsp4j/TextDocumentIdentifier;)Z", "content", "", "getContent", "(Lorg/eclipse/lsp4j/TextDocumentIdentifier;)Ljava/lang/String;", "connect", "recover", "Lkotlin/Pair;", "Lorg/javacs/kt/CompiledFile;", "position", "Lorg/eclipse/lsp4j/TextDocumentPositionParams;", "recompile", "Lorg/javacs/kt/KotlinTextDocumentService$Recompile;", "uriString", "Lorg/eclipse/lsp4j/Position;", "codeAction", "Ljava/util/concurrent/CompletableFuture;", "", "Lorg/eclipse/lsp4j/jsonrpc/messages/Either;", "Lorg/eclipse/lsp4j/Command;", "Lorg/eclipse/lsp4j/CodeAction;", "params", "Lorg/eclipse/lsp4j/CodeActionParams;", "inlayHint", "Lorg/eclipse/lsp4j/InlayHint;", "Lorg/eclipse/lsp4j/InlayHintParams;", "hover", "Lorg/eclipse/lsp4j/Hover;", "Lorg/eclipse/lsp4j/HoverParams;", "documentHighlight", "Lorg/eclipse/lsp4j/DocumentHighlight;", "Lorg/eclipse/lsp4j/DocumentHighlightParams;", "onTypeFormatting", "Lorg/eclipse/lsp4j/TextEdit;", "Lorg/eclipse/lsp4j/DocumentOnTypeFormattingParams;", "definition", "Lorg/eclipse/lsp4j/Location;", "Lorg/eclipse/lsp4j/LocationLink;", "Lorg/eclipse/lsp4j/DefinitionParams;", "rangeFormatting", "Lorg/eclipse/lsp4j/DocumentRangeFormattingParams;", "codeLens", "Lorg/eclipse/lsp4j/CodeLens;", "Lorg/eclipse/lsp4j/CodeLensParams;", "rename", "Lorg/eclipse/lsp4j/WorkspaceEdit;", "kotlin.jvm.PlatformType", "Lorg/eclipse/lsp4j/RenameParams;", "(Lorg/eclipse/lsp4j/RenameParams;)Ljava/util/concurrent/CompletableFuture;", "completion", "Lorg/eclipse/lsp4j/CompletionItem;", "Lorg/eclipse/lsp4j/CompletionList;", "Lorg/eclipse/lsp4j/CompletionParams;", "resolveCompletionItem", "unresolved", "documentSymbol", "Lorg/eclipse/lsp4j/SymbolInformation;", "Lorg/eclipse/lsp4j/DocumentSymbol;", "Lorg/eclipse/lsp4j/DocumentSymbolParams;", "didOpen", "Lorg/eclipse/lsp4j/DidOpenTextDocumentParams;", "didSave", "Lorg/eclipse/lsp4j/DidSaveTextDocumentParams;", "signatureHelp", "Lorg/eclipse/lsp4j/SignatureHelp;", "Lorg/eclipse/lsp4j/SignatureHelpParams;", "didClose", "Lorg/eclipse/lsp4j/DidCloseTextDocumentParams;", "formatting", "Lorg/eclipse/lsp4j/DocumentFormattingParams;", "didChange", "Lorg/eclipse/lsp4j/DidChangeTextDocumentParams;", "references", "Lorg/eclipse/lsp4j/ReferenceParams;", "(Lorg/eclipse/lsp4j/ReferenceParams;)Ljava/util/concurrent/CompletableFuture;", "semanticTokensFull", "Lorg/eclipse/lsp4j/SemanticTokens;", "Lorg/eclipse/lsp4j/SemanticTokensParams;", "(Lorg/eclipse/lsp4j/SemanticTokensParams;)Ljava/util/concurrent/CompletableFuture;", "semanticTokensRange", "Lorg/eclipse/lsp4j/SemanticTokensRangeParams;", "(Lorg/eclipse/lsp4j/SemanticTokensRangeParams;)Ljava/util/concurrent/CompletableFuture;", "resolveCodeLens", "describePosition", "updateDebouncer", "lintAll", "clearLint", "lintLater", "uri", "lintNow", "file", "doLint", "cancelCallback", "reportDiagnostics", "compiled", "", "kotlinDiagnostics", "Lorg/jetbrains/kotlin/resolve/diagnostics/Diagnostics;", "clearDiagnostics", "shutdownExecutors", "awaitTermination", "close", "Recompile", "server"})
@SourceDebugExtension(value={"SMAP\nKotlinTextDocumentService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinTextDocumentService.kt\norg/javacs/kt/KotlinTextDocumentService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 KotlinTextDocumentService.kt\norg/javacs/kt/KotlinTextDocumentServiceKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,360:1\n1368#2:361\n1454#2,5:362\n774#2:367\n865#2,2:368\n1498#2:370\n1528#2,3:371\n1531#2,3:381\n381#3,7:374\n352#4,6:384\n352#4,6:390\n352#4,6:397\n352#4,6:403\n352#4,6:409\n352#4,6:415\n352#4,6:421\n1#5:396\n*S KotlinDebug\n*F\n+ 1 KotlinTextDocumentService.kt\norg/javacs/kt/KotlinTextDocumentService\n*L\n314#1:361\n314#1:362,5\n315#1:367\n315#1:368,2\n316#1:370\n316#1:371,3\n316#1:381,3\n316#1:374,7\n110#1:384,6\n128#1:390,6\n157#1:397,6\n176#1:403,6\n200#1:409,6\n241#1:415,6\n255#1:421,6\n*E\n"})
public final class KotlinTextDocumentService
implements TextDocumentService,
Closeable {
    @NotNull
    private final SourceFiles sf;
    @NotNull
    private final SourcePath sp;
    @NotNull
    private final Configuration config;
    @NotNull
    private final TemporaryDirectory tempDirectory;
    @NotNull
    private final URIContentProvider uriContentProvider;
    @NotNull
    private final CompilerClassPath cp;
    private LanguageClient client;
    @NotNull
    private final AsyncExecutor async;
    @NotNull
    private final FormattingService formattingService;
    @NotNull
    private Debouncer debounceLint;
    @NotNull
    private final Set<URI> lintTodo;
    private int lintCount;

    public KotlinTextDocumentService(@NotNull SourceFiles sf, @NotNull SourcePath sp, @NotNull Configuration config, @NotNull TemporaryDirectory tempDirectory, @NotNull URIContentProvider uriContentProvider, @NotNull CompilerClassPath cp) {
        Intrinsics.checkNotNullParameter((Object)sf, (String)"sf");
        Intrinsics.checkNotNullParameter((Object)sp, (String)"sp");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)tempDirectory, (String)"tempDirectory");
        Intrinsics.checkNotNullParameter((Object)uriContentProvider, (String)"uriContentProvider");
        Intrinsics.checkNotNullParameter((Object)cp, (String)"cp");
        this.sf = sf;
        this.sp = sp;
        this.config = config;
        this.tempDirectory = tempDirectory;
        this.uriContentProvider = uriContentProvider;
        this.cp = cp;
        this.async = new AsyncExecutor();
        this.formattingService = new FormattingService(this.config.getFormatting());
        Duration duration = Duration.ofMillis(this.config.getDiagnostics().getDebounceTime());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        this.debounceLint = new Debouncer(duration, null, 2, null);
        this.lintTodo = new LinkedHashSet();
    }

    @NotNull
    public final Debouncer getDebounceLint() {
        return this.debounceLint;
    }

    public final void setDebounceLint(@NotNull Debouncer debouncer) {
        Intrinsics.checkNotNullParameter((Object)debouncer, (String)"<set-?>");
        this.debounceLint = debouncer;
    }

    @NotNull
    public final Set<URI> getLintTodo() {
        return this.lintTodo;
    }

    public final int getLintCount() {
        return this.lintCount;
    }

    public final void setLintCount(int n) {
        this.lintCount = n;
    }

    @NotNull
    public final Function0<Unit> getLintRecompilationCallback() {
        return this.sp.getBeforeCompileCallback();
    }

    public final void setLintRecompilationCallback(@NotNull Function0<Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.sp.setBeforeCompileCallback(callback);
    }

    private final Path getFilePath(TextDocumentItem $this$filePath) {
        String string = $this$filePath.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return URIsKt.getFilePath((URI)URIsKt.parseURI((String)string));
    }

    private final Path getFilePath(TextDocumentIdentifier $this$filePath) {
        String string = $this$filePath.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return URIsKt.getFilePath((URI)URIsKt.parseURI((String)string));
    }

    private final boolean isKotlinScript(TextDocumentIdentifier $this$isKotlinScript) {
        String string = $this$isKotlinScript.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return StringsKt.endsWith$default((String)string, (String)".kts", (boolean)false, (int)2, null);
    }

    private final String getContent(TextDocumentIdentifier $this$content) {
        String string = $this$content.getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return this.sp.content(URIsKt.parseURI((String)string));
    }

    public final void connect(@NotNull LanguageClient client) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = client;
    }

    private final Pair<CompiledFile, Integer> recover(TextDocumentPositionParams position, Recompile recompile) {
        String string = position.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        Position position2 = position.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getPosition(...)");
        return this.recover(string, position2, recompile);
    }

    private final Pair<CompiledFile, Integer> recover(String uriString, Position position, Recompile recompile) {
        boolean bl;
        URI uri = URIsKt.parseURI((String)uriString);
        if (!this.sf.isIncluded(uri)) {
            LoggerKt.getLOG().warn("URI is excluded, therefore cannot be recovered: " + uri, new Object[0]);
            return null;
        }
        String content = this.sp.content(uri);
        int offset = PositionKt.offset(content, position.getLine(), position.getCharacter());
        switch (WhenMappings.$EnumSwitchMapping$0[recompile.ordinal()]) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                if (offset > 0 && content.charAt(offset - 1) == '.') {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 3: {
                bl = false;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        boolean shouldRecompile = bl;
        CompiledFile compiled = shouldRecompile ? this.sp.currentVersion(uri) : this.sp.latestCompiledVersion(uri);
        return new Pair((Object)compiled, (Object)offset);
    }

    @NotNull
    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(@NotNull CodeActionParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.codeAction$lambda$0(this, params));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<InlayHint>> inlayHint(@NotNull InlayHintParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.inlayHint$lambda$1(this, params));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Hover> hover(@NotNull HoverParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.hover$lambda$3(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<DocumentHighlight>> documentHighlight(@NotNull DocumentHighlightParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.documentHighlight$lambda$4(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<TextEdit>> onTypeFormatting(@NotNull DocumentOnTypeFormattingParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public CompletableFuture<Either<List<Location>, List<LocationLink>>> definition(@NotNull DefinitionParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.definition$lambda$7(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<TextEdit>> rangeFormatting(@NotNull DocumentRangeFormattingParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.rangeFormatting$lambda$8(this, params));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<List<CodeLens>> codeLens(@NotNull CodeLensParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public CompletableFuture<WorkspaceEdit> rename(@NotNull RenameParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.async.compute(() -> KotlinTextDocumentService.rename$lambda$9(this, params));
    }

    @NotNull
    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(@NotNull CompletionParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.completion$lambda$11(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<CompletionItem> resolveCompletionItem(@NotNull CompletionItem unresolved) {
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @NotNull
    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(@NotNull DocumentSymbolParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.documentSymbol$lambda$13(params, this));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    public void didOpen(@NotNull DidOpenTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        URI uri = URIsKt.parseURI((String)string);
        String string2 = params.getTextDocument().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        this.sf.open(uri, string2, params.getTextDocument().getVersion());
        this.lintNow(uri);
    }

    public void didSave(@NotNull DidSaveTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        URI uri = URIsKt.parseURI((String)string);
        this.lintNow(uri);
        this.debounceLint.schedule(arg_0 -> KotlinTextDocumentService.didSave$lambda$14(this, uri, arg_0));
    }

    @NotNull
    public CompletableFuture<SignatureHelp> signatureHelp(@NotNull SignatureHelpParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.signatureHelp$lambda$16(this, position));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    public void didClose(@NotNull DidCloseTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        URI uri = URIsKt.parseURI((String)string);
        this.sf.close(uri);
        this.clearDiagnostics(uri);
    }

    @NotNull
    public CompletableFuture<List<TextEdit>> formatting(@NotNull DocumentFormattingParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        CompletableFuture completableFuture = this.async.compute(() -> KotlinTextDocumentService.formatting$lambda$17(this, params));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"compute(...)");
        return completableFuture;
    }

    public void didChange(@NotNull DidChangeTextDocumentParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        String string = params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        URI uri = URIsKt.parseURI((String)string);
        Integer n = params.getTextDocument().getVersion();
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getVersion(...)");
        int n2 = ((Number)n).intValue();
        List list = params.getContentChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getContentChanges(...)");
        this.sf.edit(uri, n2, list);
        this.lintLater(uri);
    }

    public CompletableFuture<List<Location>> references(@NotNull ReferenceParams position) {
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        return this.async.compute(() -> KotlinTextDocumentService.references$lambda$19(this, position));
    }

    public CompletableFuture<SemanticTokens> semanticTokensFull(@NotNull SemanticTokensParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.async.compute(() -> KotlinTextDocumentService.semanticTokensFull$lambda$21(params, this));
    }

    public CompletableFuture<SemanticTokens> semanticTokensRange(@NotNull SemanticTokensRangeParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        return this.async.compute(() -> KotlinTextDocumentService.semanticTokensRange$lambda$23(params, this));
    }

    @NotNull
    public CompletableFuture<CodeLens> resolveCodeLens(@NotNull CodeLens unresolved) {
        Intrinsics.checkNotNullParameter((Object)unresolved, (String)"unresolved");
        String string = "not implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    private final String describePosition(TextDocumentPositionParams position) {
        String string = position.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        return URIsKt.describeURI((String)string) + " " + (position.getPosition().getLine() + 1) + ":" + (position.getPosition().getCharacter() + 1);
    }

    public final void updateDebouncer() {
        Duration duration = Duration.ofMillis(this.config.getDiagnostics().getDebounceTime());
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(...)");
        this.debounceLint = new Debouncer(duration, null, 2, null);
    }

    public final void lintAll() {
        this.debounceLint.submitImmediately(arg_0 -> KotlinTextDocumentService.lintAll$lambda$24(this, arg_0));
    }

    private final List<URI> clearLint() {
        List result = CollectionsKt.toList((Iterable)this.lintTodo);
        this.lintTodo.clear();
        return result;
    }

    private final void lintLater(URI uri) {
        this.lintTodo.add(uri);
        this.debounceLint.schedule((Function1)new Function1<Function0<? extends Boolean>, Unit>((Object)this){

            public final void invoke(Function0<Boolean> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                KotlinTextDocumentService.access$doLint((KotlinTextDocumentService)this.receiver, p0);
            }
        });
    }

    private final void lintNow(URI file) {
        this.lintTodo.add(file);
        this.debounceLint.submitImmediately((Function1)new Function1<Function0<? extends Boolean>, Unit>((Object)this){

            public final void invoke(Function0<Boolean> p0) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                KotlinTextDocumentService.access$doLint((KotlinTextDocumentService)this.receiver, p0);
            }
        });
    }

    private final void doLint(Function0<Boolean> cancelCallback) {
        Object[] objectArray = new Object[]{URIsKt.describeURIs((Collection)this.lintTodo)};
        LoggerKt.getLOG().info("Linting {}", objectArray);
        List<URI> files = this.clearLint();
        BindingContext context = this.sp.compileFiles((Collection<URI>)files);
        if (!((Boolean)cancelCallback.invoke()).booleanValue()) {
            Collection collection = files;
            Diagnostics diagnostics = context.getDiagnostics();
            Intrinsics.checkNotNullExpressionValue((Object)diagnostics, (String)"getDiagnostics(...)");
            this.reportDiagnostics(collection, diagnostics);
        }
        int n = this.lintCount;
        this.lintCount = n + 1;
    }

    /*
     * WARNING - void declaration
     */
    private final void reportDiagnostics(Collection<URI> compiled, Diagnostics kotlinDiagnostics) {
        void $this$groupByTo$iv$iv;
        void $this$filter$iv;
        boolean bl;
        Iterable $this$flatMap$iv;
        Iterable iterable = (Iterable)kotlinDiagnostics;
        boolean $i$f$flatMap = false;
        void var6_6 = $this$flatMap$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : var6_6) {
            org.jetbrains.kotlin.diagnostics.Diagnostic p0 = (org.jetbrains.kotlin.diagnostics.Diagnostic)element$iv$iv;
            bl = false;
            Iterable list$iv$iv = ConvertDiagnosticKt.convertDiagnostic(p0);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : var6_7) {
            Pair it = (Pair)element$iv$iv;
            bl = false;
            if (!(this.config.getDiagnostics().getEnabled() && ((Diagnostic)it.getSecond()).getSeverity().compareTo((Enum)this.config.getDiagnostics().getLevel()) <= 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List langServerDiagnostics = (List)destination$iv$iv;
        Iterable $this$groupBy$iv = langServerDiagnostics;
        boolean entry = false;
        destination$iv$iv = $this$groupBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Pair it2 = (Pair)element$iv$iv;
            boolean $i$a$-groupBy-KotlinTextDocumentService$reportDiagnostics$byFile$332 = false;
            URI key$iv$iv = (URI)it2.getFirst();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv2;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Pair $i$a$-groupBy-KotlinTextDocumentService$reportDiagnostics$byFile$332 = (Pair)element$iv$iv;
            List list = list$iv$iv;
            boolean bl3 = false;
            list.add((Diagnostic)it.getSecond());
        }
        Map byFile = destination$iv$iv2;
        for (Map.Entry entry2 : byFile.entrySet()) {
            URI uri = (URI)entry2.getKey();
            List diagnostics = (List)entry2.getValue();
            if (this.sf.isOpen(uri)) {
                LanguageClient languageClient = this.client;
                if (languageClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"client");
                    languageClient = null;
                }
                languageClient.publishDiagnostics(new PublishDiagnosticsParams(uri.toString(), diagnostics));
                Object[] objectArray = new Object[]{diagnostics.size(), URIsKt.describeURI((URI)uri)};
                LoggerKt.getLOG().info("Reported {} diagnostics in {}", objectArray);
                continue;
            }
            Object[] objectArray = new Object[]{diagnostics.size(), URIsKt.describeURI((URI)uri)};
            LoggerKt.getLOG().info("Ignore {} diagnostics in {} because it's not open", objectArray);
        }
        List noErrors = CollectionsKt.minus((Iterable)compiled, (Iterable)byFile.keySet());
        for (URI file : noErrors) {
            this.clearDiagnostics(file);
            Object[] objectArray = new Object[]{file};
            LoggerKt.getLOG().info("No diagnostics in {}", objectArray);
        }
        int n = this.lintCount;
        this.lintCount = n + 1;
    }

    private final void clearDiagnostics(URI uri) {
        LanguageClient languageClient = this.client;
        if (languageClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"client");
            languageClient = null;
        }
        languageClient.publishDiagnostics(new PublishDiagnosticsParams(uri.toString(), CollectionsKt.emptyList()));
    }

    private final void shutdownExecutors(boolean awaitTermination) {
        this.async.shutdown(awaitTermination);
        this.debounceLint.shutdown(awaitTermination);
    }

    @Override
    public void close() {
        this.shutdownExecutors(true);
    }

    private static final List codeAction$lambda$0(KotlinTextDocumentService this$0, CodeActionParams $params) {
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        Position position = $params.getRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Pair<CompiledFile, Integer> pair = this$0.recover(string, position, Recompile.NEVER);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        CompiledFile file = (CompiledFile)pair.component1();
        SymbolIndex symbolIndex = this$0.sp.getIndex();
        Range range = $params.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
        CodeActionContext codeActionContext = $params.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)codeActionContext, (String)"getContext(...)");
        return CodeActionKt.codeActions(file, symbolIndex, range, codeActionContext);
    }

    private static final List inlayHint$lambda$1(KotlinTextDocumentService this$0, InlayHintParams $params) {
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        Position position = $params.getRange().getStart();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getStart(...)");
        Pair<CompiledFile, Integer> pair = this$0.recover(string, position, Recompile.ALWAYS);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        CompiledFile file = (CompiledFile)pair.component1();
        return InlayHintKt.provideHints(file, this$0.config.getInlayHints());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Hover hover$lambda$3(KotlinTextDocumentService this$0, HoverParams $position) {
        Object[] objectArray;
        Object[] objectArray2;
        long started$iv;
        block4: {
            Hover hover;
            boolean $i$f$reportTime = false;
            started$iv = System.currentTimeMillis();
            try {
                boolean bl = false;
                objectArray2 = new Object[]{this$0.describePosition((TextDocumentPositionParams)$position)};
                LoggerKt.getLOG().info("Hovering at {}", objectArray2);
                if (this$0.recover((TextDocumentPositionParams)$position, Recompile.NEVER) != null) break block4;
                hover = null;
            }
            catch (Throwable throwable) {
                long finished$iv = System.currentTimeMillis();
                Object[] objectArray3 = new Object[]{finished$iv - started$iv};
                LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
                throw throwable;
            }
            long l = System.currentTimeMillis();
            Object[] objectArray4 = new Object[]{l - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray4);
            return hover;
        }
        objectArray2 = objectArray;
        CompiledFile file = (CompiledFile)objectArray2.component1();
        int cursor = ((Number)objectArray2.component2()).intValue();
        Hover hover = HoversKt.hoverAt(file, cursor);
        if (hover == null) {
            hover = (Hover)UtilsKt.noResult((String)("No hover found at " + this$0.describePosition((TextDocumentPositionParams)$position)), null);
        }
        Hover hover2 = hover;
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray5 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray5);
        return hover2;
    }

    private static final List documentHighlight$lambda$4(KotlinTextDocumentService this$0, DocumentHighlightParams $position) {
        String string = $position.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        Position position = $position.getPosition();
        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"getPosition(...)");
        Pair<CompiledFile, Integer> pair = this$0.recover(string, position, Recompile.NEVER);
        if (pair == null) {
            return CollectionsKt.emptyList();
        }
        Pair<CompiledFile, Integer> pair2 = pair;
        CompiledFile file = (CompiledFile)pair2.component1();
        int cursor = ((Number)pair2.component2()).intValue();
        return DocumentHighlightKt.documentHighlightsAt(file, cursor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final Either definition$lambda$7(KotlinTextDocumentService this$0, DefinitionParams $position) {
        block5: {
            $i$f$reportTime = false;
            started$iv = System.currentTimeMillis();
            try {
                $i$a$-reportTime-KotlinTextDocumentService$definition$1$1 = false;
                var6_6 = new Object[]{this$0.describePosition((TextDocumentPositionParams)$position)};
                LoggerKt.getLOG().info("Go-to-definition at {}", var6_6);
                if (this$0.recover((TextDocumentPositionParams)$position, Recompile.NEVER) != null) break block5;
                var19_8 = Either.forLeft((Object)CollectionsKt.emptyList());
            }
            catch (Throwable var6_7) {
                finished$iv = System.currentTimeMillis();
                var9_16 = new Object[]{finished$iv - started$iv};
                LoggerKt.getLOG().info("Finished in {} ms", var9_16);
                throw var6_7;
            }
            var15_9 = System.currentTimeMillis();
            var8_11 = new Object[]{var15_9 - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", var8_11);
            return var19_8;
        }
        var6_6 = v0;
        file = (CompiledFile)var6_6.component1();
        cursor = ((Number)var6_6.component2()).intValue();
        var9_15 = GoToDefinitionKt.goToDefinition(file, cursor, this$0.uriContentProvider.getClassContentProvider(), this$0.tempDirectory, this$0.config.getExternalSources(), this$0.cp);
        if (var9_15 == null) ** GOTO lbl-1000
        p0 = var9_15;
        $i$a$-let-KotlinTextDocumentService$definition$1$1$1 = false;
        var12_20 = CollectionsKt.listOf((Object)p0);
        if (var12_20 == null) ** GOTO lbl-1000
        it = var12_20;
        $i$a$-let-KotlinTextDocumentService$definition$1$1$2 = false;
        var14_22 = Either.forLeft((Object)it);
        if (var14_22 != null) {
            v1 = var14_22;
        } else lbl-1000:
        // 3 sources

        {
            v1 = (Either)UtilsKt.noResult((String)("Couldn't find definition at " + this$0.describePosition((TextDocumentPositionParams)$position)), (Object)Either.forLeft((Object)CollectionsKt.emptyList()));
        }
        var5_5 = v1;
        finished$iv = System.currentTimeMillis();
        var8_13 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", var8_13);
        return var5_5;
    }

    private static final List rangeFormatting$lambda$8(KotlinTextDocumentService this$0, DocumentRangeFormattingParams $params) {
        TextDocumentIdentifier textDocumentIdentifier = $params.getTextDocument();
        Intrinsics.checkNotNullExpressionValue((Object)textDocumentIdentifier, (String)"getTextDocument(...)");
        String string = this$0.getContent(textDocumentIdentifier);
        Range range = $params.getRange();
        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
        String code = PositionKt.extractRange(string, range);
        Range range2 = $params.getRange();
        FormattingService formattingService = this$0.formattingService;
        FormattingOptions formattingOptions = $params.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)formattingOptions, (String)"getOptions(...)");
        return CollectionsKt.listOf((Object)new TextEdit(range2, formattingService.formatKotlinCode(code, formattingOptions)));
    }

    private static final WorkspaceEdit rename$lambda$9(KotlinTextDocumentService this$0, RenameParams $params) {
        Pair<CompiledFile, Integer> pair = this$0.recover((TextDocumentPositionParams)$params, Recompile.NEVER);
        if (pair == null) {
            return null;
        }
        Pair<CompiledFile, Integer> pair2 = pair;
        CompiledFile file = (CompiledFile)pair2.component1();
        int cursor = ((Number)pair2.component2()).intValue();
        SourcePath sourcePath = this$0.sp;
        String string = $params.getNewName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNewName(...)");
        return RenameKt.renameSymbol(file, cursor, sourcePath, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Either completion$lambda$11(KotlinTextDocumentService this$0, CompletionParams $position) {
        Object[] objectArray;
        Object[] objectArray2;
        long started$iv;
        block3: {
            Either either;
            boolean $i$f$reportTime = false;
            started$iv = System.currentTimeMillis();
            try {
                boolean bl = false;
                objectArray2 = new Object[]{this$0.describePosition((TextDocumentPositionParams)$position)};
                LoggerKt.getLOG().info("Completing at {}", objectArray2);
                if (this$0.recover((TextDocumentPositionParams)$position, Recompile.NEVER) != null) break block3;
                either = Either.forRight((Object)new CompletionList());
            }
            catch (Throwable throwable) {
                long finished$iv = System.currentTimeMillis();
                Object[] objectArray3 = new Object[]{finished$iv - started$iv};
                LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
                throw throwable;
            }
            long l = System.currentTimeMillis();
            Object[] objectArray4 = new Object[]{l - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray4);
            return either;
        }
        objectArray2 = objectArray;
        CompiledFile file = (CompiledFile)objectArray2.component1();
        int cursor = ((Number)objectArray2.component2()).intValue();
        CompletionList completions = CompletionsKt.completions(file, cursor, this$0.sp.getIndex(), this$0.config.getCompletion());
        Object[] objectArray5 = new Object[]{completions.getItems().size()};
        LoggerKt.getLOG().info("Found {} items", objectArray5);
        Either either = Either.forRight((Object)completions);
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray6 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray6);
        return either;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List documentSymbol$lambda$13(DocumentSymbolParams $params, KotlinTextDocumentService this$0) {
        List<Either<SymbolInformation, DocumentSymbol>> list;
        Logger logger = LoggerKt.getLOG();
        Object[] objectArray = new Object[1];
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        objectArray[0] = URIsKt.describeURI((String)string);
        logger.info("Find symbols in {}", objectArray);
        boolean $i$f$reportTime = false;
        long started$iv = System.currentTimeMillis();
        try {
            boolean bl = false;
            String string2 = $params.getTextDocument().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
            URI uri = URIsKt.parseURI((String)string2);
            KtFile parsed = this$0.sp.parsedFile(uri);
            list = SymbolsKt.documentSymbols(parsed);
        }
        catch (Throwable throwable) {
            long finished$iv = System.currentTimeMillis();
            Object[] objectArray2 = new Object[]{finished$iv - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray2);
            throw throwable;
        }
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray3 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
        return list;
    }

    private static final Unit didSave$lambda$14(KotlinTextDocumentService this$0, URI $uri, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sp.save($uri);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SignatureHelp signatureHelp$lambda$16(KotlinTextDocumentService this$0, SignatureHelpParams $position) {
        Object[] objectArray;
        Object[] objectArray2;
        long started$iv;
        block4: {
            SignatureHelp signatureHelp;
            boolean $i$f$reportTime = false;
            started$iv = System.currentTimeMillis();
            try {
                boolean bl = false;
                objectArray2 = new Object[]{this$0.describePosition((TextDocumentPositionParams)$position)};
                LoggerKt.getLOG().info("Signature help at {}", objectArray2);
                if (this$0.recover((TextDocumentPositionParams)$position, Recompile.NEVER) != null) break block4;
                signatureHelp = null;
            }
            catch (Throwable throwable) {
                long finished$iv = System.currentTimeMillis();
                Object[] objectArray3 = new Object[]{finished$iv - started$iv};
                LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
                throw throwable;
            }
            long l = System.currentTimeMillis();
            Object[] objectArray4 = new Object[]{l - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray4);
            return signatureHelp;
        }
        objectArray2 = objectArray;
        CompiledFile file = (CompiledFile)objectArray2.component1();
        int cursor = ((Number)objectArray2.component2()).intValue();
        SignatureHelp signatureHelp = SignatureHelpKt.fetchSignatureHelpAt(file, cursor);
        if (signatureHelp == null) {
            signatureHelp = (SignatureHelp)UtilsKt.noResult((String)("No function call around " + this$0.describePosition((TextDocumentPositionParams)$position)), null);
        }
        SignatureHelp signatureHelp2 = signatureHelp;
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray5 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray5);
        return signatureHelp2;
    }

    private static final List formatting$lambda$17(KotlinTextDocumentService this$0, DocumentFormattingParams $params) {
        TextDocumentIdentifier textDocumentIdentifier = $params.getTextDocument();
        Intrinsics.checkNotNullExpressionValue((Object)textDocumentIdentifier, (String)"getTextDocument(...)");
        String code = this$0.getContent(textDocumentIdentifier);
        Logger logger = LoggerKt.getLOG();
        Object[] objectArray = new Object[1];
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        objectArray[0] = URIsKt.describeURI((String)string);
        logger.info("Formatting {}", objectArray);
        Range range = new Range(new Position(0, 0), PositionKt.position(code, code.length()));
        FormattingService formattingService = this$0.formattingService;
        FormattingOptions formattingOptions = $params.getOptions();
        Intrinsics.checkNotNullExpressionValue((Object)formattingOptions, (String)"getOptions(...)");
        return CollectionsKt.listOf((Object)new TextEdit(range, formattingService.formatKotlinCode(code, formattingOptions)));
    }

    private static final List references$lambda$19(KotlinTextDocumentService this$0, ReferenceParams $position) {
        List<Location> list;
        TextDocumentIdentifier textDocumentIdentifier = $position.getTextDocument();
        Intrinsics.checkNotNullExpressionValue((Object)textDocumentIdentifier, (String)"getTextDocument(...)");
        Path path = this$0.getFilePath(textDocumentIdentifier);
        if (path != null) {
            Path file = path;
            boolean bl = false;
            SourcePath sourcePath = this$0.sp;
            String string = $position.getTextDocument().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
            String content = sourcePath.content(URIsKt.parseURI((String)string));
            int offset = PositionKt.offset(content, $position.getPosition().getLine(), $position.getPosition().getCharacter());
            list = FindReferencesKt.findReferences(file, offset, this$0.sp);
        } else {
            list = null;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SemanticTokens semanticTokensFull$lambda$21(SemanticTokensParams $params, KotlinTextDocumentService this$0) {
        SemanticTokens semanticTokens;
        Logger logger = LoggerKt.getLOG();
        Object[] objectArray = new Object[1];
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        objectArray[0] = URIsKt.describeURI((String)string);
        logger.info("Full semantic tokens in {}", objectArray);
        boolean $i$f$reportTime = false;
        long started$iv = System.currentTimeMillis();
        try {
            boolean bl = false;
            String string2 = $params.getTextDocument().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
            URI uri = URIsKt.parseURI((String)string2);
            CompiledFile file = this$0.sp.currentVersion(uri);
            List tokens = SemanticTokensKt.encodedSemanticTokens$default(file, null, 2, null);
            Object[] objectArray2 = new Object[]{tokens.size()};
            LoggerKt.getLOG().info("Found {} tokens", objectArray2);
            semanticTokens = new SemanticTokens(tokens);
        }
        catch (Throwable throwable) {
            long finished$iv = System.currentTimeMillis();
            Object[] objectArray3 = new Object[]{finished$iv - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
            throw throwable;
        }
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray4 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray4);
        return semanticTokens;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final SemanticTokens semanticTokensRange$lambda$23(SemanticTokensRangeParams $params, KotlinTextDocumentService this$0) {
        SemanticTokens semanticTokens;
        Logger logger = LoggerKt.getLOG();
        Object[] objectArray = new Object[1];
        String string = $params.getTextDocument().getUri();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUri(...)");
        objectArray[0] = URIsKt.describeURI((String)string);
        logger.info("Ranged semantic tokens in {}", objectArray);
        boolean $i$f$reportTime = false;
        long started$iv = System.currentTimeMillis();
        try {
            boolean bl = false;
            String string2 = $params.getTextDocument().getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUri(...)");
            URI uri = URIsKt.parseURI((String)string2);
            CompiledFile file = this$0.sp.currentVersion(uri);
            List<Integer> tokens = SemanticTokensKt.encodedSemanticTokens(file, $params.getRange());
            Object[] objectArray2 = new Object[]{tokens.size()};
            LoggerKt.getLOG().info("Found {} tokens", objectArray2);
            semanticTokens = new SemanticTokens(tokens);
        }
        catch (Throwable throwable) {
            long finished$iv = System.currentTimeMillis();
            Object[] objectArray3 = new Object[]{finished$iv - started$iv};
            LoggerKt.getLOG().info("Finished in {} ms", objectArray3);
            throw throwable;
        }
        long finished$iv = System.currentTimeMillis();
        Object[] objectArray4 = new Object[]{finished$iv - started$iv};
        LoggerKt.getLOG().info("Finished in {} ms", objectArray4);
        return semanticTokens;
    }

    private static final Unit lintAll$lambda$24(KotlinTextDocumentService this$0, Function0 it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.sp.compileAllFiles();
        this$0.sp.saveAllFiles();
        this$0.sp.refreshDependencyIndexes();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$doLint(KotlinTextDocumentService $this, Function0 cancelCallback) {
        $this.doLint((Function0<Boolean>)cancelCallback);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lorg/javacs/kt/KotlinTextDocumentService$Recompile;", "", "<init>", "(Ljava/lang/String;I)V", "ALWAYS", "AFTER_DOT", "NEVER", "server"})
    private static final class Recompile
    extends Enum<Recompile> {
        public static final /* enum */ Recompile ALWAYS = new Recompile();
        public static final /* enum */ Recompile AFTER_DOT = new Recompile();
        public static final /* enum */ Recompile NEVER = new Recompile();
        private static final /* synthetic */ Recompile[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Recompile[] values() {
            return (Recompile[])$VALUES.clone();
        }

        public static Recompile valueOf(String value) {
            return Enum.valueOf(Recompile.class, value);
        }

        @NotNull
        public static EnumEntries<Recompile> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = recompileArray = new Recompile[]{Recompile.ALWAYS, Recompile.AFTER_DOT, Recompile.NEVER};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Recompile.values().length];
            try {
                nArray[Recompile.ALWAYS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Recompile.AFTER_DOT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Recompile.NEVER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

