/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.results.ResolutionStatus;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.KotlinToResolvedCallTransformerKt;
import org.jetbrains.kotlin.resolve.calls.tower.NewResolvedCallImpl;
import org.jetbrains.kotlin.resolve.calls.tower.NewVariableAsFunctionResolvedCallImpl;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0002\u001a\u000e\u0010\u0003\u001a\u00020\u0001*\u0006\u0012\u0002\b\u00030\u0004\u001a\f\u0010\u0005\u001a\u00020\u0001*\u00020\u0006H\u0002\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u00a8\u0006\n"}, d2={"hasInferredReturnType", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/NewResolvedCallImpl;", "isNewNotCompleted", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "isNotSimpleCall", "Lorg/jetbrains/kotlin/descriptors/CallableMemberDescriptor;", "toResolutionStatus", "Lorg/jetbrains/kotlin/resolve/calls/results/ResolutionStatus;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "frontend"})
public final class KotlinToResolvedCallTransformerKt {
    @NotNull
    public static final ResolutionStatus toResolutionStatus(@NotNull CandidateApplicability $this$toResolutionStatus) {
        ResolutionStatus resolutionStatus;
        Intrinsics.checkNotNullParameter((Object)$this$toResolutionStatus, "<this>");
        CandidateApplicability candidateApplicability = $this$toResolutionStatus;
        int n = WhenMappings.$EnumSwitchMapping$0[candidateApplicability.ordinal()];
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                resolutionStatus = ResolutionStatus.SUCCESS;
                break;
            }
            case 5: {
                resolutionStatus = ResolutionStatus.RECEIVER_TYPE_ERROR;
                break;
            }
            case 6: {
                resolutionStatus = ResolutionStatus.UNSAFE_CALL_ERROR;
                break;
            }
            default: {
                resolutionStatus = ResolutionStatus.OTHER_ERROR;
            }
        }
        return resolutionStatus;
    }

    public static final boolean isNewNotCompleted(@NotNull ResolvedCall<?> $this$isNewNotCompleted) {
        Intrinsics.checkNotNullParameter($this$isNewNotCompleted, "<this>");
        if ($this$isNewNotCompleted instanceof NewVariableAsFunctionResolvedCallImpl) {
            return !((NewResolvedCallImpl)((NewVariableAsFunctionResolvedCallImpl)$this$isNewNotCompleted).getFunctionCall()).isCompleted();
        }
        if ($this$isNewNotCompleted instanceof NewResolvedCallImpl) {
            return !((NewResolvedCallImpl)$this$isNewNotCompleted).isCompleted();
        }
        return false;
    }

    public static final boolean hasInferredReturnType(@NotNull NewResolvedCallImpl<?> $this$hasInferredReturnType) {
        Intrinsics.checkNotNullParameter($this$hasInferredReturnType, "<this>");
        if (KotlinToResolvedCallTransformerKt.isNewNotCompleted((ResolvedCall)$this$hasInferredReturnType)) {
            return false;
        }
        KotlinType kotlinType = $this$hasInferredReturnType.getResultingDescriptor().getReturnType();
        if (kotlinType == null) {
            return false;
        }
        KotlinType kotlinType2 = kotlinType;
        KotlinType returnType2 = kotlinType2;
        return !TypeUtilsKt.contains(returnType2, hasInferredReturnType.1.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isNotSimpleCall(CallableMemberDescriptor $this$isNotSimpleCall) {
        Object object;
        Object object2 = $this$isNotSimpleCall.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue(object2, "typeParameters");
        if (!((Collection)object2).isEmpty()) {
            return true;
        }
        boolean bl = false;
        if (bl) return true;
        object2 = $this$isNotSimpleCall.getReturnType();
        if (object2 == null) {
            return false;
        }
        Object type2 = object = object2;
        boolean bl2 = false;
        boolean bl3 = TypeUtilsKt.contains((KotlinType)type2, isNotSimpleCall.1.1.INSTANCE);
        if (!bl3) return false;
        return true;
    }

    public static final /* synthetic */ boolean access$isNotSimpleCall(CallableMemberDescriptor $receiver) {
        return KotlinToResolvedCallTransformerKt.isNotSimpleCall($receiver);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CandidateApplicability.values().length];
            nArray[CandidateApplicability.RESOLVED.ordinal()] = 1;
            nArray[CandidateApplicability.RESOLVED_LOW_PRIORITY.ordinal()] = 2;
            nArray[CandidateApplicability.RESOLVED_WITH_ERROR.ordinal()] = 3;
            nArray[CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY.ordinal()] = 4;
            nArray[CandidateApplicability.INAPPLICABLE_WRONG_RECEIVER.ordinal()] = 5;
            nArray[CandidateApplicability.UNSAFE_CALL.ordinal()] = 6;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

