/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.aether.util.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.kotlin.org.eclipse.aether.graph.DependencyFilter;
import org.jetbrains.kotlin.org.eclipse.aether.util.filter.ScopeDependencyFilter;

public final class DependencyFilterUtils {
    public static DependencyFilter classpathFilter(String ... classpathTypes) {
        return DependencyFilterUtils.classpathFilter(classpathTypes != null ? Arrays.asList(classpathTypes) : null);
    }

    public static DependencyFilter classpathFilter(Collection<String> classpathTypes) {
        HashSet<String> types2 = new HashSet<String>();
        if (classpathTypes != null) {
            for (String string2 : classpathTypes) {
                String[] tokens;
                for (String token : tokens = string2.split("[+,]")) {
                    if ((token = token.trim()).length() <= 0) continue;
                    types2.add(token);
                }
            }
        }
        HashSet<String> included = new HashSet<String>();
        for (String type2 : types2) {
            if ("compile".equals(type2)) {
                Collections.addAll(included, "compile", "provided", "system");
                continue;
            }
            if ("runtime".equals(type2)) {
                Collections.addAll(included, "compile", "runtime");
                continue;
            }
            if ("test".equals(type2)) {
                Collections.addAll(included, "compile", "provided", "system", "runtime", "test");
                continue;
            }
            included.add(type2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        Collections.addAll(hashSet, "compile", "provided", "system", "runtime", "test");
        hashSet.removeAll(included);
        return new ScopeDependencyFilter(null, hashSet);
    }
}

