/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters;

import java.lang.reflect.Array;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.converters.ConfigurationConverter;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import org.jetbrains.kotlin.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Roles;

public abstract class AbstractConfigurationConverter
implements ConfigurationConverter {
    protected Object fromExpression(PlexusConfiguration configuration2, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String value2 = configuration2.getValue();
        try {
            Object result2 = null;
            if (value2 != null && value2.length() > 0) {
                result2 = evaluator.evaluate(value2);
            }
            if (result2 == null && configuration2.getChildCount() == 0 && (value2 = configuration2.getAttribute("default-value")) != null && value2.length() > 0) {
                result2 = evaluator.evaluate(value2);
            }
            return result2;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value2, configuration2.getName());
            throw new ComponentConfigurationException(configuration2, reason, e);
        }
    }

    protected Object fromExpression(PlexusConfiguration configuration2, ExpressionEvaluator evaluator, Class<?> type2) throws ComponentConfigurationException {
        Object result2 = this.fromExpression(configuration2, evaluator);
        this.failIfNotTypeCompatible(result2, type2, configuration2);
        return result2;
    }

    protected final String fromXML(String name2) {
        return Roles.camelizeName(name2);
    }

    protected final void failIfNotTypeCompatible(Object value2, Class<?> type2, PlexusConfiguration configuration2) throws ComponentConfigurationException {
        if (value2 != null && type2 != null && !type2.isInstance(value2)) {
            String reason = String.format("Cannot assign configuration entry '%s' with value '%s' of type %s to property of type %s", configuration2.getName(), configuration2.getValue(), value2.getClass().getCanonicalName(), type2.getCanonicalName());
            throw new ComponentConfigurationException(configuration2, reason);
        }
    }

    protected final Class<?> getClassForImplementationHint(Class<?> type2, PlexusConfiguration configuration2, ClassLoader loader) throws ComponentConfigurationException {
        String hint = configuration2.getAttribute("implementation");
        if (hint == null) {
            return type2;
        }
        try {
            int dims = 0;
            while (hint.endsWith("[]")) {
                hint = hint.substring(0, hint.length() - 2);
                ++dims;
            }
            Class<?> implType = loader.loadClass(hint);
            while (dims > 0) {
                implType = Array.newInstance(implType, 0).getClass();
                --dims;
            }
            return implType;
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot load implementation hint '" + hint + "'", e);
        }
    }

    protected final Object instantiateObject(Class<?> type2) throws ComponentConfigurationException {
        try {
            return type2.newInstance();
        }
        catch (Exception e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type2, e);
        }
        catch (LinkageError e) {
            throw new ComponentConfigurationException("Cannot create instance of " + type2, e);
        }
    }
}

