/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocation;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;
import org.jetbrains.kotlin.org.apache.maven.model.ReportPlugin;

public class Reporting
implements Serializable,
Cloneable,
InputLocationTracker {
    private String excludeDefaults;
    private String outputDirectory;
    private List<ReportPlugin> plugins;
    private Map<Object, InputLocation> locations;
    private InputLocation location;
    private InputLocation excludeDefaultsLocation;
    private InputLocation outputDirectoryLocation;
    private InputLocation pluginsLocation;

    public Reporting clone() {
        try {
            Reporting copy2 = (Reporting)super.clone();
            if (this.plugins != null) {
                copy2.plugins = new ArrayList<ReportPlugin>();
                for (ReportPlugin item : this.plugins) {
                    copy2.plugins.add(item.clone());
                }
            }
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public String getExcludeDefaults() {
        return this.excludeDefaults;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case -241452468: {
                    if (!string2.equals("excludeDefaults")) break;
                    n = 1;
                    break;
                }
                case -1653164436: {
                    if (!string2.equals("outputDirectory")) break;
                    n = 2;
                    break;
                }
                case -475629664: {
                    if (!string2.equals("plugins")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
                case 1: {
                    return this.excludeDefaultsLocation;
                }
                case 2: {
                    return this.outputDirectoryLocation;
                }
                case 3: {
                    return this.pluginsLocation;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                    break;
                }
                case -241452468: {
                    if (!string2.equals("excludeDefaults")) break;
                    n = 1;
                    break;
                }
                case -1653164436: {
                    if (!string2.equals("outputDirectory")) break;
                    n = 2;
                    break;
                }
                case -475629664: {
                    if (!string2.equals("plugins")) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location2;
                    return;
                }
                case 1: {
                    this.excludeDefaultsLocation = location2;
                    return;
                }
                case 2: {
                    this.outputDirectoryLocation = location2;
                    return;
                }
                case 3: {
                    this.pluginsLocation = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public List<ReportPlugin> getPlugins() {
        if (this.plugins == null) {
            this.plugins = new ArrayList<ReportPlugin>();
        }
        return this.plugins;
    }

    public void setExcludeDefaults(String excludeDefaults) {
        this.excludeDefaults = excludeDefaults;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setPlugins(List<ReportPlugin> plugins) {
        this.plugins = plugins;
    }

    public boolean isExcludeDefaults() {
        return this.excludeDefaults != null ? Boolean.parseBoolean(this.excludeDefaults) : false;
    }
}

