/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.maven.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.kotlin.org.apache.maven.model.InputLocationTracker;
import org.jetbrains.kotlin.org.apache.maven.model.InputSource;

public final class InputLocation
implements Serializable,
Cloneable,
InputLocationTracker {
    private int lineNumber = -1;
    private int columnNumber = -1;
    private InputSource source;
    private Map<Object, InputLocation> locations;
    private InputLocation location;

    public InputLocation(int lineNumber, int columnNumber, InputSource source) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
        this.source = source;
    }

    public InputLocation clone() {
        try {
            InputLocation copy2 = (InputLocation)super.clone();
            if (copy2.locations != null) {
                copy2.locations = new LinkedHashMap<Object, InputLocation>(copy2.locations);
            }
            return copy2;
        }
        catch (Exception ex) {
            throw (RuntimeException)new UnsupportedOperationException(this.getClass().getName() + " does not support clone()").initCause(ex);
        }
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    return this.location;
                }
            }
            return this.getOtherLocation(key);
        }
        return this.getOtherLocation(key);
    }

    public Map<Object, InputLocation> getLocations() {
        return this.locations;
    }

    public void setLocation(Object key, InputLocation location2) {
        if (key instanceof String) {
            String string2 = (String)key;
            int n = -1;
            switch (string2.hashCode()) {
                case 0: {
                    if (!string2.equals("")) break;
                    n = 0;
                }
            }
            switch (n) {
                case 0: {
                    this.location = location2;
                    return;
                }
            }
            this.setOtherLocation(key, location2);
            return;
        }
        this.setOtherLocation(key, location2);
    }

    public void setOtherLocation(Object key, InputLocation location2) {
        if (location2 != null) {
            if (this.locations == null) {
                this.locations = new LinkedHashMap<Object, InputLocation>();
            }
            this.locations.put(key, location2);
        }
    }

    private InputLocation getOtherLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public InputSource getSource() {
        return this.source;
    }

    public static InputLocation merge(InputLocation target, InputLocation source, boolean sourceDominant) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        InputLocation result2 = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            locations.putAll(sourceDominant ? targetLocations : sourceLocations);
            locations.putAll(sourceDominant ? sourceLocations : targetLocations);
        }
        result2.setLocations(locations);
        return result2;
    }

    public static InputLocation merge(InputLocation target, InputLocation source, Collection<Integer> indices) {
        Map<Object, InputLocation> locations;
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        InputLocation result2 = new InputLocation(target.getLineNumber(), target.getColumnNumber(), target.getSource());
        Map<Object, InputLocation> sourceLocations = source.getLocations();
        Map<Object, InputLocation> targetLocations = target.getLocations();
        if (sourceLocations == null) {
            locations = targetLocations;
        } else if (targetLocations == null) {
            locations = sourceLocations;
        } else {
            locations = new LinkedHashMap<Object, InputLocation>();
            for (Integer index2 : indices) {
                InputLocation location2 = index2 < 0 ? sourceLocations.get(~index2.intValue()) : targetLocations.get(index2);
                locations.put(locations.size(), location2);
            }
        }
        result2.setLocations(locations);
        return result2;
    }

    public void setLocations(Map<Object, InputLocation> locations) {
        this.locations = locations;
    }

    public String toString() {
        return this.getLineNumber() + " : " + this.getColumnNumber() + ", " + this.getSource();
    }
}

