/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.execchain;

import java.io.IOException;
import java.io.InterruptedIOException;
import org.jetbrains.kotlin.org.apache.commons.logging.Log;
import org.jetbrains.kotlin.org.apache.commons.logging.LogFactory;
import org.jetbrains.kotlin.org.apache.http.Header;
import org.jetbrains.kotlin.org.apache.http.HttpException;
import org.jetbrains.kotlin.org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.jetbrains.kotlin.org.apache.http.client.methods.CloseableHttpResponse;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpExecutionAware;
import org.jetbrains.kotlin.org.apache.http.client.methods.HttpRequestWrapper;
import org.jetbrains.kotlin.org.apache.http.client.protocol.HttpClientContext;
import org.jetbrains.kotlin.org.apache.http.conn.routing.HttpRoute;
import org.jetbrains.kotlin.org.apache.http.impl.execchain.ClientExecChain;
import org.jetbrains.kotlin.org.apache.http.impl.execchain.RequestEntityProxy;
import org.jetbrains.kotlin.org.apache.http.util.Args;

public class ServiceUnavailableRetryExec
implements ClientExecChain {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ClientExecChain requestExecutor;
    private final ServiceUnavailableRetryStrategy retryStrategy;

    public ServiceUnavailableRetryExec(ClientExecChain requestExecutor, ServiceUnavailableRetryStrategy retryStrategy) {
        Args.notNull(requestExecutor, "HTTP request executor");
        Args.notNull(retryStrategy, "Retry strategy");
        this.requestExecutor = requestExecutor;
        this.retryStrategy = retryStrategy;
    }

    @Override
    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext context2, HttpExecutionAware execAware) throws IOException, HttpException {
        Header[] origheaders = request.getAllHeaders();
        int c = 1;
        while (true) {
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, context2, execAware);
            try {
                if (this.retryStrategy.retryRequest(response, c, context2) && RequestEntityProxy.isRepeatable(request)) {
                    response.close();
                    long nextInterval = this.retryStrategy.getRetryInterval();
                    if (nextInterval > 0L) {
                        try {
                            this.log.trace("Wait for " + nextInterval);
                            Thread.sleep(nextInterval);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new InterruptedIOException();
                        }
                    }
                } else {
                    return response;
                }
                request.setHeaders(origheaders);
            }
            catch (RuntimeException ex) {
                response.close();
                throw ex;
            }
            ++c;
        }
    }
}

