/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.kotlin.org.apache.http.FormattedHeader;
import org.jetbrains.kotlin.org.apache.http.Header;
import org.jetbrains.kotlin.org.apache.http.cookie.CommonCookieAttributeHandler;
import org.jetbrains.kotlin.org.apache.http.cookie.Cookie;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieAttributeHandler;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieOrigin;
import org.jetbrains.kotlin.org.apache.http.cookie.CookiePriorityComparator;
import org.jetbrains.kotlin.org.apache.http.cookie.CookieSpec;
import org.jetbrains.kotlin.org.apache.http.cookie.MalformedCookieException;
import org.jetbrains.kotlin.org.apache.http.impl.cookie.BasicClientCookie;
import org.jetbrains.kotlin.org.apache.http.message.BufferedHeader;
import org.jetbrains.kotlin.org.apache.http.message.ParserCursor;
import org.jetbrains.kotlin.org.apache.http.message.TokenParser;
import org.jetbrains.kotlin.org.apache.http.util.Args;
import org.jetbrains.kotlin.org.apache.http.util.CharArrayBuffer;

public class RFC6265CookieSpec
implements CookieSpec {
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET(61, 59);
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET(59);
    private static final BitSet SPECIAL_CHARS = TokenParser.INIT_BITSET(32, 34, 44, 59, 92);
    private final CookieAttributeHandler[] attribHandlers;
    private final Map<String, CookieAttributeHandler> attribHandlerMap;
    private final TokenParser tokenParser;

    protected RFC6265CookieSpec(CommonCookieAttributeHandler ... handlers2) {
        this.attribHandlers = (CookieAttributeHandler[])handlers2.clone();
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(handlers2.length);
        for (CommonCookieAttributeHandler handler2 : handlers2) {
            this.attribHandlerMap.put(handler2.getAttributeName().toLowerCase(Locale.ROOT), handler2);
        }
        this.tokenParser = TokenParser.INSTANCE;
    }

    static String getDefaultPath(CookieOrigin origin) {
        String defaultPath = origin.getPath();
        int lastSlashIndex = defaultPath.lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = defaultPath.substring(0, lastSlashIndex);
        }
        return defaultPath;
    }

    static String getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    @Override
    public final List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        ParserCursor cursor;
        CharArrayBuffer buffer;
        Args.notNull(header, "Header");
        Args.notNull(origin, "Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header: '" + header.toString() + "'");
        }
        if (header instanceof FormattedHeader) {
            buffer = ((FormattedHeader)header).getBuffer();
            cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
        } else {
            String s = header.getValue();
            if (s == null) {
                throw new MalformedCookieException("Header value is null");
            }
            buffer = new CharArrayBuffer(s.length());
            buffer.append(s);
            cursor = new ParserCursor(0, buffer.length());
        }
        String name2 = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (name2.isEmpty()) {
            return Collections.emptyList();
        }
        if (cursor.atEnd()) {
            return Collections.emptyList();
        }
        char valueDelim = buffer.charAt(cursor.getPos());
        cursor.updatePos(cursor.getPos() + 1);
        if (valueDelim != '=') {
            throw new MalformedCookieException("Cookie value is invalid: '" + header.toString() + "'");
        }
        String value2 = this.tokenParser.parseValue(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            cursor.updatePos(cursor.getPos() + 1);
        }
        BasicClientCookie cookie = new BasicClientCookie(name2, value2);
        cookie.setPath(RFC6265CookieSpec.getDefaultPath(origin));
        cookie.setDomain(RFC6265CookieSpec.getDefaultDomain(origin));
        cookie.setCreationDate(new Date());
        LinkedHashMap<String, String> attribMap = new LinkedHashMap<String, String>();
        while (!cursor.atEnd()) {
            String paramName = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS).toLowerCase(Locale.ROOT);
            String paramValue = null;
            if (!cursor.atEnd()) {
                char paramDelim = buffer.charAt(cursor.getPos());
                cursor.updatePos(cursor.getPos() + 1);
                if (paramDelim == '=') {
                    paramValue = this.tokenParser.parseToken(buffer, cursor, VALUE_DELIMS);
                    if (!cursor.atEnd()) {
                        cursor.updatePos(cursor.getPos() + 1);
                    }
                }
            }
            cookie.setAttribute(paramName, paramValue);
            attribMap.put(paramName, paramValue);
        }
        if (attribMap.containsKey("max-age")) {
            attribMap.remove("expires");
        }
        for (Map.Entry entry : attribMap.entrySet()) {
            String paramName = (String)entry.getKey();
            String paramValue = (String)entry.getValue();
            CookieAttributeHandler handler2 = this.attribHandlerMap.get(paramName);
            if (handler2 == null) continue;
            handler2.parse(cookie, paramValue);
        }
        return Collections.singletonList(cookie);
    }

    @Override
    public final void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        for (CookieAttributeHandler handler2 : this.attribHandlers) {
            handler2.validate(cookie, origin);
        }
    }

    @Override
    public final boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        for (CookieAttributeHandler handler2 : this.attribHandlers) {
            if (handler2.match(cookie, origin)) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        List<Cookie> sortedCookies;
        Args.notEmpty(cookies, "List of cookies");
        if (cookies.size() > 1) {
            sortedCookies = new ArrayList<Cookie>(cookies);
            Collections.sort(sortedCookies, CookiePriorityComparator.INSTANCE);
        } else {
            sortedCookies = cookies;
        }
        CharArrayBuffer buffer = new CharArrayBuffer(20 * sortedCookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        for (int n = 0; n < sortedCookies.size(); ++n) {
            Cookie cookie = sortedCookies.get(n);
            if (n > 0) {
                buffer.append(';');
                buffer.append(' ');
            }
            buffer.append(cookie.getName());
            String s = cookie.getValue();
            if (s == null) continue;
            buffer.append('=');
            if (this.containsSpecialChar(s)) {
                buffer.append('\"');
                for (int i = 0; i < s.length(); ++i) {
                    char ch = s.charAt(i);
                    if (ch == '\"' || ch == '\\') {
                        buffer.append('\\');
                    }
                    buffer.append(ch);
                }
                buffer.append('\"');
                continue;
            }
            buffer.append(s);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add(new BufferedHeader(buffer));
        return headers;
    }

    boolean containsSpecialChar(CharSequence s) {
        return this.containsChars(s, SPECIAL_CHARS);
    }

    boolean containsChars(CharSequence s, BitSet chars) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!chars.get(ch)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final int getVersion() {
        return 0;
    }

    @Override
    public final Header getVersionHeader() {
        return null;
    }
}

