/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.inline.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsFunctionScope;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.inline.context.NamingContext;
import org.jetbrains.kotlin.js.inline.util.CollectUtilsKt;
import org.jetbrains.kotlin.js.inline.util.rewriters.LabelNameRefreshingVisitor;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a4\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f\u001a\u0016\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"aliasArgumentsIfNeeded", "", "context", "Lorg/jetbrains/kotlin/js/inline/context/NamingContext;", "arguments", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "parameters", "Lorg/jetbrains/kotlin/js/backend/ast/JsParameter;", "source", "", "refreshLabelNames", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "node", "scope", "Lorg/jetbrains/kotlin/js/backend/ast/JsScope;", "renameLocalNames", "function", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "js.translator"})
public final class NamingUtilsKt {
    public static final void aliasArgumentsIfNeeded(@NotNull NamingContext context2, @NotNull List<? extends JsExpression> arguments2, @NotNull List<JsParameter> parameters2, @Nullable Object source) {
        Object object;
        HasMetadata param;
        boolean bl;
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        boolean bl2 = bl = arguments2.size() <= parameters2.size();
        if (!bl) {
            boolean bl3 = false;
            String string2 = "arguments.size (" + arguments2.size() + ") should be less or equal to parameters.size (" + parameters2.size() + ')';
            throw new IllegalArgumentException(string2.toString());
        }
        List defaultParams = new ArrayList();
        for (Pair object22 : CollectionsKt.zip((Iterable)arguments2, (Iterable)parameters2)) {
            JsName jsName;
            JsExpression arg = (JsExpression)object22.component1();
            param = (JsParameter)object22.component2();
            if (JsAstUtils.isUndefinedExpression(arg)) {
                object = defaultParams;
                object.add(param);
                continue;
            }
            JsName jsName2 = ((JsParameter)param).getName();
            Intrinsics.checkNotNullExpressionValue(jsName2, "param.name");
            JsName paramName = jsName2;
            JsName $this$aliasArgumentsIfNeeded_u24lambda_u2d1 = jsName = JsScope.declareTemporaryName(paramName.getIdent());
            boolean bl4 = false;
            Intrinsics.checkNotNullExpressionValue($this$aliasArgumentsIfNeeded_u24lambda_u2d1, "");
            MetadataProperties.setStaticRef($this$aliasArgumentsIfNeeded_u24lambda_u2d1, arg);
            context2.newVar($this$aliasArgumentsIfNeeded_u24lambda_u2d1, arg.deepCopy(), source);
            JsNameRef jsNameRef = jsName.makeRef();
            Intrinsics.checkNotNullExpressionValue(jsNameRef, "declareTemporaryName(par\u2026urce)\n        }.makeRef()");
            JsNameRef replacement = jsNameRef;
            replacement.setSource(arg.getSource());
            context2.replaceName(paramName, replacement);
        }
        Iterator iterator2 = defaultParams;
        Iterable iterable = parameters2.subList(arguments2.size(), parameters2.size());
        CollectionsKt.addAll(iterator2, iterable);
        for (JsParameter jsParameter : defaultParams) {
            param = jsParameter.getName();
            Intrinsics.checkNotNullExpressionValue(param, "defaultParam.name");
            HasMetadata paramName = param;
            object = JsScope.declareTemporaryName(((JsName)paramName).getIdent());
            Intrinsics.checkNotNullExpressionValue(object, "declareTemporaryName(paramName.ident)");
            Object freshName = object;
            ((HasMetadata)freshName).copyMetadataFrom(paramName);
            NamingContext.newVar$default(context2, (JsName)freshName, null, source, 2, null);
            object = ((JsName)freshName).makeRef();
            Intrinsics.checkNotNullExpressionValue(object, "freshName.makeRef()");
            context2.replaceName((JsName)paramName, (JsNameRef)object);
        }
    }

    public static final void renameLocalNames(@NotNull NamingContext context2, @NotNull JsFunction function2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(function2, "function");
        JsBlock jsBlock = function2.getBody();
        Intrinsics.checkNotNullExpressionValue(jsBlock, "function.body");
        for (JsName name2 : CollectUtilsKt.collectDefinedNames(jsBlock)) {
            JsName jsName;
            JsName $this$renameLocalNames_u24lambda_u2d2 = jsName = JsScope.declareTemporaryName(name2.getIdent());
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue($this$renameLocalNames_u24lambda_u2d2, "");
            MetadataProperties.setStaticRef($this$renameLocalNames_u24lambda_u2d2, MetadataProperties.getStaticRef(name2));
            HasMetadata hasMetadata = jsName;
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "declareTemporaryName(nam\u2026ticRef = name.staticRef }");
            JsName temporaryName = hasMetadata;
            hasMetadata = temporaryName.makeRef();
            Intrinsics.checkNotNullExpressionValue(hasMetadata, "temporaryName.makeRef()");
            context2.replaceName(name2, (JsNameRef)hasMetadata);
        }
    }

    @NotNull
    public static final JsNode refreshLabelNames(@NotNull JsNode node, @NotNull JsScope scope2) {
        Intrinsics.checkNotNullParameter(node, "node");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        if (!(scope2 instanceof JsFunctionScope)) {
            throw new AssertionError((Object)"JsFunction is expected to have JsFunctionScope");
        }
        LabelNameRefreshingVisitor visitor2 = new LabelNameRefreshingVisitor((JsFunctionScope)scope2);
        JsNode jsNode = visitor2.accept(node);
        Intrinsics.checkNotNullExpressionValue(jsNode, "visitor.accept(node)");
        return jsNode;
    }
}

