/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.backend.js.JsIntrinsics;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsLoweringUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.CallsTransformer;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.NumberOperatorCallsTransformerKt;
import org.jetbrains.kotlin.ir.backend.js.lower.calls.SimpleMemberKey;
import org.jetbrains.kotlin.ir.backend.js.utils.OperatorNames;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0011\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0015H\u0002J\u0018\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\"\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0002\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000eH\u0002J\u0010\u0010!\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0018\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010'\u001a\u00020\u001fH\u0016J\u0010\u0010(\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010)\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010,\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010-\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\rH\u0002J(\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0002J#\u0010\u001b\u001a\u00020\u0011*\u00020\u001d2\u0012\u00101\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e02\"\u00020\u000e\u00a2\u0006\u0002\u00103R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\t\u001a\u001e\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f0\nj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/NumberOperatorCallsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/CallsTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "intrinsics", "Lorg/jetbrains/kotlin/ir/backend/js/JsIntrinsics;", "irBuiltIns", "Lorg/jetbrains/kotlin/ir/IrBuiltIns;", "memberToTransformer", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/SimpleMemberKey;", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/MemberToTransformer;", "booleanNegate", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "e", "buildInt", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrConstImpl;", "", "v", "convertResultToPrimitiveType", "type", "Lorg/jetbrains/kotlin/ir/types/IrType;", "irBinaryOp", "call", "intrinsic", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "toInt32", "", "toBoolean", "transformAdd", "transformCrement", "correspondingBinaryOp", "transformDecrement", "transformDiv", "transformFunctionAccess", "doNotIntrinsify", "transformHashCode", "transformIncrement", "transformMul", "transformRangeTo", "transformRem", "transformSub", "transformUnaryMinus", "withLongCoercion", "default", "arguments", "", "(Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;[Lorg/jetbrains/kotlin/ir/expressions/IrExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "BinaryOp", "backend.js"})
public final class NumberOperatorCallsTransformer
implements CallsTransformer {
    @NotNull
    private final JsIntrinsics intrinsics;
    @NotNull
    private final IrBuiltIns irBuiltIns;
    @NotNull
    private final HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>> memberToTransformer;

    /*
     * WARNING - void declaration
     */
    public NumberOperatorCallsTransformer(@NotNull JsIrBackendContext context2) {
        void $this$memberToTransformer_u24lambda_u2d3;
        HashMap hashMap;
        Intrinsics.checkNotNullParameter(context2, "context");
        this.intrinsics = context2.getIntrinsics();
        this.irBuiltIns = context2.getIrBuiltIns();
        HashMap hashMap2 = hashMap = new HashMap();
        NumberOperatorCallsTransformer numberOperatorCallsTransformer = this;
        boolean bl = false;
        Iterator<IrType> iterator2 = this.irBuiltIns;
        IrBuiltIns $this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0 = iterator2;
        boolean bl2 = false;
        IrType[] irTypeArray = new IrType[]{$this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0.getIntType(), $this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0.getShortType(), $this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0.getByteType(), $this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0.getFloatType(), $this$memberToTransformer_u24lambda_u2d3_u24lambda_u2d0.getDoubleType()};
        List<IrType> primitiveNumbers = CollectionsKt.listOf(irTypeArray);
        iterator2 = primitiveNumbers.iterator();
        while (iterator2.hasNext()) {
            IrType type2 = (IrType)iterator2.next();
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getUNARY_PLUS(), this.intrinsics.getJsUnaryPlus());
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getUNARY_MINUS(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformUnaryMinus((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformUnaryMinus(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformUnaryMinus";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            });
        }
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, this.irBuiltIns.getStringType(), OperatorNames.INSTANCE.getADD(), this.intrinsics.getJsPlus());
        Iterator<IrType> it = iterator2 = this.irBuiltIns.getIntType();
        boolean bl3 = false;
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getSHL(), this.intrinsics.getJsBitShiftL());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getSHR(), this.intrinsics.getJsBitShiftR());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getSHRU(), this.intrinsics.getJsBitShiftRU());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getAND(), this.intrinsics.getJsBitAnd());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getOR(), this.intrinsics.getJsBitOr());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getXOR(), this.intrinsics.getJsBitXor());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getINV(), this.intrinsics.getJsBitNot());
        it = iterator2 = this.irBuiltIns.getBooleanType();
        boolean bl4 = false;
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getAND(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>(this){
            final /* synthetic */ NumberOperatorCallsTransformer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter(call2, "call");
                return NumberOperatorCallsTransformer.access$toBoolean(this.this$0, IrUtilsKt.irCall$default(call2, NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getJsBitAnd(), true, false, null, null, 56, null));
            }
        });
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getOR(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>(this){
            final /* synthetic */ NumberOperatorCallsTransformer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter(call2, "call");
                return NumberOperatorCallsTransformer.access$toBoolean(this.this$0, IrUtilsKt.irCall$default(call2, NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getJsBitOr(), true, false, null, null, 56, null));
            }
        });
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getXOR(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>(this){
            final /* synthetic */ NumberOperatorCallsTransformer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter(call2, "call");
                return NumberOperatorCallsTransformer.access$toBoolean(this.this$0, IrUtilsKt.irCall$default(call2, NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getJsBitXor(), true, false, null, null, 56, null));
            }
        });
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), OperatorNames.INSTANCE.getNOT(), this.intrinsics.getJsNot());
        CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, (IrType)((Object)it), NumberOperatorCallsTransformerKt.access$getHASH_CODE_NAME$p(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>(this){
            final /* synthetic */ NumberOperatorCallsTransformer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final IrExpression invoke(@NotNull IrFunctionAccessExpression call2) {
                Intrinsics.checkNotNullParameter(call2, "call");
                IrExpression irExpression = call2.getDispatchReceiver();
                Intrinsics.checkNotNull(irExpression);
                return NumberOperatorCallsTransformer.access$toInt32(this.this$0, irExpression);
            }
        });
        for (IrType type2 : primitiveNumbers) {
            Name name2 = Name.identifier("rangeTo");
            Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"rangeTo\")");
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, name2, (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformRangeTo((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformRangeTo(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformRangeTo";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            });
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, NumberOperatorCallsTransformerKt.access$getHASH_CODE_NAME$p(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformHashCode((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformHashCode(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformHashCode";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            });
        }
        for (IrType type2 : primitiveNumbers) {
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getINC(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformIncrement((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformIncrement(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformIncrement";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            });
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getDEC(), (Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformDecrement((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformDecrement(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformDecrement";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            });
        }
        for (IrType type2 : primitiveNumbers) {
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getADD(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformAdd((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformAdd(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformAdd";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getSUB(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformSub((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformSub(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformSub";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getMUL(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformMul((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformMul(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformMul";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getDIV(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformDiv((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformDiv(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformDiv";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getMOD(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformRem((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformRem(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformRem";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
            CallsLoweringUtilsKt.add((HashMap<SimpleMemberKey, Function1<IrFunctionAccessExpression, IrExpression>>)$this$memberToTransformer_u24lambda_u2d3, type2, OperatorNames.INSTANCE.getREM(), this.withLongCoercion((Function1<? super IrFunctionAccessExpression, ? extends IrExpression>)new Function1<IrFunctionAccessExpression, IrExpression>((Object)this){

                @NotNull
                public final IrExpression invoke(@NotNull IrFunctionAccessExpression p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return NumberOperatorCallsTransformer.access$transformRem((NumberOperatorCallsTransformer)this.receiver, p0);
                }

                @NotNull
                public final String getSignature() {
                    return "transformRem(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)Lorg/jetbrains/kotlin/ir/expressions/IrExpression;";
                }

                @NotNull
                public final String getName() {
                    return "transformRem";
                }

                @NotNull
                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(NumberOperatorCallsTransformer.class);
                }
            }));
        }
        Unit unit2 = Unit.INSTANCE;
        numberOperatorCallsTransformer.memberToTransformer = hashMap;
    }

    private final IrConstImpl<Integer> buildInt(int v) {
        return JsIrBuilder.INSTANCE.buildInt(this.irBuiltIns.getIntType(), v);
    }

    @Override
    @NotNull
    public IrExpression transformFunctionAccess(@NotNull IrFunctionAccessExpression call2, boolean doNotIntrinsify) {
        Intrinsics.checkNotNullParameter(call2, "call");
        IrFunction function2 = ((IrFunctionSymbol)call2.getSymbol()).getOwner();
        IrValueParameter irValueParameter = function2.getDispatchReceiverParameter();
        if (irValueParameter != null) {
            IrValueParameter irValueParameter2;
            IrValueParameter it = irValueParameter2 = irValueParameter;
            boolean bl = false;
            SimpleMemberKey key = new SimpleMemberKey(it.getType(), function2.getName());
            Function1<IrFunctionAccessExpression, IrExpression> function1 = this.memberToTransformer.get(key);
            if (function1 != null) {
                Function1<IrFunctionAccessExpression, IrExpression> function12;
                Function1<IrFunctionAccessExpression, IrExpression> it2 = function12 = function1;
                boolean bl2 = false;
                return it2.invoke(call2);
            }
        }
        return call2;
    }

    private final IrExpression transformRangeTo(IrFunctionAccessExpression call2) {
        IrType irType;
        if (call2.getValueArgumentsCount() != 1) {
            return call2;
        }
        IrType $this$transformRangeTo_u24lambda_u2d6 = irType = ((IrFunctionSymbol)call2.getSymbol()).getOwner().getValueParameters().get(0).getType();
        boolean bl = false;
        return IrTypePredicatesKt.isByte($this$transformRangeTo_u24lambda_u2d6) || IrTypePredicatesKt.isShort($this$transformRangeTo_u24lambda_u2d6) || IrTypePredicatesKt.isInt($this$transformRangeTo_u24lambda_u2d6) ? (IrFunctionAccessExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsNumberRangeToNumber(), true, false, null, null, 56, null) : (IrTypePredicatesKt.isLong($this$transformRangeTo_u24lambda_u2d6) ? (IrFunctionAccessExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsNumberRangeToLong(), true, false, null, null, 56, null) : call2);
    }

    private final IrExpression transformHashCode(IrFunctionAccessExpression call2) {
        IrExpression irExpression;
        IrType irType;
        IrValueParameter irValueParameter = ((IrFunctionSymbol)call2.getSymbol()).getOwner().getDispatchReceiverParameter();
        Intrinsics.checkNotNull(irValueParameter);
        IrType $this$transformHashCode_u24lambda_u2d7 = irType = irValueParameter.getType();
        boolean bl = false;
        if (IrTypePredicatesKt.isByte($this$transformHashCode_u24lambda_u2d7) || IrTypePredicatesKt.isShort($this$transformHashCode_u24lambda_u2d7) || IrTypePredicatesKt.isInt($this$transformHashCode_u24lambda_u2d7)) {
            IrExpression irExpression2 = call2.getDispatchReceiver();
            irExpression = irExpression2;
            Intrinsics.checkNotNull(irExpression2);
        } else {
            irExpression = IrTypePredicatesKt.isFloat($this$transformHashCode_u24lambda_u2d7) || IrTypePredicatesKt.isDouble($this$transformHashCode_u24lambda_u2d7) ? (IrExpression)IrUtilsKt.irCall$default(call2, this.intrinsics.getJsGetNumberHashCode(), true, false, null, null, 56, null) : (IrExpression)call2;
        }
        return irExpression;
    }

    private final IrExpression irBinaryOp(IrFunctionAccessExpression call2, IrSimpleFunctionSymbol intrinsic, boolean toInt32) {
        IrCall newCall2 = IrUtilsKt.irCall$default(call2, intrinsic, true, false, null, null, 56, null);
        if (toInt32) {
            return this.toInt32(newCall2);
        }
        return newCall2;
    }

    static /* synthetic */ IrExpression irBinaryOp$default(NumberOperatorCallsTransformer numberOperatorCallsTransformer, IrFunctionAccessExpression irFunctionAccessExpression, IrSimpleFunctionSymbol irSimpleFunctionSymbol, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return numberOperatorCallsTransformer.irBinaryOp(irFunctionAccessExpression, irSimpleFunctionSymbol, bl);
    }

    private final IrExpression transformAdd(IrFunctionAccessExpression call2) {
        return this.irBinaryOp(call2, this.intrinsics.getJsPlus(), new BinaryOp(call2).canAddOrSubOverflow());
    }

    private final IrExpression transformSub(IrFunctionAccessExpression call2) {
        return this.irBinaryOp(call2, this.intrinsics.getJsMinus(), new BinaryOp(call2).canAddOrSubOverflow());
    }

    private final IrExpression transformMul(IrFunctionAccessExpression call2) {
        BinaryOp binaryOp;
        BinaryOp $this$transformMul_u24lambda_u2d8 = binaryOp = new BinaryOp(call2);
        boolean bl = false;
        return IrTypePredicatesKt.isInt($this$transformMul_u24lambda_u2d8.getResult()) ? (IrTypePredicatesKt.isInt($this$transformMul_u24lambda_u2d8.getLhs()) && IrTypePredicatesKt.isInt($this$transformMul_u24lambda_u2d8.getRhs()) ? NumberOperatorCallsTransformer.irBinaryOp$default(this, call2, this.intrinsics.getJsImul(), false, 4, null) : this.irBinaryOp(call2, this.intrinsics.getJsMult(), true)) : this.irBinaryOp(call2, this.intrinsics.getJsMult(), false);
    }

    private final IrExpression transformDiv(IrFunctionAccessExpression call2) {
        return this.irBinaryOp(call2, this.intrinsics.getJsDiv(), IrTypePredicatesKt.isInt(new BinaryOp(call2).getResult()));
    }

    private final IrExpression transformRem(IrFunctionAccessExpression call2) {
        return NumberOperatorCallsTransformer.irBinaryOp$default(this, call2, this.intrinsics.getJsMod(), false, 4, null);
    }

    private final IrExpression transformIncrement(IrFunctionAccessExpression call2) {
        return this.transformCrement(call2, this.intrinsics.getJsPlus());
    }

    private final IrExpression transformDecrement(IrFunctionAccessExpression call2) {
        return this.transformCrement(call2, this.intrinsics.getJsMinus());
    }

    private final IrExpression transformCrement(IrFunctionAccessExpression call2, IrSimpleFunctionSymbol correspondingBinaryOp) {
        IrCall irCall;
        IrCall $this$transformCrement_u24lambda_u2d9 = irCall = IrUtilsKt.irCall$default(call2, correspondingBinaryOp, true, false, null, null, 56, null);
        boolean bl = false;
        $this$transformCrement_u24lambda_u2d9.putValueArgument(1, this.buildInt(1));
        IrCall operation = irCall;
        return this.convertResultToPrimitiveType(operation, call2.getType());
    }

    private final IrExpression transformUnaryMinus(IrFunctionAccessExpression call2) {
        return this.convertResultToPrimitiveType(IrUtilsKt.irCall$default(call2, this.intrinsics.getJsUnaryMinus(), true, false, null, null, 56, null), call2.getType());
    }

    private final IrExpression convertResultToPrimitiveType(IrExpression e, IrType type2) {
        IrExpression irExpression;
        if (IrTypePredicatesKt.isInt(type2)) {
            irExpression = this.toInt32(e);
        } else if (IrTypePredicatesKt.isByte(type2)) {
            IrExpression[] irExpressionArray = new IrExpression[]{e};
            irExpression = this.call(this.intrinsics.getJsNumberToByte(), irExpressionArray);
        } else if (IrTypePredicatesKt.isShort(type2)) {
            IrExpression[] irExpressionArray = new IrExpression[]{e};
            irExpression = this.call(this.intrinsics.getJsNumberToShort(), irExpressionArray);
        } else {
            irExpression = e;
        }
        return irExpression;
    }

    private final Function1<IrFunctionAccessExpression, IrExpression> withLongCoercion(Function1<? super IrFunctionAccessExpression, ? extends IrExpression> function1) {
        return new Function1<IrFunctionAccessExpression, IrExpression>(this, function1){
            final /* synthetic */ NumberOperatorCallsTransformer this$0;
            final /* synthetic */ Function1<IrFunctionAccessExpression, IrExpression> $default;
            {
                this.this$0 = $receiver;
                this.$default = $default;
                super(1);
            }

            /*
             * Unable to fully structure code
             */
            @NotNull
            public final IrExpression invoke(@NotNull IrFunctionAccessExpression call) {
                block11: {
                    block13: {
                        block12: {
                            Intrinsics.checkNotNullParameter(call, "call");
                            v0 = var2_2 = call.getValueArgumentsCount() == 1;
                            if (_Assertions.ENABLED && !var2_2) {
                                var3_4 = "Assertion failed";
                                throw new AssertionError((Object)var3_4);
                            }
                            v1 = call.getValueArgument(0);
                            Intrinsics.checkNotNull(v1);
                            arg = v1;
                            actualCall = call;
                            if (!IrTypePredicatesKt.isLong(arg.getType())) break block11;
                            v2 = call.getDispatchReceiver();
                            Intrinsics.checkNotNull(v2);
                            receiverType = v2.getType();
                            if (!IrTypePredicatesKt.isDouble(receiverType)) break block12;
                            var6_10 = var5_7 = new IrCallImpl(call.getStartOffset(), call.getEndOffset(), ((IrSimpleFunction)NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getLongToDouble().getOwner()).getReturnType(), NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getLongToDouble(), 0, 0, null, null, 192, null);
                            var24_13 = 0;
                            var23_16 = call;
                            $i$a$-apply-NumberOperatorCallsTransformer$withLongCoercion$1$1 = false;
                            $this$invoke_u24lambda_u2d0.setDispatchReceiver(arg);
                            var25_23 = Unit.INSTANCE;
                            var23_16.putValueArgument(var24_13, var5_7);
                            break block11;
                        }
                        if (!IrTypePredicatesKt.isFloat(receiverType)) break block13;
                        $this$invoke_u24lambda_u2d0 = var5_8 = new IrCallImpl(call.getStartOffset(), call.getEndOffset(), ((IrSimpleFunction)NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getLongToFloat().getOwner()).getReturnType(), NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getLongToFloat(), 0, 0, null, null, 192, null);
                        var24_14 = 0;
                        var23_17 = call;
                        $i$a$-apply-NumberOperatorCallsTransformer$withLongCoercion$1$2 = false;
                        $this$invoke_u24lambda_u2d1.setDispatchReceiver(arg);
                        var25_24 = Unit.INSTANCE;
                        var23_17.putValueArgument(var24_14, var5_8);
                        break block11;
                    }
                    if (IrTypePredicatesKt.isLong(receiverType)) break block11;
                    $this$invoke_u24lambda_u2d1 = var5_9 = new IrCallImpl(call.getStartOffset(), call.getEndOffset(), ((IrSimpleFunction)NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getJsNumberToLong().getOwner()).getReturnType(), NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getJsNumberToLong(), 0, 1, null, null, 192, null);
                    var23_18 = call;
                    $i$a$-apply-NumberOperatorCallsTransformer$withLongCoercion$1$3 = false;
                    $this$invoke_u24lambda_u2d2.putValueArgument(0, call.getDispatchReceiver());
                    var24_15 = Unit.INSTANCE;
                    var23_18.setDispatchReceiver(var5_9);
                    declaration = (IrSimpleFunction)((IrFunctionSymbol)call.getSymbol()).getOwner();
                    $this$filterIsInstance$iv = ((IrClass)NumberOperatorCallsTransformer.access$getIntrinsics$p(this.this$0).getLongClassSymbol().getOwner()).getDeclarations();
                    $i$f$filterIsInstance = false;
                    var9_26 = $this$filterIsInstance$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterIsInstanceTo = false;
                    for (T element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                        if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filterIsInstance$iv = (List)destination$iv$iv;
                    $i$f$single = false;
                    single$iv = null;
                    found$iv = false;
                    for (T element$iv : $this$single$iv) {
                        block10: {
                            member = (IrSimpleFunction)element$iv;
                            $i$a$-single-NumberOperatorCallsTransformer$withLongCoercion$1$replacement$1 = false;
                            if (!Intrinsics.areEqual(member.getName().asString(), declaration.getName().asString()) || member.getValueParameters().size() != declaration.getValueParameters().size()) ** GOTO lbl-1000
                            $this$all$iv = CollectionsKt.zip((Iterable)member.getValueParameters(), (Iterable)declaration.getValueParameters());
                            $i$f$all = false;
                            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                                v3 = true;
                            } else {
                                for (T element$iv : $this$all$iv) {
                                    $dstr$a$b = (Pair)element$iv;
                                    $i$a$-all-NumberOperatorCallsTransformer$withLongCoercion$1$replacement$1$1 = false;
                                    a = (IrValueParameter)$dstr$a$b.component1();
                                    b = (IrValueParameter)$dstr$a$b.component2();
                                    if (Intrinsics.areEqual(a.getType(), b.getType())) continue;
                                    v3 = false;
                                    break block10;
                                }
                                v3 = true;
                            }
                        }
                        if (v3) {
                            v4 = true;
                        } else lbl-1000:
                        // 2 sources

                        {
                            v4 = false;
                        }
                        if (!v4) continue;
                        if (found$iv) {
                            throw new IllegalArgumentException("Collection contains more than one matching element.");
                        }
                        single$iv = element$iv;
                        found$iv = true;
                    }
                    if (!found$iv) {
                        throw new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    replacement = ((IrSimpleFunction)single$iv).getSymbol();
                    actualCall = IrUtilsKt.irCall$default(call, replacement, false, false, null, null, 60, null);
                }
                v5 = actualCall.getDispatchReceiver();
                Intrinsics.checkNotNull(v5);
                return IrTypePredicatesKt.isLong(v5.getType()) != false ? (IrExpression)actualCall : this.$default.invoke(actualCall);
            }
        };
    }

    @NotNull
    public final IrCall call(@NotNull IrSimpleFunctionSymbol $this$call, IrExpression ... arguments2) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter($this$call, "<this>");
        Intrinsics.checkNotNullParameter(arguments2, "arguments");
        IrCall $this$call_u24lambda_u2d10 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, $this$call, ((IrSimpleFunction)$this$call.getOwner()).getReturnType(), null, null, 12, null);
        boolean bl = false;
        IrExpression[] irExpressionArray = arguments2;
        int n = irExpressionArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = i;
            IrExpression arg = irExpressionArray[i];
            $this$call_u24lambda_u2d10.putValueArgument(idx, arg);
        }
        return irCall;
    }

    private final IrCall booleanNegate(IrExpression e) {
        IrCall irCall;
        IrCall $this$booleanNegate_u24lambda_u2d11 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.intrinsics.getJsNot(), this.irBuiltIns.getBooleanType(), null, null, 12, null);
        boolean bl = false;
        $this$booleanNegate_u24lambda_u2d11.putValueArgument(0, e);
        return irCall;
    }

    private final IrCall toBoolean(IrExpression e) {
        return this.booleanNegate(this.booleanNegate(e));
    }

    private final IrCall toInt32(IrExpression e) {
        IrCall irCall;
        IrCall $this$toInt32_u24lambda_u2d12 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.intrinsics.getJsBitOr(), this.irBuiltIns.getIntType(), null, null, 12, null);
        boolean bl = false;
        $this$toInt32_u24lambda_u2d12.putValueArgument(0, e);
        $this$toInt32_u24lambda_u2d12.putValueArgument(1, this.buildInt(0));
        return irCall;
    }

    public static final /* synthetic */ JsIntrinsics access$getIntrinsics$p(NumberOperatorCallsTransformer $this) {
        return $this.intrinsics;
    }

    public static final /* synthetic */ IrCall access$toBoolean(NumberOperatorCallsTransformer $this, IrExpression e) {
        return $this.toBoolean(e);
    }

    public static final /* synthetic */ IrCall access$toInt32(NumberOperatorCallsTransformer $this, IrExpression e) {
        return $this.toInt32(e);
    }

    public static final /* synthetic */ IrExpression access$transformUnaryMinus(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformUnaryMinus(call2);
    }

    public static final /* synthetic */ IrExpression access$transformRangeTo(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformRangeTo(call2);
    }

    public static final /* synthetic */ IrExpression access$transformHashCode(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformHashCode(call2);
    }

    public static final /* synthetic */ IrExpression access$transformIncrement(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformIncrement(call2);
    }

    public static final /* synthetic */ IrExpression access$transformDecrement(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformDecrement(call2);
    }

    public static final /* synthetic */ IrExpression access$transformAdd(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformAdd(call2);
    }

    public static final /* synthetic */ IrExpression access$transformSub(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformSub(call2);
    }

    public static final /* synthetic */ IrExpression access$transformMul(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformMul(call2);
    }

    public static final /* synthetic */ IrExpression access$transformDiv(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformDiv(call2);
    }

    public static final /* synthetic */ IrExpression access$transformRem(NumberOperatorCallsTransformer $this, IrFunctionAccessExpression call2) {
        return $this.transformRem(call2);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/calls/NumberOperatorCallsTransformer$BinaryOp;", "", "call", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "(Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;)V", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "getFunction", "()Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "lhs", "Lorg/jetbrains/kotlin/ir/types/IrType;", "getLhs", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "name", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "result", "getResult", "rhs", "getRhs", "canAddOrSubOverflow", "", "backend.js"})
    public static final class BinaryOp {
        @NotNull
        private final IrFunction function;
        @NotNull
        private final Name name;
        @NotNull
        private final IrType lhs;
        @NotNull
        private final IrType rhs;
        @NotNull
        private final IrType result;

        public BinaryOp(@NotNull IrFunctionAccessExpression call2) {
            Intrinsics.checkNotNullParameter(call2, "call");
            this.function = ((IrFunctionSymbol)call2.getSymbol()).getOwner();
            this.name = this.function.getName();
            IrValueParameter irValueParameter = this.function.getDispatchReceiverParameter();
            Intrinsics.checkNotNull(irValueParameter);
            this.lhs = irValueParameter.getType();
            this.rhs = this.function.getValueParameters().get(0).getType();
            this.result = this.function.getReturnType();
        }

        @NotNull
        public final IrFunction getFunction() {
            return this.function;
        }

        @NotNull
        public final Name getName() {
            return this.name;
        }

        @NotNull
        public final IrType getLhs() {
            return this.lhs;
        }

        @NotNull
        public final IrType getRhs() {
            return this.rhs;
        }

        @NotNull
        public final IrType getResult() {
            return this.result;
        }

        public final boolean canAddOrSubOverflow() {
            return IrTypePredicatesKt.isInt(this.result) && (IrTypePredicatesKt.isInt(this.lhs) || IrTypePredicatesKt.isInt(this.rhs));
        }
    }
}

