/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.BodyLoweringPass;
import org.jetbrains.kotlin.backend.common.CommonBackendContext;
import org.jetbrains.kotlin.backend.common.LowerKt;
import org.jetbrains.kotlin.backend.common.ir.IrInlineUtilsKt;
import org.jetbrains.kotlin.backend.common.lower.LowerUtilsKt;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.DescriptorVisibility;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrElementBase;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderWithScope;
import org.jetbrains.kotlin.ir.builders.IrElementBuilder;
import org.jetbrains.kotlin.ir.builders.IrElementBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.DeclarationBuildersKt;
import org.jetbrains.kotlin.ir.builders.declarations.IrClassBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrDeclarationBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrFunctionBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrPropertyBuilder;
import org.jetbrains.kotlin.ir.builders.declarations.IrValueParameterBuilder;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationContainer;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrFactory;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetFieldImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrInstanceInitializerCallImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoid;
import org.jetbrains.kotlin.ir.visitors.IrElementTransformerVoidKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0003\u0010\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;", "Lorg/jetbrains/kotlin/backend/common/BodyLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;", "(Lorg/jetbrains/kotlin/backend/common/CommonBackendContext;)V", "nothingType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "stringType", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "irBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "CallableReferenceBuilder", "Companion", "ReferenceTransformer", "backend.js"})
public final class CallableReferenceLowering
implements BodyLoweringPass {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonBackendContext context;
    @NotNull
    private final IrType nothingType;
    @NotNull
    private final IrType stringType;
    @NotNull
    private static final Name BOUND_RECEIVER_NAME;

    public CallableReferenceLowering(@NotNull CommonBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        this.context = context2;
        this.nothingType = this.context.getIrBuiltIns().getNothingType();
        this.stringType = this.context.getIrBuiltIns().getStringType();
    }

    @Override
    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter(irFile, "irFile");
        LowerKt.runOnFilePostfix$default(this, irFile, true, false, 4, null);
    }

    @Override
    public void lower(@NotNull IrBody irBody, @NotNull IrDeclaration container) {
        Intrinsics.checkNotNullParameter(irBody, "irBody");
        Intrinsics.checkNotNullParameter(container, "container");
        IrDeclarationParent irDeclarationParent = container instanceof IrDeclarationParent ? (IrDeclarationParent)((Object)container) : null;
        IrDeclarationParent realContainer = irDeclarationParent == null ? container.getParent() : irDeclarationParent;
        IrElementTransformerVoidKt.transformChildrenVoid(irBody, new ReferenceTransformer(realContainer));
    }

    static {
        Name name2 = Name.identifier("$boundThis");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"\\$boundThis\")");
        BOUND_RECEIVER_NAME = name2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J$\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\u000eH\u0016J\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$ReferenceTransformer;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementTransformerVoid;", "container", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationParent;)V", "buildFunctionReference", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionReference;", "buildLambdaReference", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionExpression;", "visitBody", "Lorg/jetbrains/kotlin/ir/expressions/IrBody;", "body", "visitFunctionExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "visitFunctionReference", "backend.js"})
    private final class ReferenceTransformer
    extends IrElementTransformerVoid {
        @NotNull
        private final IrDeclarationParent container;

        public ReferenceTransformer(IrDeclarationParent container) {
            Intrinsics.checkNotNullParameter(CallableReferenceLowering.this, "this$0");
            Intrinsics.checkNotNullParameter(container, "container");
            this.container = container;
        }

        @Override
        @NotNull
        public IrBody visitBody(@NotNull IrBody body2) {
            Intrinsics.checkNotNullParameter(body2, "body");
            return body2;
        }

        @Override
        @NotNull
        public IrExpression visitFunctionExpression(@NotNull IrFunctionExpression expression2) {
            IrElement[] irElementArray;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            IrSimpleFunction function2 = expression2.getFunction();
            Pair<IrClass, IrConstructor> pair = this.buildLambdaReference(function2, expression2);
            IrClass clazz = pair.component1();
            IrConstructor ctor = pair.component2();
            clazz.setParent(this.container);
            IrFunctionExpression irFunctionExpression = expression2;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            IrFunctionExpression $this$visitFunctionExpression_u24lambda_u2d1 = irFunctionExpression;
            boolean bl = false;
            int vpCount = function2.isSuspend() ? 1 : 0;
            IrElement[] $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0 = irElementArray = new IrConstructorCallImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl2 = false;
            if (function2.isSuspend()) {
                $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.putValueArgument(0, IrConstImpl.Companion.constNull($this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1_u24lambda_u2d0.getEndOffset(), callableReferenceLowering2.context.getIrBuiltIns().getNothingNType()));
            }
            IrElement[] ctorCall = irElementArray;
            irElementArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionExpression_u24lambda_u2d1.getStartOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getEndOffset(), $this$visitFunctionExpression_u24lambda_u2d1.getType(), $this$visitFunctionExpression_u24lambda_u2d1.getOrigin(), CollectionsKt.listOf(irElementArray));
        }

        @Override
        @NotNull
        public IrExpression visitFunctionReference(@NotNull IrFunctionReference expression2) {
            IrElement[] irElementArray;
            IrFunctionReference irFunctionReference;
            IrFunctionReference irFunctionReference2;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            IrElementTransformerVoidKt.transformChildrenVoid(expression2, this);
            Pair<IrClass, IrConstructor> pair = this.buildFunctionReference(expression2);
            IrClass clazz = pair.component1();
            IrConstructor ctor = pair.component2();
            clazz.setParent(this.container);
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5 = irFunctionReference2 = expression2;
            boolean bl = false;
            IrFunctionReference $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2 = irFunctionReference = expression2;
            boolean bl2 = false;
            IrExpression irExpression = $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getDispatchReceiver();
            IrExpression boundReceiver = irExpression == null ? $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d2.getExtensionReceiver() : irExpression;
            int vpCount = boundReceiver != null ? 1 : 0;
            IrElement[] $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4 = irElementArray = new IrConstructorCallImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), ctor.getSymbol(), 0, 0, vpCount, JsStatementOrigins.CALLABLE_REFERENCE_CREATE.INSTANCE);
            boolean bl3 = false;
            IrExpression irExpression2 = boundReceiver;
            if (irExpression2 != null) {
                IrExpression irExpression3;
                IrExpression it = irExpression3 = irExpression2;
                boolean bl4 = false;
                $this$visitFunctionReference_u24lambda_u2d5_u24lambda_u2d4.putValueArgument(0, it);
            }
            IrElement[] ctorCall = irElementArray;
            irElementArray = new IrElement[]{clazz, (IrElement)ctorCall};
            return new IrCompositeImpl($this$visitFunctionReference_u24lambda_u2d5.getStartOffset(), $this$visitFunctionReference_u24lambda_u2d5.getEndOffset(), $this$visitFunctionReference_u24lambda_u2d5.getType(), $this$visitFunctionReference_u24lambda_u2d5.getOrigin(), CollectionsKt.listOf(irElementArray));
        }

        private final Pair<IrClass, IrConstructor> buildFunctionReference(IrFunctionReference expression2) {
            IrFunction target = ((IrFunctionSymbol)expression2.getSymbol()).getOwner();
            IrFunctionSymbol irFunctionSymbol = expression2.getReflectionTarget();
            IrFunction reflectionTarget = irFunctionSymbol == null ? target : irFunctionSymbol.getOwner();
            return new CallableReferenceBuilder(target, expression2, reflectionTarget).build();
        }

        private final Pair<IrClass, IrConstructor> buildLambdaReference(IrSimpleFunction function2, IrFunctionExpression expression2) {
            return new CallableReferenceBuilder(function2, expression2, null).build();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00150\u0014J\b\u0010\u0016\u001a\u00020\u0012H\u0002J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\u00020\"*\u00020\u001aH\u0002J\f\u0010#\u001a\u00020$*\u00020\u0015H\u0002J\f\u0010%\u001a\u00020\u001c*\u00020\u001aH\u0002J\f\u0010&\u001a\u00020\u001c*\u00020\u001aH\u0002J\f\u0010'\u001a\u00020\u001c*\u00020\u0012H\u0002R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$CallableReferenceBuilder;", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "reference", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "reflectionTarget", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;Lorg/jetbrains/kotlin/ir/expressions/IrExpression;Lorg/jetbrains/kotlin/ir/declarations/IrFunction;)V", "boundReceiverField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "isKReference", "", "isLambda", "()Z", "isSuspendLambda", "superClass", "Lorg/jetbrains/kotlin/ir/types/IrType;", "superFunctionInterface", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "build", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "buildReferenceClass", "createConstructor", "clazz", "createInvokeMethod", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "createNameProperty", "", "getValue", "Lorg/jetbrains/kotlin/ir/expressions/IrGetValue;", "d", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "buildInvoke", "Lorg/jetbrains/kotlin/ir/expressions/IrFunctionAccessExpression;", "countContextTypeParameters", "", "createFunctionReferenceInvokeMethod", "createLambdaInvokeMethod", "createReceiverField", "backend.js"})
    private final class CallableReferenceBuilder {
        @NotNull
        private final IrFunction function;
        @NotNull
        private final IrExpression reference;
        @Nullable
        private final IrFunction reflectionTarget;
        private final boolean isSuspendLambda;
        @NotNull
        private final IrType superClass;
        @Nullable
        private IrField boundReceiverField;
        @NotNull
        private final IrClass superFunctionInterface;
        private final boolean isKReference;

        public CallableReferenceBuilder(@NotNull IrFunction function2, @Nullable IrExpression reference, IrFunction reflectionTarget) {
            Intrinsics.checkNotNullParameter(CallableReferenceLowering.this, "this$0");
            Intrinsics.checkNotNullParameter(function2, "function");
            Intrinsics.checkNotNullParameter(reference, "reference");
            this.function = function2;
            this.reference = reference;
            this.reflectionTarget = reflectionTarget;
            this.isSuspendLambda = this.isLambda() && AdditionalIrUtilsKt.isSuspend(this.function);
            this.superClass = this.isSuspendLambda ? (IrType)IrUtilsKt.getDefaultType((IrClass)CallableReferenceLowering.this.context.getIr().getSymbols().getCoroutineImpl().getOwner()) : CallableReferenceLowering.this.context.getIrBuiltIns().getAnyType();
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.reference.getType());
            if (irClassSymbol == null) {
                throw new IllegalStateException("Expected functional type".toString());
            }
            this.superFunctionInterface = (IrClass)irClassSymbol.getOwner();
            this.isKReference = this.superFunctionInterface.getName().getIdentifier().charAt(0) == 'K';
        }

        private final boolean isLambda() {
            return this.reflectionTarget == null;
        }

        private final IrClass buildReferenceClass() {
            IrClass irClass2;
            IrClassBuilder irClassBuilder;
            IrFactory $this$buildClass$iv = CallableReferenceLowering.this.context.getIrFactory();
            boolean $i$f$buildClass = false;
            IrClassBuilder $this$buildClass_u24lambda_u2d1$iv = irClassBuilder = new IrClassBuilder();
            boolean bl = false;
            IrClassBuilder $this$buildReferenceClass_u24lambda_u2d0 = $this$buildClass_u24lambda_u2d1$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange($this$buildReferenceClass_u24lambda_u2d0, this.reference);
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.LOCAL;
            Intrinsics.checkNotNullExpressionValue(descriptorVisibility, "LOCAL");
            $this$buildReferenceClass_u24lambda_u2d0.setVisibility(descriptorVisibility);
            $this$buildReferenceClass_u24lambda_u2d0.setOrigin(this.isKReference || !this.isLambda() ? (IrDeclarationOrigin)Companion.FUNCTION_REFERENCE_IMPL.INSTANCE : (IrDeclarationOrigin)Companion.LAMBDA_IMPL.INSTANCE);
            $this$buildReferenceClass_u24lambda_u2d0.setName(SpecialNames.NO_NAME_PROVIDED);
            IrClass $this$buildReferenceClass_u24lambda_u2d1 = irClass2 = DeclarationBuildersKt.buildClass($this$buildClass$iv, $this$buildClass_u24lambda_u2d1$iv);
            boolean bl3 = false;
            IrType[] irTypeArray = new IrType[]{this.superClass, this.reference.getType()};
            $this$buildReferenceClass_u24lambda_u2d1.setSuperTypes(CollectionsKt.listOf(irTypeArray));
            org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.createImplicitParameterDeclarationWithWrappedDescriptor($this$buildReferenceClass_u24lambda_u2d1);
            this.createReceiverField($this$buildReferenceClass_u24lambda_u2d1);
            return irClass2;
        }

        private final void createReceiverField(IrClass $this$createReceiverField) {
            IrFunctionReference funRef;
            IrFunctionReference irFunctionReference;
            if (this.isLambda()) {
                return;
            }
            IrFunctionReference $this$createReceiverField_u24lambda_u2d2 = irFunctionReference = (funRef = (IrFunctionReference)this.reference);
            boolean bl = false;
            IrExpression irExpression = $this$createReceiverField_u24lambda_u2d2.getDispatchReceiver();
            IrExpression boundReceiver = irExpression == null ? $this$createReceiverField_u24lambda_u2d2.getExtensionReceiver() : irExpression;
            if (boundReceiver != null) {
                this.boundReceiverField = DeclarationBuildersKt.addField$default($this$createReceiverField, Companion.getBOUND_RECEIVER_NAME(), boundReceiver.getType(), null, 4, null);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final IrConstructor createConstructor(IrClass clazz) {
            void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            void this_$iv$iv;
            void startOffset$iv;
            void $this$irBlockBody$iv;
            IrElementBase irElementBase;
            Unit unit2;
            Object $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7;
            Object superContinuation;
            IrValueParameter irValueParameter;
            Object $this$addValueParameter$iv;
            IrValueParameter irValueParameter2;
            IrFunctionBuilder irFunctionBuilder;
            IrClass $this$addConstructor$iv = clazz;
            boolean $i$f$addConstructor = false;
            Object $this$buildConstructor$iv$iv = $this$addConstructor$iv.getFactory();
            boolean $i$f$buildConstructor = false;
            IrFunctionBuilder $this$buildConstructor_u24lambda_u2d20$iv$iv = irFunctionBuilder = new IrFunctionBuilder();
            boolean bl = false;
            IrFunctionBuilder $this$addConstructor_u24lambda_u2d21$iv = $this$buildConstructor_u24lambda_u2d20$iv$iv;
            boolean bl2 = false;
            IrFunctionBuilder $this$createConstructor_u24lambda_u2d3 = $this$addConstructor_u24lambda_u2d21$iv;
            boolean bl3 = false;
            $this$createConstructor_u24lambda_u2d3.setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            $this$createConstructor_u24lambda_u2d3.setReturnType(IrUtilsKt.getDefaultType(clazz));
            $this$createConstructor_u24lambda_u2d3.setPrimary(true);
            $this$addConstructor_u24lambda_u2d21$iv.setReturnType(IrUtilsKt.getDefaultType($this$addConstructor$iv));
            Object constructor$iv = $this$buildConstructor$iv$iv = DeclarationBuildersKt.buildConstructor((IrFactory)$this$buildConstructor$iv$iv, $this$buildConstructor_u24lambda_u2d20$iv$iv);
            boolean bl4 = false;
            $this$addConstructor$iv.getDeclarations().add((IrDeclaration)constructor$iv);
            constructor$iv.setParent($this$addConstructor$iv);
            Object object = $this$buildConstructor$iv$iv;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            Object $this$createConstructor_u24lambda_u2d12 = object;
            boolean bl5 = false;
            IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(this.superClass);
            Intrinsics.checkNotNull(irClassSymbol);
            Iterable $this$single$iv = ((IrClass)irClassSymbol.getOwner()).getDeclarations();
            boolean $i$f$single22 = false;
            IrField single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrDeclaration it = (IrDeclaration)element$iv;
                boolean bl6 = false;
                if (!(it instanceof IrConstructor && ((IrConstructor)it).isPrimary())) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrConstructor superConstructor = (IrConstructor)((Object)single$iv);
            IrField $i$f$single22 = this.boundReceiverField;
            if ($i$f$single22 == null) {
                irValueParameter2 = null;
            } else {
                IrValueParameterBuilder bl6;
                IrField it = single$iv = $i$f$single22;
                boolean bl7 = false;
                $this$addValueParameter$iv = (IrFunction)$this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                IrValueParameterBuilder $this$addValueParameter_u24lambda_u2d28$iv = bl6 = new IrValueParameterBuilder();
                boolean bl8 = false;
                IrValueParameterBuilder $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl9 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setName(Companion.getBOUND_RECEIVER_NAME());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setType(it.getType());
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d6_u24lambda_u2d5.setIndex(0);
                if ($this$addValueParameter_u24lambda_u2d28$iv.getIndex() == -1) {
                    $this$addValueParameter_u24lambda_u2d28$iv.setIndex(((IrFunction)$this$addValueParameter$iv).getValueParameters().size());
                }
                IrValueParameter valueParameter$iv = irValueParameter = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv.getFactory(), $this$addValueParameter_u24lambda_u2d28$iv, (IrDeclarationParent)$this$addValueParameter$iv);
                boolean bl10 = false;
                ((IrFunction)$this$addValueParameter$iv).setValueParameters(CollectionsKt.plus((Collection)((IrFunction)$this$addValueParameter$iv).getValueParameters(), valueParameter$iv));
                irValueParameter2 = irValueParameter;
            }
            IrValueParameter boundReceiverParameter = irValueParameter2;
            IrElementBase continuation2 = null;
            if (this.isSuspendLambda) {
                superContinuation = CollectionsKt.single(superConstructor.getValueParameters());
                IrFunction $this$addValueParameter$iv2 = (IrFunction)$this$createConstructor_u24lambda_u2d12;
                boolean $i$f$addValueParameter = false;
                Object $this$addValueParameter_u24lambda_u2d28$iv = $this$addValueParameter$iv = new IrValueParameterBuilder();
                boolean bl11 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7 = $this$addValueParameter_u24lambda_u2d28$iv;
                boolean bl12 = false;
                ((IrDeclarationBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setName(superContinuation.getName());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setType(((IrValueDeclaration)superContinuation).getType());
                ((IrValueParameterBuilder)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d7).setIndex(boundReceiverParameter == null ? 0 : 1);
                unit2 = Unit.INSTANCE;
                if (((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d28$iv).getIndex() == -1) {
                    ((IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d28$iv).setIndex($this$addValueParameter$iv2.getValueParameters().size());
                }
                IrElementBase valueParameter$iv = irElementBase = DeclarationBuildersKt.buildValueParameter($this$addValueParameter$iv2.getFactory(), (IrValueParameterBuilder)$this$addValueParameter_u24lambda_u2d28$iv, $this$addValueParameter$iv2);
                boolean bl13 = false;
                $this$addValueParameter$iv2.setValueParameters(CollectionsKt.plus((Collection)$this$addValueParameter$iv2.getValueParameters(), valueParameter$iv));
                continuation2 = irElementBase;
            }
            superContinuation = LowerUtilsKt.createIrBuilder$default(callableReferenceLowering2.context, (IrSymbol)((IrConstructor)$this$createConstructor_u24lambda_u2d12).getSymbol(), 0, 0, 6, null);
            int $this$addValueParameter$iv2 = $this$createConstructor_u24lambda_u2d12.getStartOffset();
            int endOffset$iv = $this$createConstructor_u24lambda_u2d12.getEndOffset();
            boolean $i$f$irBlockBody = false;
            IrBlockBodyBuilder $this$addValueParameter_u24lambda_u2d28$iv = new IrBlockBodyBuilder($this$irBlockBody$iv.getContext(), $this$irBlockBody$iv.getScope(), (int)startOffset$iv, endOffset$iv);
            boolean $i$f$blockBody = false;
            $this$createConstructor_u24lambda_u2d12_u24lambda_u2d7 = this_$iv$iv;
            Object object2 = $this$createConstructor_u24lambda_u2d12;
            boolean bl14 = false;
            IrDelegatingConstructorCall valueParameter$iv = irElementBase = ExpressionHelpersKt.irDelegatingConstructorCall((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, superConstructor);
            irValueParameter = $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
            boolean bl15 = false;
            IrElementBase bl10 = continuation2;
            if (bl10 != null) {
                void $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9;
                IrElementBase irElementBase2;
                IrElementBase it = irElementBase2 = bl10;
                boolean bl16 = false;
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11_u24lambda_u2d9.putValueArgument(0, this.getValue((IrValueDeclaration)it));
            }
            Unit unit3 = Unit.INSTANCE;
            ((IrStatementsBuilder)((Object)irValueParameter)).unaryPlus((IrStatement)((Object)irElementBase));
            irElementBase = boundReceiverParameter;
            if (irElementBase != null) {
                IrElementBase irElementBase3;
                IrElementBase it = irElementBase3 = irElementBase;
                boolean bl17 = false;
                IrBuilderWithScope irBuilderWithScope = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrBuilderWithScope irBuilderWithScope2 = (IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11;
                IrValueParameter irValueParameter3 = clazz.getThisReceiver();
                Intrinsics.checkNotNull(irValueParameter3);
                IrExpression irExpression = ExpressionHelpersKt.irGet(irBuilderWithScope2, irValueParameter3);
                IrField irField = this.boundReceiverField;
                Intrinsics.checkNotNull(irField);
                $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(ExpressionHelpersKt.irSetField(irBuilderWithScope, irExpression, irField, ExpressionHelpersKt.irGet((IrBuilderWithScope)$this$createConstructor_u24lambda_u2d12_u24lambda_u2d11, (IrValueDeclaration)it)));
            }
            $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.unaryPlus(new IrInstanceInitializerCallImpl($this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getStartOffset(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getEndOffset(), clazz.getSymbol(), $this$createConstructor_u24lambda_u2d12_u24lambda_u2d11.getContext().getIrBuiltIns().getUnitType()));
            unit2 = Unit.INSTANCE;
            ((IrFunction)object2).setBody(this_$iv$iv.doBuild());
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final IrSimpleFunction createInvokeMethod(IrClass clazz) {
            Object object;
            Object it;
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List superMethods = (List)destination$iv$iv;
            Iterable $this$single$iv = superMethods;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            Object object2 = $this$single$iv.iterator();
            while (object2.hasNext()) {
                Object element$iv = object2.next();
                it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName().asString(), "invoke")) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            IrSimpleFunction superMethod = single$iv;
            IrClass $this$addFunction$iv = clazz;
            boolean $i$f$addFunction = false;
            IrFactory $this$addFunction$iv$iv = $this$addFunction$iv.getFactory();
            boolean $i$f$addFunction2 = false;
            IrFactory $this$buildFun$iv$iv$iv = $this$addFunction$iv$iv;
            boolean $i$f$buildFun = false;
            Object $this$buildFun_u24lambda_u2d16$iv$iv$iv = it = new IrFunctionBuilder();
            boolean bl = false;
            Object $this$createInvokeMethod_u24lambda_u2d14 = $this$buildFun_u24lambda_u2d16$iv$iv$iv;
            boolean bl2 = false;
            IrElementBuilderKt.setSourceRange((IrElementBuilder)$this$createInvokeMethod_u24lambda_u2d14, this.isLambda() ? (IrElement)this.function : (IrElement)this.reference);
            ((IrDeclarationBuilder)$this$createInvokeMethod_u24lambda_u2d14).setName(superMethod.getName());
            ((IrFunctionBuilder)$this$createInvokeMethod_u24lambda_u2d14).setReturnType(this.function.getReturnType());
            ((IrFunctionBuilder)$this$createInvokeMethod_u24lambda_u2d14).setSuspend(superMethod.isSuspend());
            ((IrFunctionBuilder)$this$createInvokeMethod_u24lambda_u2d14).setOperator(superMethod.isOperator());
            Object function$iv$iv = object2 = DeclarationBuildersKt.buildFunction($this$buildFun$iv$iv$iv, (IrFunctionBuilder)$this$buildFun_u24lambda_u2d16$iv$iv$iv);
            boolean bl3 = false;
            ((IrDeclarationContainer)$this$addFunction$iv).getDeclarations().add((IrDeclaration)function$iv$iv);
            function$iv$iv.setParent($this$addFunction$iv);
            Object $this$createInvokeMethod_u24lambda_u2d15 = object = object2;
            boolean bl4 = false;
            $this$createInvokeMethod_u24lambda_u2d15.setOverriddenSymbols(CollectionsKt.listOf(superMethod.getSymbol()));
            ((IrFunction)$this$createInvokeMethod_u24lambda_u2d15).setDispatchReceiverParameter(DeclarationBuildersKt.buildReceiverParameter((IrDeclaration)$this$createInvokeMethod_u24lambda_u2d15, clazz.getOrigin(), IrUtilsKt.getDefaultType(clazz), $this$createInvokeMethod_u24lambda_u2d15.getStartOffset(), $this$createInvokeMethod_u24lambda_u2d15.getEndOffset()));
            if (this.isLambda()) {
                this.createLambdaInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d15);
            } else {
                this.createFunctionReferenceInvokeMethod((IrSimpleFunction)$this$createInvokeMethod_u24lambda_u2d15);
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        private final void createLambdaInvokeMethod(IrSimpleFunction $this$createLambdaInvokeMethod) {
            void $this$associateTo$iv$iv;
            $this$createLambdaInvokeMethod.setAnnotations(this.function.getAnnotations());
            Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)IrUtilsKt.getExplicitParameters(this.function));
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                IndexedValue $dstr$index$param = (IndexedValue)element$iv$iv;
                boolean bl = false;
                int index2 = $dstr$index$param.component1();
                IrValueParameter param = (IrValueParameter)$dstr$index$param.component2();
                Pair<IrValueParameter, IrValueParameter> pair = TuplesKt.to(param, org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.copyTo$default(param, $this$createLambdaInvokeMethod, null, index2, 0, 0, null, null, null, null, null, false, false, false, 8186, null));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map valueParameterMap = destination$iv$iv;
            $this$createLambdaInvokeMethod.setValueParameters(CollectionsKt.toList(valueParameterMap.values()));
            $this$createLambdaInvokeMethod.setBody(IrInlineUtilsKt.moveBodyTo(this.function, $this$createLambdaInvokeMethod, valueParameterMap));
        }

        @NotNull
        public final IrGetValue getValue(@NotNull IrValueDeclaration d) {
            Intrinsics.checkNotNullParameter(d, "d");
            return new IrGetValueImpl(-1, -1, d.getType(), d.getSymbol(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE);
        }

        private final int countContextTypeParameters(IrConstructor $this$countContextTypeParameters) {
            return CallableReferenceBuilder.countContextTypeParameters$countImpl($this$countContextTypeParameters.getParent());
        }

        private final IrFunctionAccessExpression buildInvoke(IrSimpleFunction $this$buildInvoke) {
            IrFunctionReference funRef;
            IrFunctionAccessExpression irFunctionAccessExpression;
            IrExpression irExpression;
            IrFunction callee = this.function;
            IrExpression $this$buildInvoke_u24lambda_u2d19 = irExpression = this.reference;
            boolean $i$a$-run-CallableReferenceLowering$CallableReferenceBuilder$buildInvoke$irCall$22 = false;
            IrFunction irFunction2 = callee;
            if (irFunction2 instanceof IrConstructor) {
                irFunctionAccessExpression = new IrConstructorCallImpl($this$buildInvoke_u24lambda_u2d19.getStartOffset(), $this$buildInvoke_u24lambda_u2d19.getEndOffset(), IrUtilsKt.getDefaultType(IrUtilsKt.getParentAsClass(callee)), ((IrConstructor)callee).getSymbol(), this.countContextTypeParameters((IrConstructor)callee), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE);
            } else if (irFunction2 instanceof IrSimpleFunction) {
                irFunctionAccessExpression = new IrCallImpl($this$buildInvoke_u24lambda_u2d19.getStartOffset(), $this$buildInvoke_u24lambda_u2d19.getEndOffset(), callee.getReturnType(), ((IrSimpleFunction)callee).getSymbol(), callee.getTypeParameters().size(), callee.getValueParameters().size(), JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 128, null);
            } else {
                throw new IllegalStateException(Intrinsics.stringPlus("unknown function kind: ", RenderIrElementKt.render(callee)).toString());
            }
            IrFunctionAccessExpression irCall = irFunctionAccessExpression;
            IrFunctionReference $i$a$-run-CallableReferenceLowering$CallableReferenceBuilder$buildInvoke$irCall$22 = funRef = (IrFunctionReference)this.reference;
            IrElementBase $this$buildInvoke_u24lambda_u2d20 = $i$a$-run-CallableReferenceLowering$CallableReferenceBuilder$buildInvoke$irCall$22;
            boolean bl = false;
            IrExpression irExpression2 = ((IrMemberAccessExpression)$this$buildInvoke_u24lambda_u2d20).getDispatchReceiver();
            boolean boundReceiver = (irExpression2 == null ? ((IrMemberAccessExpression)$this$buildInvoke_u24lambda_u2d20).getExtensionReceiver() : irExpression2) != null;
            IrElementBase $this$buildInvoke_u24lambda_u2d21 = $this$buildInvoke_u24lambda_u2d20 = callee;
            int n = 0;
            IrValueParameter irValueParameter = ((IrFunction)$this$buildInvoke_u24lambda_u2d21).getDispatchReceiverParameter();
            boolean hasReceiver = (irValueParameter == null ? ((IrFunction)$this$buildInvoke_u24lambda_u2d21).getExtensionReceiverParameter() : irValueParameter) != null;
            irCall.setDispatchReceiver(funRef.getDispatchReceiver());
            irCall.setExtensionReceiver(funRef.getExtensionReceiver());
            int i = 0;
            List<IrValueParameter> valueParameters2 = $this$buildInvoke.getValueParameters();
            n = 0;
            int n2 = funRef.getTypeArgumentsCount();
            while (n < n2) {
                int ti = n++;
                irCall.putTypeArgument(ti, funRef.getTypeArgument(ti));
            }
            if (hasReceiver) {
                if (!boundReceiver) {
                    if (callee.getDispatchReceiverParameter() != null) {
                        n = i;
                        i = n + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get(n)));
                    }
                    if (callee.getExtensionReceiverParameter() != null) {
                        n = i;
                        i = n + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get(n)));
                    }
                } else {
                    IrField boundReceiverField = this.boundReceiverField;
                    if (boundReceiverField != null) {
                        IrValueParameter irValueParameter2 = $this$buildInvoke.getDispatchReceiverParameter();
                        Intrinsics.checkNotNull(irValueParameter2);
                        IrGetValue thisValue = this.getValue(irValueParameter2);
                        IrGetFieldImpl value2 = new IrGetFieldImpl(-1, -1, boundReceiverField.getSymbol(), boundReceiverField.getType(), thisValue, JsStatementOrigins.CALLABLE_REFERENCE_INVOKE.INSTANCE, null, 64, null);
                        if (funRef.getDispatchReceiver() != null) {
                            irCall.setDispatchReceiver(value2);
                        }
                        if (funRef.getExtensionReceiver() != null) {
                            irCall.setExtensionReceiver(value2);
                        }
                    }
                    if (callee.getDispatchReceiverParameter() != null && funRef.getDispatchReceiver() == null) {
                        int n3 = i;
                        i = n3 + 1;
                        irCall.setDispatchReceiver(this.getValue(valueParameters2.get(n3)));
                    }
                    if (callee.getExtensionReceiverParameter() != null && funRef.getExtensionReceiver() == null) {
                        int n4 = i;
                        i = n4 + 1;
                        irCall.setExtensionReceiver(this.getValue(valueParameters2.get(n4)));
                    }
                }
            }
            int j = 0;
            while (i < valueParameters2.size()) {
                int n5 = j;
                j = n5 + 1;
                int n6 = n5;
                n5 = i;
                i = n5 + 1;
                irCall.putValueArgument(n6, this.getValue(valueParameters2.get(n5)));
            }
            return irCall;
        }

        /*
         * WARNING - void declaration
         */
        private final void createFunctionReferenceInvokeMethod(IrSimpleFunction $this$createFunctionReferenceInvokeMethod) {
            void $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25;
            IrExpression $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            Object object;
            Object object2;
            Object object3;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = ((IrSimpleType)this.reference.getType()).getArguments();
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                object3 = (IrTypeArgument)item$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object = ((IrTypeProjection)it).getType();
                object2.add(object);
            }
            List parameterTypes = (List)destination$iv$iv;
            List argumentTypes2 = CollectionsKt.dropLast(parameterTypes, 1);
            Iterable $i$f$map22 = argumentTypes2;
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean $i$f$mapIndexed = false;
            destination$iv$iv = $this$mapIndexed$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            object3 = $this$mapIndexedTo$iv$iv.iterator();
            while (object3.hasNext()) {
                void t;
                void i;
                IrValueParameterBuilder irValueParameterBuilder;
                Object item$iv$iv = object3.next();
                int n = index$iv$iv;
                index$iv$iv = n + 1;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                IrType irType = (IrType)item$iv$iv;
                int n2 = n;
                object = destination$iv$iv2;
                boolean bl = false;
                boolean $i$f$buildValueParameter = false;
                IrValueParameterBuilder $this$buildValueParameter_u24lambda_u2d26$iv = irValueParameterBuilder = new IrValueParameterBuilder();
                boolean bl2 = false;
                IrValueParameterBuilder $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23 = $this$buildValueParameter_u24lambda_u2d26$iv;
                boolean bl3 = false;
                Name name2 = Name.identifier(Intrinsics.stringPlus("p", (int)i));
                Intrinsics.checkNotNullExpressionValue(name2, "identifier(\"p$i\")");
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setName(name2);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setType((IrType)t);
                $this$createFunctionReferenceInvokeMethod_u24lambda_u2d24_u24lambda_u2d23.setIndex((int)i);
                IrValueParameter irValueParameter = DeclarationBuildersKt.buildValueParameter(((IrDeclaration)$this$createFunctionReferenceInvokeMethod).getFactory(), $this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)$this$createFunctionReferenceInvokeMethod)));
                object.add(irValueParameter);
            }
            object = (List)destination$iv$iv2;
            ((IrFunction)object2).setValueParameters((List<? extends IrValueParameter>)object);
            IrExpression irExpression = this.reference;
            CallableReferenceLowering callableReferenceLowering2 = CallableReferenceLowering.this;
            $this$mapIndexedTo$iv$iv = irExpression;
            int n = this.reference.getEndOffset();
            int n3 = this.reference.getStartOffset();
            object = $this$createFunctionReferenceInvokeMethod.getFactory();
            object2 = $this$createFunctionReferenceInvokeMethod;
            boolean bl = false;
            IrReturnImpl irReturnImpl = new IrReturnImpl($this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.getStartOffset(), $this$createFunctionReferenceInvokeMethod_u24lambda_u2d25.getEndOffset(), callableReferenceLowering2.nothingType, $this$createFunctionReferenceInvokeMethod.getSymbol(), this.buildInvoke($this$createFunctionReferenceInvokeMethod));
            ((IrFunction)object2).setBody(object.createBlockBody(n3, n, CollectionsKt.listOf(irReturnImpl)));
        }

        /*
         * WARNING - void declaration
         */
        private final void createNameProperty(IrClass clazz) {
            void $this$createNameProperty_u24lambda_u2d28;
            Object getter2;
            Object $this$addGetter$iv;
            IrProperty nameProperty;
            Object element$iv$iv2;
            void $this$filterIsInstanceTo$iv$iv;
            if (!this.isKReference) {
                return;
            }
            Iterable $this$filterIsInstance$iv = this.superFunctionInterface.getDeclarations();
            boolean $i$f$filterIsInstance22 = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv2 instanceof IrProperty)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            IrProperty superProperty = (IrProperty)CollectionsKt.single((List)destination$iv$iv);
            IrSimpleFunction $i$f$filterIsInstance22 = superProperty.getGetter();
            if ($i$f$filterIsInstance22 == null) {
                throw new IllegalStateException("Expected getter for KFunction.name property".toString());
            }
            IrSimpleFunction supperGetter = $i$f$filterIsInstance22;
            IrClass $this$addProperty$iv = clazz;
            boolean $i$f$addProperty22 = false;
            IrFactory $this$buildProperty$iv$iv = $this$addProperty$iv.getFactory();
            boolean $i$f$buildProperty = false;
            Object $this$buildProperty_u24lambda_u2d8$iv$iv = element$iv$iv2 = new IrPropertyBuilder();
            boolean bl = false;
            Object $this$createNameProperty_u24lambda_u2d26 = $this$buildProperty_u24lambda_u2d8$iv$iv;
            boolean bl2 = false;
            ((IrDeclarationBuilder)$this$createNameProperty_u24lambda_u2d26).setVisibility(superProperty.getVisibility());
            ((IrDeclarationBuilder)$this$createNameProperty_u24lambda_u2d26).setName(superProperty.getName());
            ((IrDeclarationBuilder)$this$createNameProperty_u24lambda_u2d26).setOrigin(Companion.GENERATED_MEMBER_IN_CALLABLE_REFERENCE.INSTANCE);
            Object object = DeclarationBuildersKt.buildProperty($this$buildProperty$iv$iv, (IrPropertyBuilder)$this$buildProperty_u24lambda_u2d8$iv$iv);
            IrProperty property$iv = object;
            boolean $i$a$-also-DeclarationBuildersKt$addProperty$1$iv22 = false;
            $this$addProperty$iv.getDeclarations().add(property$iv);
            property$iv.setParent($this$addProperty$iv);
            IrProperty $i$f$addProperty22 = nameProperty = object;
            object = CallableReferenceLowering.this;
            boolean $i$f$addGetter = false;
            IrFunctionBuilder $i$a$-also-DeclarationBuildersKt$addProperty$1$iv22 = new IrFunctionBuilder();
            Object $this$addGetter_u24lambda_u2d11$iv = $i$a$-also-DeclarationBuildersKt$addProperty$1$iv22;
            boolean bl3 = false;
            Object object2 = Name.special("<get-" + $this$addGetter$iv.getName() + '>');
            Intrinsics.checkNotNullExpressionValue(object2, "special(\"<get-${this@addGetter.name}>\")");
            ((IrDeclarationBuilder)$this$addGetter_u24lambda_u2d11$iv).setName((Name)object2);
            IrFunctionBuilder $this$createNameProperty_u24lambda_u2d27 = $this$addGetter_u24lambda_u2d11$iv;
            boolean bl4 = false;
            $this$createNameProperty_u24lambda_u2d27.setReturnType(((CallableReferenceLowering)object).stringType);
            Object getter$iv = object2 = DeclarationBuildersKt.buildFunction($this$addGetter$iv.getFactory(), (IrFunctionBuilder)$this$addGetter_u24lambda_u2d11$iv);
            boolean bl5 = false;
            ((IrProperty)$this$addGetter$iv).setGetter((IrSimpleFunction)getter$iv);
            ((IrSimpleFunction)getter$iv).setCorrespondingPropertySymbol(((IrProperty)$this$addGetter$iv).getSymbol());
            getter$iv.setParent($this$addGetter$iv.getParent());
            $this$addGetter$iv = getter2 = object2;
            $this$addGetter$iv.setOverriddenSymbols(CollectionsKt.plus((Collection)$this$addGetter$iv.getOverriddenSymbols(), supperGetter.getSymbol()));
            boolean $i$f$buildValueParameter = false;
            Object $this$buildValueParameter_u24lambda_u2d26$iv = object = new IrValueParameterBuilder();
            boolean bl6 = false;
            $this$addGetter_u24lambda_u2d11$iv = $this$buildValueParameter_u24lambda_u2d26$iv;
            Object object3 = getter2;
            boolean bl7 = false;
            $this$createNameProperty_u24lambda_u2d28.setName(SpecialNames.THIS);
            $this$createNameProperty_u24lambda_u2d28.setType(IrUtilsKt.getDefaultType(clazz));
            Unit unit2 = Unit.INSTANCE;
            ((IrFunction)object3).setDispatchReceiverParameter(DeclarationBuildersKt.buildValueParameter(((IrDeclaration)getter2).getFactory(), (IrValueParameterBuilder)$this$buildValueParameter_u24lambda_u2d26$iv, (IrDeclarationParent)((Object)((IrDeclaration)getter2))));
            IrFactory irFactory = CallableReferenceLowering.this.context.getIrFactory();
            IrType irType = CallableReferenceLowering.this.nothingType;
            IrReturnTargetSymbol irReturnTargetSymbol = ((IrSimpleFunction)getter2).getSymbol();
            IrType irType2 = CallableReferenceLowering.this.stringType;
            IrFunction irFunction2 = this.reflectionTarget;
            Intrinsics.checkNotNull(irFunction2);
            String string2 = irFunction2.getName().asString();
            Intrinsics.checkNotNullExpressionValue(string2, "reflectionTarget!!.name.asString()");
            ((IrFunction)getter2).setBody(irFactory.createBlockBody(-1, -1, CollectionsKt.listOf(new IrReturnImpl(-1, -1, irType, irReturnTargetSymbol, IrConstImpl.Companion.string(-1, -1, irType2, string2)))));
            CallableReferenceLowering.this.context.getMapping().getReflectedNameAccessor().set((IrClass)((IrDeclaration)clazz), (IrSimpleFunction)getter2);
        }

        @NotNull
        public final Pair<IrClass, IrConstructor> build() {
            IrClass clazz = this.buildReferenceClass();
            IrConstructor ctor = this.createConstructor(clazz);
            this.createInvokeMethod(clazz);
            this.createNameProperty(clazz);
            return new Pair<IrClass, IrConstructor>(clazz, ctor);
        }

        /*
         * WARNING - void declaration
         */
        private static final int countContextTypeParameters$countImpl(IrDeclarationParent container) {
            int n;
            IrDeclarationParent irDeclarationParent = container;
            if (irDeclarationParent instanceof IrClass) {
                void $this$countContextTypeParameters_u24countImpl_u24lambda_u2d17;
                IrDeclarationParent irDeclarationParent2 = container;
                IrClass irClass2 = (IrClass)irDeclarationParent2;
                int n2 = ((IrClass)container).getTypeParameters().size();
                boolean bl = false;
                int n3 = $this$countContextTypeParameters_u24countImpl_u24lambda_u2d17.isInner() ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrClass)container).getParent()) : 0;
                n = n2 + n3;
            } else if (irDeclarationParent instanceof IrFunction) {
                n = ((IrFunction)container).getTypeParameters().size() + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrFunction)container).getParent());
            } else if (irDeclarationParent instanceof IrProperty) {
                int n4;
                Object object = container;
                IrElement $this$countContextTypeParameters_u24countImpl_u24lambda_u2d18 = (IrElement)object;
                boolean bl = false;
                IrSimpleFunction irSimpleFunction = ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d18).getGetter();
                IrSimpleFunction irSimpleFunction2 = irSimpleFunction == null ? ((IrProperty)$this$countContextTypeParameters_u24countImpl_u24lambda_u2d18).getSetter() : irSimpleFunction;
                if (irSimpleFunction2 == null) {
                    n4 = 0;
                } else {
                    object = irSimpleFunction2.getTypeParameters();
                    n4 = object.size();
                }
                n = n4 + CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrProperty)((Object)container)).getParent());
            } else {
                n = irDeclarationParent instanceof IrDeclaration ? CallableReferenceBuilder.countContextTypeParameters$countImpl(((IrDeclaration)((Object)container)).getParent()) : 0;
            }
            return n;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion;", "", "()V", "BOUND_RECEIVER_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getBOUND_RECEIVER_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "FUNCTION_REFERENCE_IMPL", "GENERATED_MEMBER_IN_CALLABLE_REFERENCE", "LAMBDA_IMPL", "backend.js"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Name getBOUND_RECEIVER_NAME() {
            return BOUND_RECEIVER_NAME;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$LAMBDA_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class LAMBDA_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final LAMBDA_IMPL INSTANCE = new LAMBDA_IMPL();

            private LAMBDA_IMPL() {
                super("LAMBDA_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$FUNCTION_REFERENCE_IMPL;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class FUNCTION_REFERENCE_IMPL
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final FUNCTION_REFERENCE_IMPL INSTANCE = new FUNCTION_REFERENCE_IMPL();

            private FUNCTION_REFERENCE_IMPL() {
                super("FUNCTION_REFERENCE_IMPL", false, 2, null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/CallableReferenceLowering$Companion$GENERATED_MEMBER_IN_CALLABLE_REFERENCE;", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOriginImpl;", "()V", "backend.js"})
        public static final class GENERATED_MEMBER_IN_CALLABLE_REFERENCE
        extends IrDeclarationOriginImpl {
            @NotNull
            public static final GENERATED_MEMBER_IN_CALLABLE_REFERENCE INSTANCE = new GENERATED_MEMBER_IN_CALLABLE_REFERENCE();

            private GENERATED_MEMBER_IN_CALLABLE_REFERENCE() {
                super("GENERATED_MEMBER_IN_CALLABLE_REFERENCE", false, 2, null);
            }
        }
    }
}

