/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.declarations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.descriptors.Deprecation;
import org.jetbrains.kotlin.descriptors.DeprecationLevelValue;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationUseSiteTarget;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.DeprecationsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.CollectionsKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\"\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u0011\u001a6\u0010\u0012\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00160\u00140\u0013*\b\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d\u001a)\u0010\u001e\u001a\u0004\u0018\u00010\u0016*\u0006\u0012\u0002\b\u00030\u001b2\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150 \"\u00020\u0015\u00a2\u0006\u0002\u0010!\u001a\u0012\u0010\"\u001a\u00020\f*\u00020#2\u0006\u0010\u0010\u001a\u00020\u0011\u001a \u0010$\u001a\u00020\f*\b\u0012\u0004\u0012\u00020\u00170\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019\u001a\u000e\u0010%\u001a\u0004\u0018\u00010&*\u00020\u0017H\u0002\u001a\u0016\u0010'\u001a\u0004\u0018\u00010\u0011*\u00020\u00172\u0006\u0010(\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"ERROR_SINCE_NAME", "Lorg/jetbrains/kotlin/name/Name;", "HIDDEN_SINCE_NAME", "JAVA_DEPRECATED", "Lorg/jetbrains/kotlin/name/FqName;", "JAVA_ORIGINS", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "LEVEL_NAME", "MESSAGE_NAME", "WARNING_SINCE_NAME", "getDeprecationsFromAccessors", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "getter", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "setter", "currentVersion", "Lorg/jetbrains/kotlin/config/ApiVersion;", "extractDeprecationInfoPerUseSite", "", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;", "Lorg/jetbrains/kotlin/descriptors/Deprecation;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "fromJava", "", "getDeprecation", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "callSite", "Lorg/jetbrains/kotlin/fir/FirElement;", "getDeprecationForCallSite", "sites", "", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;[Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationUseSiteTarget;)Lorg/jetbrains/kotlin/descriptors/Deprecation;", "getDeprecationInfos", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "getDeprecationInfosFromAnnotations", "getDeprecationLevel", "Lorg/jetbrains/kotlin/descriptors/DeprecationLevelValue;", "getVersionFromArgument", "name", "resolve"})
public final class DeprecationUtilsKt {
    @NotNull
    private static final FqName JAVA_DEPRECATED = new FqName("java.lang.Deprecated");
    @NotNull
    private static final Name HIDDEN_SINCE_NAME;
    @NotNull
    private static final Name ERROR_SINCE_NAME;
    @NotNull
    private static final Name WARNING_SINCE_NAME;
    @NotNull
    private static final Name MESSAGE_NAME;
    @NotNull
    private static final Name LEVEL_NAME;
    @NotNull
    private static final Set<FirDeclarationOrigin> JAVA_ORIGINS;

    @Nullable
    public static final Deprecation getDeprecation(@NotNull FirBasedSymbol<?> $this$getDeprecation, @Nullable FirElement callSite) {
        Intrinsics.checkNotNullParameter($this$getDeprecation, "<this>");
        List deprecationInfos = new ArrayList();
        FirBasedSymbol<?> firBasedSymbol = $this$getDeprecation;
        if (firBasedSymbol instanceof FirPropertySymbol) {
            if (callSite instanceof FirVariableAssignment) {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_SETTER, AnnotationUseSiteTarget.PROPERTY};
                CollectionsKt.addIfNotNull(deprecationInfos, DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, annotationUseSiteTargetArray));
            } else {
                AnnotationUseSiteTarget[] annotationUseSiteTargetArray = new AnnotationUseSiteTarget[]{AnnotationUseSiteTarget.PROPERTY_GETTER, AnnotationUseSiteTarget.PROPERTY};
                CollectionsKt.addIfNotNull(deprecationInfos, DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, annotationUseSiteTargetArray));
            }
        } else {
            CollectionsKt.addIfNotNull(deprecationInfos, DeprecationUtilsKt.getDeprecationForCallSite($this$getDeprecation, new AnnotationUseSiteTarget[0]));
        }
        return (Deprecation)kotlin.collections.CollectionsKt.firstOrNull(deprecationInfos);
    }

    @NotNull
    public static final DeprecationsPerUseSite getDeprecationInfos(@NotNull FirAnnotationContainer $this$getDeprecationInfos, @NotNull ApiVersion currentVersion) {
        Object object;
        Intrinsics.checkNotNullParameter($this$getDeprecationInfos, "<this>");
        Intrinsics.checkNotNullParameter(currentVersion, "currentVersion");
        Map deprecationByUseSite = new LinkedHashMap();
        Iterable iterable = JAVA_ORIGINS;
        FirAnnotationContainer $this$safeAs$iv = $this$getDeprecationInfos;
        boolean $i$f$safeAs = false;
        FirAnnotationContainer firAnnotationContainer = $this$safeAs$iv;
        if (!(firAnnotationContainer instanceof FirDeclaration)) {
            firAnnotationContainer = null;
        }
        boolean fromJava = kotlin.collections.CollectionsKt.contains(iterable, (object = (FirDeclaration)((Object)firAnnotationContainer)) == null ? null : ((FirDeclaration)object).getOrigin());
        MapsKt.toMap((Iterable)DeprecationUtilsKt.extractDeprecationInfoPerUseSite($this$getDeprecationInfos.getAnnotations(), currentVersion, fromJava), deprecationByUseSite);
        if ($this$getDeprecationInfos instanceof FirProperty && (object = DeprecationUtilsKt.getDeprecationsFromAccessors(((FirProperty)$this$getDeprecationInfos).getGetter(), ((FirProperty)$this$getDeprecationInfos).getSetter(), currentVersion).getBySpecificSite()) != null) {
            Object $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry $dstr$k$v = element$iv = iterator2.next();
                boolean bl = false;
                Map.Entry entry = $dstr$k$v;
                AnnotationUseSiteTarget k = (AnnotationUseSiteTarget)((Object)entry.getKey());
                Object object2 = $dstr$k$v;
                Deprecation v = (Deprecation)object2.getValue();
                object2 = deprecationByUseSite;
                object2.put(k, v);
            }
        }
        return DeprecationsPerUseSite.Companion.fromMap(deprecationByUseSite);
    }

    @NotNull
    public static final DeprecationsPerUseSite getDeprecationsFromAccessors(@Nullable FirFunction getter2, @Nullable FirFunction setter2, @NotNull ApiVersion currentVersion) {
        Deprecation it;
        Deprecation deprecation2;
        DeprecationsPerUseSite deprecationsPerUseSite;
        Deprecation deprecation3;
        Map<AnnotationUseSiteTarget, Deprecation> map2;
        Intrinsics.checkNotNullParameter(currentVersion, "currentVersion");
        Map<AnnotationUseSiteTarget, Deprecation> $this$getDeprecationsFromAccessors_u24lambda_u2d3 = map2 = MapsKt.createMapBuilder();
        boolean bl = false;
        FirFunction firFunction = setter2;
        if (firFunction != null && (deprecation3 = (deprecationsPerUseSite = DeprecationUtilsKt.getDeprecationInfos(firFunction, currentVersion)).getAll()) != null) {
            it = deprecation2 = deprecation3;
            boolean bl2 = false;
            $this$getDeprecationsFromAccessors_u24lambda_u2d3.put(AnnotationUseSiteTarget.PROPERTY_SETTER, it);
        }
        if ((firFunction = getter2) != null && (deprecation3 = (deprecationsPerUseSite = DeprecationUtilsKt.getDeprecationInfos(firFunction, currentVersion)).getAll()) != null) {
            it = deprecation2 = deprecation3;
            boolean bl3 = false;
            $this$getDeprecationsFromAccessors_u24lambda_u2d3.put(AnnotationUseSiteTarget.PROPERTY_GETTER, it);
        }
        Map<AnnotationUseSiteTarget, Deprecation> perUseSite = MapsKt.build(map2);
        return perUseSite.isEmpty() ? DeprecationsKt.getEmptyDeprecationsPerUseSite() : new DeprecationsPerUseSite(null, perUseSite);
    }

    @NotNull
    public static final DeprecationsPerUseSite getDeprecationInfosFromAnnotations(@NotNull List<? extends FirAnnotationCall> $this$getDeprecationInfosFromAnnotations, @NotNull ApiVersion currentVersion, boolean fromJava) {
        Intrinsics.checkNotNullParameter($this$getDeprecationInfosFromAnnotations, "<this>");
        Intrinsics.checkNotNullParameter(currentVersion, "currentVersion");
        Map<AnnotationUseSiteTarget, Deprecation> deprecationByUseSite = MapsKt.toMap((Iterable)DeprecationUtilsKt.extractDeprecationInfoPerUseSite($this$getDeprecationInfosFromAnnotations, currentVersion, fromJava));
        return DeprecationsPerUseSite.Companion.fromMap(deprecationByUseSite);
    }

    @Nullable
    public static final Deprecation getDeprecationForCallSite(@NotNull FirBasedSymbol<?> $this$getDeprecationForCallSite, AnnotationUseSiteTarget ... sites) {
        Intrinsics.checkNotNullParameter($this$getDeprecationForCallSite, "<this>");
        Intrinsics.checkNotNullParameter(sites, "sites");
        Object object = $this$getDeprecationForCallSite;
        DeprecationsPerUseSite deprecations2 = object instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$getDeprecationForCallSite).getDeprecation() : (object instanceof FirClassLikeSymbol ? ((FirClassLikeSymbol)$this$getDeprecationForCallSite).getDeprecation() : null);
        object = deprecations2;
        return ((DeprecationsPerUseSite)(object == null ? DeprecationsKt.getEmptyDeprecationsPerUseSite() : object)).forUseSite(Arrays.copyOf(sites, sites.length));
    }

    private static final ApiVersion getVersionFromArgument(FirAnnotationCall $this$getVersionFromArgument, Name name2) {
        ApiVersion apiVersion;
        String string2 = FirAnnotationUtilsKt.getStringArgument($this$getVersionFromArgument, name2);
        if (string2 == null) {
            apiVersion = null;
        } else {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            apiVersion = ApiVersion.Companion.parse(it);
        }
        return apiVersion;
    }

    private static final DeprecationLevelValue getDeprecationLevel(FirAnnotationCall $this$getDeprecationLevel) {
        DeprecationLevelValue deprecationLevelValue;
        block7: {
            FirExpression arg;
            FirExpression firExpression2;
            FirExpression firExpression3 = FirAnnotationUtilsKt.findArgumentByName($this$getDeprecationLevel, LEVEL_NAME);
            if (firExpression3 == null) {
                FirCall $this$arguments$iv = $this$getDeprecationLevel;
                boolean $i$f$getArguments = false;
                firExpression2 = kotlin.collections.CollectionsKt.lastOrNull($this$arguments$iv.getArgumentList().getArguments());
            } else {
                firExpression2 = firExpression3;
            }
            firExpression3 = arg = firExpression2;
            if (firExpression3 == null) {
                deprecationLevelValue = null;
            } else {
                DeprecationLevelValue[] deprecationLevelValueArray;
                FirQualifiedAccessExpression firQualifiedAccessExpression;
                FirExpression firExpression4;
                FirExpression argument2 = firExpression4 = firExpression3;
                boolean bl = false;
                FirQualifiedAccessExpression firQualifiedAccessExpression2 = firQualifiedAccessExpression = argument2 instanceof FirQualifiedAccessExpression ? (FirQualifiedAccessExpression)argument2 : null;
                if (firQualifiedAccessExpression == null) {
                    return null;
                }
                FirQualifiedAccessExpression targetExpression = firQualifiedAccessExpression;
                FirReference object = targetExpression.getCalleeReference();
                DeprecationLevelValue[] deprecationLevelValueArray2 = deprecationLevelValueArray = object instanceof FirNamedReference ? (DeprecationLevelValue[])object : null;
                if (deprecationLevelValueArray == null) {
                    return null;
                }
                Name name2 = deprecationLevelValueArray.getName();
                DeprecationLevelValue[] deprecationLevelValueArray3 = name2.asString();
                Intrinsics.checkNotNullExpressionValue(deprecationLevelValueArray3, "(targetExpression.callee\u2026asString() ?: return null");
                DeprecationLevelValue[] targetName = deprecationLevelValueArray3;
                for (DeprecationLevelValue deprecationLevelValue2 : deprecationLevelValueArray = (deprecationLevelValueArray3 = DeprecationLevelValue.values())) {
                    DeprecationLevelValue it = deprecationLevelValue2;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.name(), targetName)) continue;
                    deprecationLevelValue = deprecationLevelValue2;
                    break block7;
                }
                deprecationLevelValue = null;
            }
        }
        return deprecationLevelValue;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<AnnotationUseSiteTarget, Deprecation>> extractDeprecationInfoPerUseSite(List<? extends FirAnnotationCall> $this$extractDeprecationInfoPerUseSite, ApiVersion currentVersion, boolean fromJava) {
        void $this$mapNotNullTo$iv$iv;
        Object object;
        FirAnnotationCall it;
        Collection collection;
        Object object2;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = FirAnnotationUtilsKt.getAnnotationsByFqName($this$extractDeprecationInfoPerUseSite, StandardNames.FqNames.deprecated);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            object2 = (FirAnnotationCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            object = TuplesKt.to(it, false);
            collection.add(object);
        }
        $this$map$iv = FirAnnotationUtilsKt.getAnnotationsByFqName($this$extractDeprecationInfoPerUseSite, JAVA_DEPRECATED);
        collection = (List)destination$iv$iv;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (FirAnnotationCall)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            Pair<FirAnnotationCall, Boolean> pair = TuplesKt.to(it, true);
            object.add(pair);
        }
        object = (List)destination$iv$iv;
        List annotations2 = kotlin.collections.CollectionsKt.plus(collection, (Iterable)object);
        Iterable $this$mapNotNull$iv = annotations2;
        boolean $i$f$mapNotNull = false;
        $this$mapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        object2 = $this$forEach$iv$iv$iv.iterator();
        while (object2.hasNext()) {
            Pair<AnnotationUseSiteTarget, Deprecation> pair;
            Pair<AnnotationUseSiteTarget, Deprecation> pair2;
            Pair<AnnotationUseSiteTarget, Deprecation> pair3;
            DeprecationLevelValue deprecationLevelValue;
            DeprecationLevelValue appliedLevel;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object2.next();
            boolean bl = false;
            Pair $dstr$deprecated$fromJavaAnnotation = (Pair)element$iv$iv;
            boolean bl2 = false;
            FirAnnotationCall deprecated = (FirAnnotationCall)$dstr$deprecated$fromJavaAnnotation.component1();
            boolean fromJavaAnnotation = (Boolean)$dstr$deprecated$fromJavaAnnotation.component2();
            DeprecationLevelValue deprecationLevelValue2 = DeprecationUtilsKt.getDeprecationLevel(deprecated);
            DeprecationLevelValue deprecationLevel = deprecationLevelValue2 == null ? DeprecationLevelValue.WARNING : deprecationLevelValue2;
            FirAnnotationCall deprecatedSinceKotlin = kotlin.collections.CollectionsKt.firstOrNull(FirAnnotationUtilsKt.getAnnotationsByFqName($this$extractDeprecationInfoPerUseSite, StandardNames.FqNames.deprecatedSinceKotlin));
            DeprecationLevelValue deprecationLevelValue3 = DeprecationUtilsKt.extractDeprecationInfoPerUseSite$lambda-13$levelApplied(deprecatedSinceKotlin, currentVersion, deprecationLevel, HIDDEN_SINCE_NAME, DeprecationLevelValue.HIDDEN);
            deprecationLevelValue3 = appliedLevel = deprecationLevelValue3 == null ? ((deprecationLevelValue = DeprecationUtilsKt.extractDeprecationInfoPerUseSite$lambda-13$levelApplied(deprecatedSinceKotlin, currentVersion, deprecationLevel, ERROR_SINCE_NAME, DeprecationLevelValue.ERROR)) == null ? DeprecationUtilsKt.extractDeprecationInfoPerUseSite$lambda-13$levelApplied(deprecatedSinceKotlin, currentVersion, deprecationLevel, WARNING_SINCE_NAME, DeprecationLevelValue.WARNING) : deprecationLevelValue) : deprecationLevelValue3;
            if (deprecationLevelValue3 == null) {
                pair3 = null;
            } else {
                DeprecationLevelValue it2 = deprecationLevelValue = deprecationLevelValue3;
                boolean bl3 = false;
                boolean inheritable = !fromJavaAnnotation && !fromJava;
                pair3 = TuplesKt.to(deprecated.getUseSiteTarget(), new Deprecation(it2, inheritable, FirAnnotationUtilsKt.getStringArgument(deprecated, MESSAGE_NAME)));
            }
            if ((pair2 = pair3) == null) continue;
            Pair<AnnotationUseSiteTarget, Deprecation> it$iv$iv = pair = pair2;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final DeprecationLevelValue extractDeprecationInfoPerUseSite$lambda-13$levelApplied(FirAnnotationCall deprecatedSinceKotlin, ApiVersion $currentVersion, DeprecationLevelValue deprecationLevel, Name name2, DeprecationLevelValue level) {
        ApiVersion apiVersion;
        Object object = deprecatedSinceKotlin;
        if (object != null && (apiVersion = DeprecationUtilsKt.getVersionFromArgument(object, name2)) != null) {
            ApiVersion apiVersion2;
            ApiVersion apiVersion3;
            ApiVersion it = apiVersion3 = apiVersion;
            boolean bl = false;
            ApiVersion apiVersion4 = apiVersion2 = it.compareTo($currentVersion) <= 0 ? apiVersion3 : null;
            if (apiVersion2 != null) {
                it = apiVersion3 = apiVersion2;
                boolean bl2 = false;
                return level;
            }
        }
        Object it = object = level;
        boolean bl = false;
        return deprecatedSinceKotlin == null && level == deprecationLevel ? object : null;
    }

    static {
        FirDeclarationOrigin[] firDeclarationOriginArray = Name.identifier("hiddenSince");
        Intrinsics.checkNotNullExpressionValue(firDeclarationOriginArray, "identifier(\"hiddenSince\")");
        HIDDEN_SINCE_NAME = firDeclarationOriginArray;
        firDeclarationOriginArray = Name.identifier("errorSince");
        Intrinsics.checkNotNullExpressionValue(firDeclarationOriginArray, "identifier(\"errorSince\")");
        ERROR_SINCE_NAME = firDeclarationOriginArray;
        firDeclarationOriginArray = Name.identifier("warningSince");
        Intrinsics.checkNotNullExpressionValue(firDeclarationOriginArray, "identifier(\"warningSince\")");
        WARNING_SINCE_NAME = firDeclarationOriginArray;
        firDeclarationOriginArray = Name.identifier("message");
        Intrinsics.checkNotNullExpressionValue(firDeclarationOriginArray, "identifier(\"message\")");
        MESSAGE_NAME = firDeclarationOriginArray;
        firDeclarationOriginArray = Name.identifier("level");
        Intrinsics.checkNotNullExpressionValue(firDeclarationOriginArray, "identifier(\"level\")");
        LEVEL_NAME = firDeclarationOriginArray;
        firDeclarationOriginArray = new FirDeclarationOrigin[]{FirDeclarationOrigin.Java.INSTANCE, FirDeclarationOrigin.Enhancement.INSTANCE};
        JAVA_ORIGINS = SetsKt.setOf(firDeclarationOriginArray);
    }
}

