/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.inject.internal;

import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.internal.BindingImpl;
import org.jetbrains.kotlin.com.google.inject.internal.ConstructionContext;
import org.jetbrains.kotlin.com.google.inject.internal.DelayedInitialize;
import org.jetbrains.kotlin.com.google.inject.internal.Errors;
import org.jetbrains.kotlin.com.google.inject.internal.ErrorsException;
import org.jetbrains.kotlin.com.google.inject.internal.InjectorImpl;
import org.jetbrains.kotlin.com.google.inject.internal.InternalContext;
import org.jetbrains.kotlin.com.google.inject.internal.InternalProvisionException;
import org.jetbrains.kotlin.com.google.inject.internal.ProviderInternalFactory;
import org.jetbrains.kotlin.com.google.inject.internal.ProvisionListenerStackCallback;
import org.jetbrains.kotlin.com.google.inject.spi.Dependency;

class ProvidedByInternalFactory<T>
extends ProviderInternalFactory<T>
implements DelayedInitialize {
    private final Class<?> rawType;
    private final Class<? extends Provider<?>> providerType;
    private final Key<? extends Provider<T>> providerKey;
    private BindingImpl<? extends Provider<T>> providerBinding;
    private ProvisionListenerStackCallback<T> provisionCallback;

    ProvidedByInternalFactory(Class<?> rawType, Class<? extends Provider<?>> providerType, Key<? extends Provider<T>> providerKey) {
        super(providerKey);
        this.rawType = rawType;
        this.providerType = providerType;
        this.providerKey = providerKey;
    }

    void setProvisionListenerCallback(ProvisionListenerStackCallback<T> listener) {
        this.provisionCallback = listener;
    }

    @Override
    public void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
        this.providerBinding = injector.getBindingOrThrow(this.providerKey, errors, InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
    }

    @Override
    public T get(InternalContext context2, Dependency<?> dependency, boolean linked) throws InternalProvisionException {
        BindingImpl<Provider<T>> localProviderBinding = this.providerBinding;
        if (localProviderBinding == null) {
            throw new IllegalStateException("not initialized");
        }
        Key<? extends Provider<T>> localProviderKey = this.providerKey;
        context2.pushState(localProviderKey, localProviderBinding.getSource());
        try {
            Provider<T> provider2 = localProviderBinding.getInternalFactory().get(context2, dependency, true);
            T t = this.circularGet(provider2, context2, dependency, this.provisionCallback);
            return t;
        }
        catch (InternalProvisionException ipe) {
            throw ipe.addSource(localProviderKey);
        }
        finally {
            context2.popState();
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider2, Dependency<?> dependency, ConstructionContext<T> constructionContext) throws InternalProvisionException {
        try {
            T o = super.provision(provider2, dependency, constructionContext);
            if (o != null && !this.rawType.isInstance(o)) {
                throw InternalProvisionException.subtypeNotProvided(this.providerType, this.rawType);
            }
            T t = o;
            return t;
        }
        catch (RuntimeException e) {
            throw InternalProvisionException.errorInProvider(e).addSource(this.source);
        }
    }
}

