/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.gwt.dev.js.ThrowExceptionOnErrorReporter;
import org.jetbrains.kotlin.com.google.gwt.dev.js.rhino.ErrorReporter;
import org.jetbrains.kotlin.js.backend.JsToStringGenerationVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsBlock;
import org.jetbrains.kotlin.js.backend.ast.JsContext;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsExpressionStatement;
import org.jetbrains.kotlin.js.backend.ast.JsGlobalBlock;
import org.jetbrains.kotlin.js.backend.ast.JsInvocation;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsObjectScope;
import org.jetbrains.kotlin.js.backend.ast.JsProgram;
import org.jetbrains.kotlin.js.backend.ast.JsScope;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVisitorWithContextImpl;
import org.jetbrains.kotlin.js.inline.util.FixForwardNameReferencesKt;
import org.jetbrains.kotlin.js.parser.ParserUtilsKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JSONKt;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNode;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonNull;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonObject;
import org.jetbrains.kotlin.js.parser.sourcemaps.JsonString;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMap;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapError;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapLocationRemapper;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapParser;
import org.jetbrains.kotlin.js.parser.sourcemaps.SourceMapSuccess;
import org.jetbrains.kotlin.js.sourceMap.SourceFilePathResolver;
import org.jetbrains.kotlin.js.sourceMap.SourceMap3Builder;
import org.jetbrains.kotlin.js.sourceMap.SourceMapBuilderConsumer;
import org.jetbrains.kotlin.js.util.TextOutputImpl;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u0002\u001a\u0019\u0010\u0006\u001a\u00020\u00012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\n\u001a.\u0010\u000b\u001a\u00020\u00012\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0002\u001a\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u00130\u0010H\u0002\u00a8\u0006\u0014"}, d2={"collectFiles", "", "rootFile", "Ljava/io/File;", "target", "", "main", "args", "", "", "([Ljava/lang/String;)V", "mergeStdlibParts", "outputFile", "wrapperFile", "baseDir", "inputPaths", "", "createInsertionPlace", "Lorg/jetbrains/kotlin/js/backend/ast/JsBlock;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "cli-js"})
@JvmName(name="JSStdlibLinker")
public final class JSStdlibLinker {
    /*
     * WARNING - void declaration
     */
    public static final void main(@NotNull String[] args2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(args2, "args");
        File outputFile = new File(args2[0]);
        File baseDir = new File(args2[1]).getCanonicalFile();
        File wrapperFile = new File(args2[2]);
        Iterable $this$map$iv = ArraysKt.drop(args2, 3);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            File file2 = new File((String)it);
            collection.add(file2);
        }
        List inputPaths = (List)destination$iv$iv;
        Intrinsics.checkNotNullExpressionValue(baseDir, "baseDir");
        JSStdlibLinker.mergeStdlibParts(outputFile, wrapperFile, baseDir, inputPaths);
    }

    /*
     * WARNING - void declaration
     */
    private static final void mergeStdlibParts(File outputFile, File wrapperFile, File baseDir, List<? extends File> inputPaths) {
        void $this$toTypedArray$iv;
        Collection<JsonNode> collection;
        void $this$mapTo$iv$iv;
        Object object;
        Object element$iv;
        JsProgram program = new JsProgram();
        String string2 = FilesKt.readText$default(wrapperFile, null, 1, null);
        ErrorReporter errorReporter = ThrowExceptionOnErrorReporter.INSTANCE;
        JsObjectScope jsObjectScope = program.getScope();
        Intrinsics.checkNotNullExpressionValue(jsObjectScope, "program.scope");
        List<JsStatement> list2 = ParserUtilsKt.parse(string2, errorReporter, jsObjectScope, JSStdlibLinker.mergeStdlibParts$relativizeIfNecessary(wrapperFile, baseDir));
        Intrinsics.checkNotNull(list2);
        List<JsStatement> wrapper = list2;
        JsBlock insertionPlace = JSStdlibLinker.createInsertionPlace(wrapper);
        List allFiles = new ArrayList();
        Object $this$forEach$iv = inputPaths;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            element$iv = iterator2.next();
            File it = (File)element$iv;
            boolean bl = false;
            JSStdlibLinker.collectFiles(it, allFiles);
        }
        for (File file2 : allFiles) {
            Object sourceMapParse;
            List<JsStatement> statements2;
            String string3 = FilesKt.readText$default(file2, null, 1, null);
            ErrorReporter errorReporter2 = ThrowExceptionOnErrorReporter.INSTANCE;
            element$iv = program.getScope();
            Intrinsics.checkNotNullExpressionValue(element$iv, "program.scope");
            Intrinsics.checkNotNull(ParserUtilsKt.parse(string3, errorReporter2, (JsScope)element$iv, JSStdlibLinker.mergeStdlibParts$relativizeIfNecessary(file2, baseDir)));
            JsBlock block = new JsBlock(statements2);
            FixForwardNameReferencesKt.fixForwardNameReferences(block);
            File sourceMapFile = new File(file2.getParent(), Intrinsics.stringPlus(file2.getName(), ".map"));
            if (sourceMapFile.exists()) {
                sourceMapParse = SourceMapParser.INSTANCE.parse(sourceMapFile);
                object = sourceMapParse;
                if (object instanceof SourceMapError) {
                    System.err.println("Error parsing source map file " + sourceMapFile + ": " + ((SourceMapError)sourceMapParse).getMessage());
                    int n = 1;
                    System.exit(n);
                    throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
                }
                if (object instanceof SourceMapSuccess) {
                    SourceMap sourceMap2 = ((SourceMapSuccess)sourceMapParse).getValue();
                    SourceMapLocationRemapper remapper2 = new SourceMapLocationRemapper(sourceMap2, null, 2, null);
                    remapper2.remap(block);
                }
            }
            sourceMapParse = insertionPlace;
            object = ((JsBlock)sourceMapParse).getStatements();
            Intrinsics.checkNotNullExpressionValue(object, "insertionPlace.statements");
            object = (Collection)object;
            CollectionsKt.addAll(object, (Iterable)statements2);
        }
        $this$forEach$iv = program.getGlobalBlock();
        Collection<JsStatement> file2 = ((JsBlock)$this$forEach$iv).getStatements();
        Intrinsics.checkNotNullExpressionValue(file2, "program.globalBlock.statements");
        file2 = file2;
        CollectionsKt.addAll(file2, (Iterable)wrapper);
        File sourceMapFile = new File(outputFile.getParentFile(), Intrinsics.stringPlus(outputFile.getName(), ".map"));
        TextOutputImpl textOutput = new TextOutputImpl();
        SourceMap3Builder sourceMapBuilder = new SourceMap3Builder(outputFile, textOutput, "");
        SourceMapBuilderConsumer consumer = new SourceMapBuilderConsumer(new File("."), sourceMapBuilder, new SourceFilePathResolver(new ArrayList()), true, true);
        program.getGlobalBlock().accept(new JsToStringGenerationVisitor(textOutput, consumer));
        String sourceMapContent = sourceMapBuilder.build();
        object = textOutput.toString();
        Intrinsics.checkNotNullExpressionValue(object, "textOutput.toString()");
        Object programText = object;
        FilesKt.writeText$default(outputFile, (String)programText + "\n//# sourceMappingURL=" + sourceMapFile.getName() + '\n', null, 2, null);
        Intrinsics.checkNotNullExpressionValue(sourceMapContent, "sourceMapContent");
        JsonNode sourceMapJson = JSONKt.parseJson(sourceMapContent);
        Object object2 = ((JsonObject)sourceMapJson).getProperties().get("sources");
        if (object2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.js.parser.sourcemaps.JsonArray");
        }
        JsonArray sources = (JsonArray)object2;
        object2 = ((JsonObject)sourceMapJson).getProperties();
        String string4 = "sourcesContent";
        Iterable $this$map$iv = sources.getElements();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void sourcePath;
            JsonNode jsonNode = (JsonNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            File sourceFile = new File(((JsonString)sourcePath).getValue());
            JsonNode jsonNode2 = sourceFile.exists() ? (JsonNode)new JsonString(FilesKt.readText$default(sourceFile, null, 1, null)) : (JsonNode)JsonNull.INSTANCE;
            collection.add(jsonNode2);
        }
        collection = (List)destination$iv$iv;
        $this$map$iv = collection;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        JsonNode[] jsonNodeArray = thisCollection$iv.toArray(new JsonNode[0]);
        if (jsonNodeArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        Object object3 = jsonNodeArray;
        JsonNode[] jsonNodeArray2 = Arrays.copyOf(object3, ((JsonNode[])object3).length);
        object3 = new JsonArray(jsonNodeArray2);
        object2.put(string4, object3);
        FilesKt.writeText$default(sourceMapFile, sourceMapJson.toString(), null, 2, null);
    }

    private static final JsBlock createInsertionPlace(List<? extends JsStatement> $this$createInsertionPlace) {
        JsGlobalBlock block = new JsGlobalBlock();
        JsVisitorWithContextImpl visitor2 = new JsVisitorWithContextImpl(block){
            final /* synthetic */ JsGlobalBlock $block;
            {
                this.$block = $block;
            }

            public boolean visit(@NotNull JsExpressionStatement x, @NotNull JsContext<? super JsStatement> ctx2) {
                Intrinsics.checkNotNullParameter(x, "x");
                Intrinsics.checkNotNullParameter(ctx2, "ctx");
                JsExpression jsExpression = x.getExpression();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "x.expression");
                if (this.isInsertionPlace(jsExpression)) {
                    ctx2.replaceMe((JsNode)this.$block);
                    return false;
                }
                return super.visit(x, ctx2);
            }

            private final boolean isInsertionPlace(JsExpression expression2) {
                if (!(expression2 instanceof JsInvocation) || !((JsInvocation)expression2).getArguments().isEmpty()) {
                    return false;
                }
                JsExpression jsExpression = ((JsInvocation)expression2).getQualifier();
                Intrinsics.checkNotNullExpressionValue(jsExpression, "expression.qualifier");
                JsExpression qualifier = jsExpression;
                if (!(qualifier instanceof JsNameRef) || ((JsNameRef)qualifier).getQualifier() != null) {
                    return false;
                }
                return Intrinsics.areEqual(((JsNameRef)qualifier).getIdent(), "insertContent");
            }
        };
        for (JsStatement jsStatement : $this$createInsertionPlace) {
            visitor2.accept((JsNode)jsStatement);
        }
        return block;
    }

    private static final void collectFiles(File rootFile, List<File> target) {
        if (rootFile.isDirectory()) {
            File[] fileArray = rootFile.listFiles();
            Intrinsics.checkNotNullExpressionValue(fileArray, "rootFile.listFiles()");
            for (File child : ArraysKt.sorted((Comparable[])fileArray)) {
                Intrinsics.checkNotNullExpressionValue(child, "child");
                JSStdlibLinker.collectFiles(child, target);
            }
        } else if (Intrinsics.areEqual(FilesKt.getExtension(rootFile), "js")) {
            Collection collection = target;
            collection.add(rootFile);
        }
    }

    private static final String mergeStdlibParts$relativizeIfNecessary(File $this$mergeStdlibParts_u24relativizeIfNecessary, File $baseDir) {
        File file2 = $this$mergeStdlibParts_u24relativizeIfNecessary.getCanonicalFile();
        Intrinsics.checkNotNullExpressionValue(file2, "canonicalFile");
        return FilesKt.toRelativeString(file2, $baseDir);
    }
}

