/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.AnnotationDescriptor;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.constants.ConstantValue;
import kotlin.reflect.jvm.internal.impl.serialization.SerializerExtensionProtocol;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationAndConstantLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AnnotationAndConstantLoaderImpl
implements AnnotationAndConstantLoader<AnnotationDescriptor, ConstantValue<?>> {
    @NotNull
    private final SerializerExtensionProtocol protocol;
    @NotNull
    private final AnnotationDeserializer deserializer;

    public AnnotationAndConstantLoaderImpl(@NotNull ModuleDescriptor module2, @NotNull NotFoundClasses notFoundClasses, @NotNull SerializerExtensionProtocol protocol) {
        Intrinsics.checkNotNullParameter(module2, "module");
        Intrinsics.checkNotNullParameter(notFoundClasses, "notFoundClasses");
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        this.protocol = protocol;
        this.deserializer = new AnnotationDeserializer(module2, notFoundClasses);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadClassAnnotations(@NotNull ProtoContainer.Class container) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(container, "container");
        List<ProtoBuf.Annotation> list2 = container.getClassProto().getExtension(this.protocol.getClassAnnotation());
        List<Object> annotations2 = list2 == null ? CollectionsKt.emptyList() : list2;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void proto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)proto, container.getNameResolver());
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadCallableAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        void $this$mapTo$iv$iv;
        Object object;
        List<ProtoBuf.Annotation> list2;
        block7: {
            block9: {
                MessageLite messageLite;
                block8: {
                    block6: {
                        Intrinsics.checkNotNullParameter(container, "container");
                        Intrinsics.checkNotNullParameter(proto, "proto");
                        Intrinsics.checkNotNullParameter((Object)kind, "kind");
                        messageLite = proto;
                        if (!(messageLite instanceof ProtoBuf.Constructor)) break block6;
                        list2 = ((ProtoBuf.Constructor)proto).getExtension(this.protocol.getConstructorAnnotation());
                        break block7;
                    }
                    if (!(messageLite instanceof ProtoBuf.Function)) break block8;
                    list2 = ((ProtoBuf.Function)proto).getExtension(this.protocol.getFunctionAnnotation());
                    break block7;
                }
                if (!(messageLite instanceof ProtoBuf.Property)) break block9;
                object = kind;
                int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object).ordinal()];
                switch (n) {
                    case 1: {
                        list2 = ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyAnnotation());
                        break block7;
                    }
                    case 2: {
                        list2 = ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertyGetterAnnotation());
                        break block7;
                    }
                    case 3: {
                        list2 = ((ProtoBuf.Property)proto).getExtension(this.protocol.getPropertySetterAnnotation());
                        break block7;
                    }
                    default: {
                        throw new IllegalStateException("Unsupported callable kind with property proto".toString());
                    }
                }
            }
            throw new IllegalStateException(Intrinsics.stringPlus("Unknown message: ", proto).toString());
        }
        object = list2;
        Object annotations2 = object == null ? CollectionsKt.emptyList() : object;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void annotationProto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)annotationProto, container.getNameResolver());
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadPropertyBackingFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(proto, "proto");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadPropertyDelegateFieldAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(proto, "proto");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadEnumEntryAnnotations(@NotNull ProtoContainer container, @NotNull ProtoBuf.EnumEntry proto) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(proto, "proto");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getEnumEntryAnnotation());
        List<Object> annotations2 = list2 == null ? CollectionsKt.emptyList() : list2;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void annotationProto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)annotationProto, container.getNameResolver());
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadValueParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite callableProto, @NotNull AnnotatedCallableKind kind, int parameterIndex, @NotNull ProtoBuf.ValueParameter proto) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(callableProto, "callableProto");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        Intrinsics.checkNotNullParameter(proto, "proto");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getParameterAnnotation());
        List<Object> annotations2 = list2 == null ? CollectionsKt.emptyList() : list2;
        Iterable $this$map$iv = annotations2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void annotationProto;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)annotationProto, container.getNameResolver());
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<AnnotationDescriptor> loadExtensionReceiverParameterAnnotations(@NotNull ProtoContainer container, @NotNull MessageLite proto, @NotNull AnnotatedCallableKind kind) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter((Object)kind, "kind");
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeAnnotations(@NotNull ProtoBuf.Type proto, @NotNull NameResolver nameResolver2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getTypeAnnotation());
        Iterable $this$map$iv = list2 == null ? CollectionsKt.emptyList() : list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver2);
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<AnnotationDescriptor> loadTypeParameterAnnotations(@NotNull ProtoBuf.TypeParameter proto, @NotNull NameResolver nameResolver2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(nameResolver2, "nameResolver");
        List<ProtoBuf.Annotation> list2 = proto.getExtension(this.protocol.getTypeParameterAnnotation());
        Iterable $this$map$iv = list2 == null ? CollectionsKt.emptyList() : list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ProtoBuf.Annotation annotation2 = (ProtoBuf.Annotation)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotationDescriptor annotationDescriptor = this.deserializer.deserializeAnnotation((ProtoBuf.Annotation)it, nameResolver2);
            collection.add(annotationDescriptor);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @Nullable
    public ConstantValue<?> loadPropertyConstant(@NotNull ProtoContainer container, @NotNull ProtoBuf.Property proto, @NotNull KotlinType expectedType2) {
        Intrinsics.checkNotNullParameter(container, "container");
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
        ProtoBuf.Annotation.Argument.Value value2 = ProtoBufUtilKt.getExtensionOrNull(proto, this.protocol.getCompileTimeValue());
        if (value2 == null) {
            return null;
        }
        ProtoBuf.Annotation.Argument.Value value3 = value2;
        return this.deserializer.resolveValue(expectedType2, value3, container.getNameResolver());
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotatedCallableKind.values().length];
            nArray[AnnotatedCallableKind.PROPERTY.ordinal()] = 1;
            nArray[AnnotatedCallableKind.PROPERTY_GETTER.ordinal()] = 2;
            nArray[AnnotatedCallableKind.PROPERTY_SETTER.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

