/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmType;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

final class JvmTypeFactoryImpl
implements JvmTypeFactory<JvmType> {
    @NotNull
    public static final JvmTypeFactoryImpl INSTANCE = new JvmTypeFactoryImpl();

    private JvmTypeFactoryImpl() {
    }

    @Override
    @NotNull
    public JvmType boxType(@NotNull JvmType possiblyPrimitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter(possiblyPrimitiveType, "possiblyPrimitiveType");
        if (possiblyPrimitiveType instanceof JvmType.Primitive && ((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType() != null) {
            String string2 = JvmClassName.byFqNameWithoutInnerClasses(((JvmType.Primitive)possiblyPrimitiveType).getJvmPrimitiveType().getWrapperFqName()).getInternalName();
            Intrinsics.checkNotNullExpressionValue(string2, "byFqNameWithoutInnerClas\u2026apperFqName).internalName");
            jvmType = this.createObjectType(string2);
        } else {
            jvmType = possiblyPrimitiveType;
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createFromString(@NotNull String representation) {
        JvmType jvmType;
        JvmPrimitiveType jvmPrimitiveType;
        char firstChar;
        block8: {
            JvmPrimitiveType jvmPrimitiveType2;
            boolean bl;
            Intrinsics.checkNotNullParameter(representation, "representation");
            boolean bl2 = bl = ((CharSequence)representation).length() > 0;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string2 = "empty string as JvmType";
                throw new AssertionError((Object)string2);
            }
            firstChar = representation.charAt(0);
            JvmPrimitiveType[] $this$firstOrNull$iv = JvmPrimitiveType.values();
            boolean $i$f$firstOrNull = false;
            for (JvmPrimitiveType element$iv : $this$firstOrNull$iv) {
                JvmPrimitiveType it = element$iv;
                boolean bl4 = false;
                if (!(it.getDesc().charAt(0) == firstChar)) continue;
                jvmPrimitiveType2 = element$iv;
                break block8;
            }
            jvmPrimitiveType2 = jvmPrimitiveType = null;
        }
        if (jvmPrimitiveType != null) {
            JvmPrimitiveType jvmPrimitiveType3;
            JvmPrimitiveType it = jvmPrimitiveType3 = jvmPrimitiveType;
            boolean bl = false;
            return new JvmType.Primitive(it);
        }
        char c = firstChar;
        if (c == 'V') {
            jvmType = new JvmType.Primitive(null);
        } else if (c == '[') {
            String string2 = representation.substring(1);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            jvmType = new JvmType.Array(this.createFromString(string2));
        } else {
            boolean bl;
            boolean bl3 = bl = firstChar == 'L' && StringsKt.endsWith$default((CharSequence)representation, ';', false, 2, null);
            if (_Assertions.ENABLED && !bl) {
                boolean bl6 = false;
                String string3 = "Type that is not primitive nor array should be Object, but '" + representation + "' was found";
                throw new AssertionError((Object)string3);
            }
            String string3 = representation.substring(1, representation.length() - 1);
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            jvmType = new JvmType.Object(string3);
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType createPrimitiveType(@NotNull PrimitiveType primitiveType) {
        JvmType jvmType;
        Intrinsics.checkNotNullParameter((Object)primitiveType, "primitiveType");
        PrimitiveType primitiveType2 = primitiveType;
        int n = WhenMappings.$EnumSwitchMapping$0[primitiveType2.ordinal()];
        switch (n) {
            case 1: {
                jvmType = JvmType.Companion.getBOOLEAN$descriptors_jvm();
                break;
            }
            case 2: {
                jvmType = JvmType.Companion.getCHAR$descriptors_jvm();
                break;
            }
            case 3: {
                jvmType = JvmType.Companion.getBYTE$descriptors_jvm();
                break;
            }
            case 4: {
                jvmType = JvmType.Companion.getSHORT$descriptors_jvm();
                break;
            }
            case 5: {
                jvmType = JvmType.Companion.getINT$descriptors_jvm();
                break;
            }
            case 6: {
                jvmType = JvmType.Companion.getFLOAT$descriptors_jvm();
                break;
            }
            case 7: {
                jvmType = JvmType.Companion.getLONG$descriptors_jvm();
                break;
            }
            case 8: {
                jvmType = JvmType.Companion.getDOUBLE$descriptors_jvm();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return jvmType;
    }

    @Override
    @NotNull
    public JvmType.Object createObjectType(@NotNull String internalName2) {
        Intrinsics.checkNotNullParameter(internalName2, "internalName");
        return new JvmType.Object(internalName2);
    }

    @Override
    @NotNull
    public String toString(@NotNull JvmType type2) {
        String string2;
        Intrinsics.checkNotNullParameter(type2, "type");
        JvmType jvmType = type2;
        if (jvmType instanceof JvmType.Array) {
            string2 = Intrinsics.stringPlus("[", this.toString(((JvmType.Array)type2).getElementType()));
        } else if (jvmType instanceof JvmType.Primitive) {
            JvmPrimitiveType jvmPrimitiveType = ((JvmType.Primitive)type2).getJvmPrimitiveType();
            String string3 = jvmPrimitiveType == null ? "V" : jvmPrimitiveType.getDesc();
            Intrinsics.checkNotNullExpressionValue(string3, "type.jvmPrimitiveType?.desc ?: \"V\"");
            string2 = string3;
        } else if (jvmType instanceof JvmType.Object) {
            string2 = 'L' + ((JvmType.Object)type2).getInternalName() + ';';
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @Override
    @NotNull
    public JvmType getJavaLangClassType() {
        return this.createObjectType("java/lang/Class");
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PrimitiveType.values().length];
            nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            nArray[PrimitiveType.CHAR.ordinal()] = 2;
            nArray[PrimitiveType.BYTE.ordinal()] = 3;
            nArray[PrimitiveType.SHORT.ordinal()] = 4;
            nArray[PrimitiveType.INT.ordinal()] = 5;
            nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            nArray[PrimitiveType.LONG.ordinal()] = 7;
            nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

