/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.Set;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializationComponentsForJava;
import kotlin.reflect.jvm.internal.impl.load.kotlin.DeserializedDescriptorResolver;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.header.KotlinClassHeader;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmNameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.protobuf.InvalidProtocolBufferException;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.IncompatibleVersionErrorData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedContainerAbiStability;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedPackageMemberScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DeserializedDescriptorResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public DeserializationComponents components;
    @NotNull
    private static final Set<KotlinClassHeader.Kind> KOTLIN_CLASS = SetsKt.setOf(KotlinClassHeader.Kind.CLASS);
    @NotNull
    private static final Set<KotlinClassHeader.Kind> KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART;
    @NotNull
    private static final JvmMetadataVersion KOTLIN_1_1_EAP_METADATA_VERSION;
    @NotNull
    private static final JvmMetadataVersion KOTLIN_1_3_M1_METADATA_VERSION;
    @NotNull
    private static final JvmMetadataVersion KOTLIN_1_3_RC_METADATA_VERSION;

    @NotNull
    public final DeserializationComponents getComponents() {
        DeserializationComponents deserializationComponents = this.components;
        if (deserializationComponents != null) {
            return deserializationComponents;
        }
        Intrinsics.throwUninitializedPropertyAccessException("components");
        return null;
    }

    public final void setComponents(@NotNull DeserializationComponents deserializationComponents) {
        Intrinsics.checkNotNullParameter(deserializationComponents, "<set-?>");
        this.components = deserializationComponents;
    }

    public final void setComponents(@NotNull DeserializationComponentsForJava components2) {
        Intrinsics.checkNotNullParameter(components2, "components");
        this.setComponents(components2.getComponents());
    }

    private final boolean getSkipMetadataVersionCheck() {
        return this.getComponents().getConfiguration().getSkipMetadataVersionCheck();
    }

    @Nullable
    public final ClassDescriptor resolveClass(@NotNull KotlinJvmBinaryClass kotlinClass2) {
        Intrinsics.checkNotNullParameter(kotlinClass2, "kotlinClass");
        ClassData classData = this.readClassData$descriptors_jvm(kotlinClass2);
        if (classData == null) {
            return null;
        }
        ClassData classData2 = classData;
        return this.getComponents().getClassDeserializer().deserializeClass(kotlinClass2.getClassId(), classData2);
    }

    @Nullable
    public final ClassData readClassData$descriptors_jvm(@NotNull KotlinJvmBinaryClass kotlinClass2) {
        Pair<JvmNameResolver, ProtoBuf.Class> pair;
        Pair<JvmNameResolver, ProtoBuf.Class> pair2;
        Intrinsics.checkNotNullParameter(kotlinClass2, "kotlinClass");
        String[] stringArray = this.readData(kotlinClass2, KOTLIN_CLASS);
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        Object object = kotlinClass2.getClassHeader().getStrings();
        if (object == null) {
            return null;
        }
        String[] strings2 = object;
        DeserializedDescriptorResolver this_$iv = this;
        boolean $i$f$parseProto = false;
        try {
            try {
                boolean bl = false;
                pair2 = JvmProtoBufUtil.readClassDataFrom(data2, strings2);
            }
            catch (InvalidProtocolBufferException e$iv) {
                throw new IllegalStateException(Intrinsics.stringPlus("Could not read data from ", kotlinClass2.getLocation()), e$iv);
            }
        }
        catch (Throwable e$iv) {
            if (this_$iv.getSkipMetadataVersionCheck() || kotlinClass2.getClassHeader().getMetadataVersion().isCompatible()) {
                throw e$iv;
            }
            pair2 = null;
        }
        if ((pair = pair2) == null) {
            return null;
        }
        object = pair;
        JvmNameResolver nameResolver2 = (JvmNameResolver)((Pair)object).component1();
        ProtoBuf.Class classProto = (ProtoBuf.Class)((Pair)object).component2();
        KotlinJvmBinarySourceElement source = new KotlinJvmBinarySourceElement(kotlinClass2, this.getIncompatibility(kotlinClass2), this.isPreReleaseInvisible(kotlinClass2), this.getAbiStability(kotlinClass2));
        return new ClassData(nameResolver2, classProto, kotlinClass2.getClassHeader().getMetadataVersion(), source);
    }

    @Nullable
    public final MemberScope createKotlinPackagePartScope(@NotNull PackageFragmentDescriptor descriptor2, @NotNull KotlinJvmBinaryClass kotlinClass2) {
        Pair<JvmNameResolver, ProtoBuf.Package> pair;
        Pair<JvmNameResolver, ProtoBuf.Package> pair2;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(kotlinClass2, "kotlinClass");
        String[] stringArray = this.readData(kotlinClass2, KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART);
        if (stringArray == null) {
            return null;
        }
        String[] data2 = stringArray;
        Object object = kotlinClass2.getClassHeader().getStrings();
        if (object == null) {
            return null;
        }
        String[] strings2 = object;
        DeserializedDescriptorResolver this_$iv = this;
        boolean $i$f$parseProto = false;
        try {
            try {
                boolean bl = false;
                pair2 = JvmProtoBufUtil.readPackageDataFrom(data2, strings2);
            }
            catch (InvalidProtocolBufferException e$iv) {
                throw new IllegalStateException(Intrinsics.stringPlus("Could not read data from ", kotlinClass2.getLocation()), e$iv);
            }
        }
        catch (Throwable e$iv) {
            if (this_$iv.getSkipMetadataVersionCheck() || kotlinClass2.getClassHeader().getMetadataVersion().isCompatible()) {
                throw e$iv;
            }
            pair2 = null;
        }
        if ((pair = pair2) == null) {
            return null;
        }
        object = pair;
        JvmNameResolver nameResolver2 = (JvmNameResolver)((Pair)object).component1();
        ProtoBuf.Package packageProto = (ProtoBuf.Package)((Pair)object).component2();
        JvmPackagePartSource source = new JvmPackagePartSource(kotlinClass2, packageProto, nameResolver2, this.getIncompatibility(kotlinClass2), this.isPreReleaseInvisible(kotlinClass2), this.getAbiStability(kotlinClass2));
        return new DeserializedPackageMemberScope(descriptor2, packageProto, nameResolver2, kotlinClass2.getClassHeader().getMetadataVersion(), source, this.getComponents(), "scope for " + source + " in " + descriptor2, createKotlinPackagePartScope.2.INSTANCE);
    }

    private final IncompatibleVersionErrorData<JvmMetadataVersion> getIncompatibility(KotlinJvmBinaryClass $this$incompatibility) {
        if (this.getSkipMetadataVersionCheck() || $this$incompatibility.getClassHeader().getMetadataVersion().isCompatible()) {
            return null;
        }
        return new IncompatibleVersionErrorData<JvmMetadataVersion>($this$incompatibility.getClassHeader().getMetadataVersion(), JvmMetadataVersion.INSTANCE, $this$incompatibility.getLocation(), $this$incompatibility.getClassId());
    }

    private final boolean isPreReleaseInvisible(KotlinJvmBinaryClass $this$isPreReleaseInvisible) {
        return this.getComponents().getConfiguration().getReportErrorsOnPreReleaseDependencies() && ($this$isPreReleaseInvisible.getClassHeader().isPreRelease() || Intrinsics.areEqual($this$isPreReleaseInvisible.getClassHeader().getMetadataVersion(), KOTLIN_1_1_EAP_METADATA_VERSION)) || this.isCompiledWith13M1($this$isPreReleaseInvisible);
    }

    private final boolean isCompiledWith13M1(KotlinJvmBinaryClass $this$isCompiledWith13M1) {
        return !this.getComponents().getConfiguration().getSkipPrereleaseCheck() && $this$isCompiledWith13M1.getClassHeader().isPreRelease() && Intrinsics.areEqual($this$isCompiledWith13M1.getClassHeader().getMetadataVersion(), KOTLIN_1_3_M1_METADATA_VERSION);
    }

    private final DeserializedContainerAbiStability getAbiStability(KotlinJvmBinaryClass $this$abiStability) {
        return this.getComponents().getConfiguration().getAllowUnstableDependencies() ? DeserializedContainerAbiStability.STABLE : ($this$abiStability.getClassHeader().isUnstableFirBinary() ? DeserializedContainerAbiStability.FIR_UNSTABLE : ($this$abiStability.getClassHeader().isUnstableJvmIrBinary() ? DeserializedContainerAbiStability.IR_UNSTABLE : DeserializedContainerAbiStability.STABLE));
    }

    private final String[] readData(KotlinJvmBinaryClass kotlinClass2, Set<? extends KotlinClassHeader.Kind> expectedKinds) {
        Object object;
        String[] stringArray;
        KotlinClassHeader header = kotlinClass2.getClassHeader();
        String[] stringArray2 = header.getData();
        String[] stringArray3 = stringArray = stringArray2 == null ? header.getIncompatibleData() : stringArray2;
        if (stringArray == null) {
            object = null;
        } else {
            String[] it = stringArray2 = stringArray;
            boolean bl = false;
            object = expectedKinds.contains((Object)header.getKind()) ? stringArray2 : null;
        }
        return object;
    }

    static {
        Object[] objectArray = new KotlinClassHeader.Kind[]{KotlinClassHeader.Kind.FILE_FACADE, KotlinClassHeader.Kind.MULTIFILE_CLASS_PART};
        KOTLIN_FILE_FACADE_OR_MULTIFILE_CLASS_PART = SetsKt.setOf(objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)2;
        KOTLIN_1_1_EAP_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)11;
        KOTLIN_1_3_M1_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
        objectArray = new int[3];
        objectArray[0] = (KotlinClassHeader.Kind)true;
        objectArray[1] = (KotlinClassHeader.Kind)true;
        objectArray[2] = (KotlinClassHeader.Kind)13;
        KOTLIN_1_3_RC_METADATA_VERSION = new JvmMetadataVersion((int[])objectArray);
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JvmMetadataVersion getKOTLIN_1_3_RC_METADATA_VERSION$descriptors_jvm() {
            return KOTLIN_1_3_RC_METADATA_VERSION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

