/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.utils;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClassifier;
import kotlin.reflect.KParameter;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.utils.ArgsConverter;
import org.jetbrains.kotlin.utils.NamedArgument;
import org.jetbrains.kotlin.utils.ParametersMapKt;
import org.jetbrains.kotlin.utils.StringArgsConverter;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016J2\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0012\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\t0\rH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/utils/StringArgsConverter;", "Lorg/jetbrains/kotlin/utils/ArgsConverter;", "", "()V", "tryConvertSingle", "Lorg/jetbrains/kotlin/utils/ArgsConverter$Result;", "parameter", "Lkotlin/reflect/KParameter;", "arg", "Lorg/jetbrains/kotlin/utils/NamedArgument;", "tryConvertTail", "firstArg", "restArgs", "Lkotlin/sequences/Sequence;", "tryConvertVararg", "cli-common"})
final class StringArgsConverter
implements ArgsConverter<String> {
    @Override
    @NotNull
    public ArgsConverter.Result tryConvertSingle(@NotNull KParameter parameter, @NotNull NamedArgument<String> arg) {
        Object object;
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(arg, "arg");
        String string2 = arg.getValue();
        if (string2 == null) {
            return new ArgsConverter.Result.Success((Object)null);
        }
        String value2 = string2;
        KClassifier kClassifier = parameter.getType().getClassifier();
        if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(String.class))) {
            object = value2;
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
            object = StringsKt.toIntOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Long.TYPE))) {
            object = StringsKt.toLongOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Short.TYPE))) {
            object = StringsKt.toShortOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Byte.TYPE))) {
            object = StringsKt.toByteOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Character.TYPE))) {
            object = StringsKt.singleOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Float.TYPE))) {
            object = StringsKt.toFloatOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Double.TYPE))) {
            object = StringsKt.toDoubleOrNull(value2);
        } else if (Intrinsics.areEqual(kClassifier, Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
            String string3 = value2;
            boolean bl = false;
            object = Boolean.parseBoolean(string3);
        } else {
            object = null;
        }
        String primitive = object;
        return primitive != null ? (ArgsConverter.Result)new ArgsConverter.Result.Success(primitive) : (ArgsConverter.Result)ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertVararg(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        KType parameterType = parameter.getType();
        if (JvmClassMappingKt.getJavaClass(KTypesJvm.getJvmErasure(parameterType)).isArray()) {
            String[] arrayArgCandidate;
            String[] stringArray;
            KType arrayElementType;
            String[] stringArray2 = new String[]{firstArg.getValue()};
            Sequence<String> argsSequence2 = SequencesKt.plus(SequencesKt.sequenceOf(stringArray2), SequencesKt.map(restArgs, tryConvertVararg.argsSequence.1.INSTANCE));
            Object primArrayArgCandidate = StringArgsConverter.tryConvertVararg$convertPrimitivesArray(parameterType, argsSequence2);
            if (primArrayArgCandidate != null) {
                return new ArgsConverter.Result.Success(primArrayArgCandidate);
            }
            KTypeProjection kTypeProjection = CollectionsKt.firstOrNull(parameterType.getArguments());
            KType kType = arrayElementType = kTypeProjection == null ? null : kTypeProjection.getType();
            KClassifier classifier$iv = kType == null ? null : kType.getClassifier();
            boolean $i$f$convertAnyArray = false;
            if (Intrinsics.areEqual(classifier$iv, Reflection.getOrCreateKotlinClass(String.class))) {
                Collection $this$toTypedArray$iv$iv = SequencesKt.toList(argsSequence2);
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv$iv = $this$toTypedArray$iv$iv;
                stringArray = thisCollection$iv$iv.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
            } else {
                stringArray = ParametersMapKt.access$convertAnyArrayImpl(classifier$iv, argsSequence2);
            }
            if ((arrayArgCandidate = stringArray) != null) {
                return new ArgsConverter.Result.Success(arrayArgCandidate);
            }
        }
        return ArgsConverter.Result.Failure.INSTANCE;
    }

    @Override
    @NotNull
    public ArgsConverter.Result tryConvertTail(@NotNull KParameter parameter, @NotNull NamedArgument<String> firstArg, @NotNull Sequence<NamedArgument<String>> restArgs) {
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        Intrinsics.checkNotNullParameter(firstArg, "firstArg");
        Intrinsics.checkNotNullParameter(restArgs, "restArgs");
        return this.tryConvertVararg(parameter, firstArg, restArgs);
    }

    private static final Object tryConvertVararg$convertPrimitivesArray(KType type2, Sequence<String> args2) {
        Object[] objectArray;
        List list2;
        Object object = type2.getClassifier();
        Object object2 = Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(int[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.1.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(long[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.2.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(short[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.3.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(byte[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.4.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(char[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.5.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(float[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.6.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(double[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.7.INSTANCE) : (Intrinsics.areEqual(object, Reflection.getOrCreateKotlinClass(boolean[].class)) ? SequencesKt.map(args2, tryConvertVararg.convertPrimitivesArray.8.INSTANCE) : null)))))));
        List list3 = list2 = object2 == null ? null : SequencesKt.toList(object2);
        if (list2 == null) {
            objectArray = null;
        } else {
            object = list2;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            Object object3 = object2 = !it.contains(null) ? object : null;
            if (object2 == null) {
                objectArray = null;
            } else {
                Collection $this$toTypedArray$iv = (Collection)object2;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                objectArray = thisCollection$iv.toArray(new Object[0]);
                if (objectArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                }
            }
        }
        return objectArray;
    }
}

