/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.contracts.description.AbstractContractProvider;
import org.jetbrains.kotlin.contracts.description.CallsEffectDeclaration;
import org.jetbrains.kotlin.contracts.description.ContractDescription;
import org.jetbrains.kotlin.contracts.description.ContractProviderKey;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRange;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.AnonymousFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.impl.DeclarationDescriptorNonRootImpl;
import org.jetbrains.kotlin.descriptors.impl.LocalVariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.Call;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtDeclarationStub;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CapturingInClosureCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.model.VariableAsFunctionResolvedCall;
import org.jetbrains.kotlin.resolve.inline.InlineUtil;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.expressions.CaptureKind;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J(\u0010\u0012\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\bH\u0002J&\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u00172\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J(\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\t\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0018\u0010#\u001a\u00020\"2\u0006\u0010 \u001a\u00020\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010%\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\"2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\rH\u0002J\u0010\u0010*\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010+\u001a\u00020\"2\u0006\u0010\u0015\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006."}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/CapturingInClosureChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCapturingInClosure", "variable", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "scope", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScope;", "checkFieldInExactlyOnceLambdaInitialization", "scopeContainer", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "nameElement", "getCalleeDescriptorAndParameter", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "argument", "Lorg/jetbrains/kotlin/psi/KtFunction;", "getCaptureKind", "Lorg/jetbrains/kotlin/types/expressions/CaptureKind;", "variableParent", "isArgument", "", "isCapturedVariable", "isCatchBlockParameter", "isCrossinlineParameter", "isExactlyOnceContract", "isExactlyOnceParameter", "function", "parameter", "isForLoopParameter", "isLhsOfAssignment", "Lorg/jetbrains/kotlin/psi/KtExpression;", "isValInWhen", "frontend"})
public final class CapturingInClosureChecker
implements CallChecker {
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context2) {
        VariableDescriptor variableDescriptor;
        ResolvedCall<VariableDescriptor> resolvedCall3;
        VariableAsFunctionResolvedCall variableAsFunctionResolvedCall;
        Intrinsics.checkNotNullParameter(resolvedCall2, "resolvedCall");
        Intrinsics.checkNotNullParameter(reportOn, "reportOn");
        Intrinsics.checkNotNullParameter(context2, "context");
        VariableAsFunctionResolvedCall variableAsFunctionResolvedCall2 = variableAsFunctionResolvedCall = resolvedCall2 instanceof VariableAsFunctionResolvedCall ? (VariableAsFunctionResolvedCall)((Object)resolvedCall2) : null;
        ResolvedCall<?> variableResolvedCall = variableAsFunctionResolvedCall == null ? resolvedCall2 : ((resolvedCall3 = variableAsFunctionResolvedCall.getVariableCall()) == null ? resolvedCall2 : resolvedCall3);
        resolvedCall3 = variableResolvedCall.getResultingDescriptor();
        VariableDescriptor variableDescriptor2 = variableDescriptor = resolvedCall3 instanceof VariableDescriptor ? (VariableDescriptor)((Object)resolvedCall3) : null;
        if (variableDescriptor != null) {
            this.checkCapturingInClosure(variableDescriptor, context2.getTrace(), context2.getScope());
            this.checkFieldInExactlyOnceLambdaInitialization(variableDescriptor, context2.getTrace(), context2.getScope().getOwnerDescriptor(), reportOn);
        }
    }

    private final void checkCapturingInClosure(VariableDescriptor variable2, BindingTrace trace, LexicalScope scope2) {
        DeclarationDescriptor declarationDescriptor = variable2.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "variable.containingDeclaration");
        DeclarationDescriptor variableParent = declarationDescriptor;
        DeclarationDescriptor scopeContainer = scope2.getOwnerDescriptor();
        if (this.isCapturedVariable(variableParent, scopeContainer) && trace.get(BindingContext.CAPTURED_IN_CLOSURE, variable2) != CaptureKind.NOT_INLINE) {
            BindingContext bindingContext = trace.getBindingContext();
            Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
            trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable2, this.getCaptureKind(bindingContext, scopeContainer, variableParent, variable2));
            return;
        }
    }

    private final void checkFieldInExactlyOnceLambdaInitialization(VariableDescriptor variable2, BindingTrace trace, DeclarationDescriptor scopeContainer, PsiElement nameElement) {
        Object object;
        if (!(variable2 instanceof PropertyDescriptor) || !(scopeContainer instanceof AnonymousFunctionDescriptor) || ((PropertyDescriptor)variable2).isVar()) {
            return;
        }
        if (!this.isLhsOfAssignment((KtExpression)nameElement)) {
            return;
        }
        Object object2 = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        Object object3 = object = object2 instanceof KtFunction ? (KtFunction)object2 : null;
        if (object == null) {
            return;
        }
        KtFunction scopeDeclaration = object;
        if (!(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof ConstructorDescriptor) && !(((AnonymousFunctionDescriptor)scopeContainer).getContainingDeclaration() instanceof PropertyDescriptor)) {
            return;
        }
        object = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(object, "trace.bindingContext");
        if (!this.isExactlyOnceContract((BindingContext)object, scopeDeclaration)) {
            return;
        }
        if (trace.getBindingContext().get(BindingContext.CAPTURED_IN_CLOSURE, variable2) == CaptureKind.NOT_INLINE) {
            return;
        }
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue(bindingContext, "trace.bindingContext");
        object2 = this.getCalleeDescriptorAndParameter(bindingContext, scopeDeclaration);
        if (object2 == null) {
            return;
        }
        object = object2;
        CallableDescriptor callee = (CallableDescriptor)((Pair)object).component1();
        ValueParameterDescriptor param = (ValueParameterDescriptor)((Pair)object).component2();
        if (!(callee instanceof FunctionDescriptor)) {
            return;
        }
        if (!((FunctionDescriptor)callee).isInline() || param.isCrossinline() || !InlineUtil.isInlineParameter(param)) {
            trace.report(Errors.CAPTURED_VAL_INITIALIZATION.on((KtExpression)nameElement, variable2));
        }
    }

    private final boolean isLhsOfAssignment(KtExpression nameElement) {
        KtBinaryExpression ktBinaryExpression;
        PsiElement psiElement = nameElement.getParent();
        KtBinaryExpression ktBinaryExpression2 = ktBinaryExpression = psiElement instanceof KtBinaryExpression ? (KtBinaryExpression)psiElement : null;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression parent2 = ktBinaryExpression;
        return Intrinsics.areEqual(parent2.getOperationToken(), KtTokens.EQ) && Intrinsics.areEqual(parent2.getLeft(), nameElement);
    }

    private final boolean isCapturedVariable(DeclarationDescriptor variableParent, DeclarationDescriptor scopeContainer) {
        if (!(variableParent instanceof FunctionDescriptor) || Intrinsics.areEqual(scopeContainer, variableParent)) {
            return false;
        }
        if (variableParent instanceof ConstructorDescriptor) {
            ClassifierDescriptorWithTypeParameters classifierDescriptorWithTypeParameters = ((ConstructorDescriptor)variableParent).getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue(classifierDescriptorWithTypeParameters, "variableParent.containingDeclaration");
            ClassifierDescriptorWithTypeParameters classDescriptor2 = classifierDescriptorWithTypeParameters;
            if (Intrinsics.areEqual(scopeContainer, classDescriptor2)) {
                return false;
            }
            if (scopeContainer instanceof PropertyDescriptor && Intrinsics.areEqual(((PropertyDescriptor)scopeContainer).getContainingDeclaration(), classDescriptor2)) {
                return false;
            }
        }
        return true;
    }

    private final CaptureKind getCaptureKind(BindingContext context2, DeclarationDescriptor scopeContainer, DeclarationDescriptor variableParent, VariableDescriptor variable2) {
        PsiElement scopeDeclaration = DescriptorToSourceUtils.descriptorToDeclaration(scopeContainer);
        if (!InlineUtil.canBeInlineArgument(scopeDeclaration)) {
            return CaptureKind.NOT_INLINE;
        }
        if (scopeDeclaration == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFunction");
        }
        if (InlineUtil.isInlinedArgument((KtFunction)scopeDeclaration, context2, false) && !this.isCrossinlineParameter(context2, (KtFunction)scopeDeclaration)) {
            DeclarationDescriptor declarationDescriptor = scopeContainer.getContainingDeclaration();
            if (declarationDescriptor == null) {
                String string2 = Intrinsics.stringPlus("parent is null for ", scopeContainer);
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            DeclarationDescriptor scopeContainerParent = declarationDescriptor2;
            return !this.isCapturedVariable(variableParent, scopeContainerParent) || this.getCaptureKind(context2, scopeContainerParent, variableParent, variable2) == CaptureKind.INLINE_ONLY ? CaptureKind.INLINE_ONLY : CaptureKind.NOT_INLINE;
        }
        boolean exactlyOnceContract = this.isExactlyOnceContract(context2, (KtFunction)scopeDeclaration);
        if (!exactlyOnceContract) {
            return CaptureKind.NOT_INLINE;
        }
        return this.isArgument(variable2, variableParent) || CapturingInClosureCheckerKt.findDestructuredVariable(variable2, variableParent) != null || this.isForLoopParameter(variable2) || this.isCatchBlockParameter(variable2) || this.isValInWhen(variable2) ? CaptureKind.NOT_INLINE : CaptureKind.EXACTLY_ONCE_EFFECT;
    }

    private final boolean isArgument(VariableDescriptor variable2, DeclarationDescriptor variableParent) {
        return variable2 instanceof ValueParameterDescriptor && variableParent instanceof CallableDescriptor && ((CallableDescriptor)variableParent).getValueParameters().contains(variable2);
    }

    private final boolean isValInWhen(VariableDescriptor variable2) {
        Boolean bl;
        KtElement ktElement;
        LocalVariableDescriptor localVariableDescriptor = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        SourceElement sourceElement = localVariableDescriptor == null ? null : localVariableDescriptor.getSource();
        Object object = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
        KtElement ktElement2 = ktElement = object == null ? null : ((KotlinSourceElement)object).getPsi();
        if (ktElement == null) {
            return false;
        }
        KtElement psi = ktElement;
        object = psi.getParent();
        KtElement ktElement3 = ktElement = object instanceof KtWhenExpression ? (KtWhenExpression)object : null;
        if (ktElement == null) {
            bl = null;
        } else {
            object = ktElement;
            boolean bl2 = false;
            boolean bl3 = false;
            Object it = object;
            boolean bl4 = false;
            bl = Intrinsics.areEqual(((KtWhenExpression)it).getSubjectVariable(), psi);
        }
        return Intrinsics.areEqual(bl, true);
    }

    private final boolean isCatchBlockParameter(VariableDescriptor variable2) {
        List<KtParameter> list2;
        KtParameterList ktParameterList;
        PsiElement psiElement;
        LocalVariableDescriptor localVariableDescriptor = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        SourceElement sourceElement = localVariableDescriptor == null ? null : localVariableDescriptor.getSource();
        KotlinSourceElement kotlinSourceElement = sourceElement instanceof KotlinSourceElement ? (KotlinSourceElement)sourceElement : null;
        KtElement ktElement = psiElement = kotlinSourceElement == null ? null : kotlinSourceElement.getPsi();
        if (psiElement == null) {
            return false;
        }
        KtElement psi = psiElement;
        psiElement = psi.getParent().getParent();
        boolean bl = false;
        boolean bl2 = false;
        PsiElement it = psiElement;
        boolean bl3 = false;
        return it instanceof KtCatchClause && Intrinsics.areEqual((ktParameterList = ((KtCatchClause)it).getParameterList()) == null ? null : ((list2 = ktParameterList.getParameters()) == null ? null : Boolean.valueOf(CollectionsKt.contains((Iterable)list2, psi))), true);
    }

    private final boolean isForLoopParameter(VariableDescriptor variable2) {
        KtElement ktElement;
        Object object = variable2 instanceof LocalVariableDescriptor ? (LocalVariableDescriptor)variable2 : null;
        Object object2 = object == null ? null : ((DeclarationDescriptorNonRootImpl)object).getSource();
        Object object3 = object2 instanceof KotlinSourceElement ? (KotlinSourceElement)object2 : null;
        KtElement ktElement2 = ktElement = object3 == null ? null : ((KotlinSourceElement)object3).getPsi();
        if (ktElement == null) {
            return false;
        }
        KtElement psi = ktElement;
        if (psi.getParent() instanceof KtForExpression) {
            object3 = psi.getParent();
            if (object3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtForExpression");
            }
            KtForExpression forExpression = (KtForExpression)object3;
            return Intrinsics.areEqual(forExpression.getLoopParameter(), psi);
        }
        if (psi.getParent() instanceof KtDestructuringDeclaration) {
            object2 = psi.getParent().getParent();
            Object object4 = object3 = object2 instanceof KtParameter ? (KtParameter)object2 : null;
            if (object3 == null) {
                return false;
            }
            Object parameter = object3;
            object = ((KtDeclarationStub)parameter).getParent();
            Object object5 = object2 = object instanceof KtForExpression ? (KtForExpression)object : null;
            if (object2 == null) {
                return false;
            }
            Object forExpression = object2;
            return Intrinsics.areEqual(((KtForExpression)forExpression).getLoopParameter(), parameter);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isExactlyOnceParameter(DeclarationDescriptor function2, VariableDescriptor parameter) {
        Iterator iterator2;
        Object object;
        block6: {
            void $this$filterIsInstanceTo$iv$iv;
            ContractDescription contractDescription;
            if (!(function2 instanceof CallableDescriptor)) {
                return false;
            }
            if (!(parameter instanceof ValueParameterDescriptor)) {
                return false;
            }
            object = (AbstractContractProvider)((CallableDescriptor)function2).getUserData(ContractProviderKey.INSTANCE);
            ContractDescription contractDescription2 = contractDescription = object == null ? null : ((AbstractContractProvider)object).getContractDescription();
            if (contractDescription == null) {
                return false;
            }
            ContractDescription contractDescription3 = contractDescription;
            Iterable $this$filterIsInstance$iv = contractDescription3.getEffects();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof CallsEffectDeclaration)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            boolean bl = false;
            iterable = iterable2;
            boolean bl2 = false;
            for (Iterator iterator3 : iterable) {
                CallsEffectDeclaration it = (CallsEffectDeclaration)((Object)iterator3);
                boolean bl3 = false;
                if (!Intrinsics.areEqual(it.getVariableReference().getDescriptor(), ((ValueParameterDescriptor)parameter).getOriginal())) continue;
                iterator2 = iterator3;
                break block6;
            }
            iterator2 = null;
        }
        object = (CallsEffectDeclaration)((Object)iterator2);
        if (object == null) {
            return false;
        }
        Object effect = object;
        return ((CallsEffectDeclaration)effect).getKind() == EventOccurrencesRange.EXACTLY_ONCE;
    }

    private final boolean isExactlyOnceContract(BindingContext bindingContext, KtFunction argument) {
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        if (pair == null) {
            return false;
        }
        Pair<CallableDescriptor, ValueParameterDescriptor> pair2 = pair;
        CallableDescriptor descriptor2 = pair2.component1();
        ValueParameterDescriptor parameter = pair2.component2();
        return this.isExactlyOnceParameter(descriptor2, parameter);
    }

    private final Pair<CallableDescriptor, ValueParameterDescriptor> getCalleeDescriptorAndParameter(BindingContext bindingContext, KtFunction argument) {
        Object object = KtPsiUtil.getParentCallIfPresent(argument);
        if (object == null) {
            return null;
        }
        Object object2 = object;
        KtExpression call2 = object2;
        if ((object = CallUtilKt.getResolvedCall(call2, bindingContext)) == null) {
            return null;
        }
        Object resolvedCall2 = object;
        Object descriptor2 = resolvedCall2.getResultingDescriptor();
        Object object3 = resolvedCall2.getCall();
        Intrinsics.checkNotNullExpressionValue(object3, "resolvedCall.call");
        ValueArgument valueArgument = CallUtilKt.getValueArgumentForExpression((Call)object3, argument);
        if (valueArgument == null) {
            return null;
        }
        ValueArgument valueArgument2 = valueArgument;
        ArgumentMapping argumentMapping = resolvedCall2.getArgumentMapping(valueArgument2);
        Object object4 = object3 = argumentMapping instanceof ArgumentMatch ? (ArgumentMatch)argumentMapping : null;
        if (object3 == null) {
            return null;
        }
        Object mapping2 = object3;
        ValueParameterDescriptor parameter = mapping2.getValueParameter();
        return TuplesKt.to(descriptor2, parameter);
    }

    private final boolean isCrossinlineParameter(BindingContext bindingContext, KtFunction argument) {
        ValueParameterDescriptor valueParameterDescriptor;
        Pair<CallableDescriptor, ValueParameterDescriptor> pair = this.getCalleeDescriptorAndParameter(bindingContext, argument);
        return Intrinsics.areEqual(pair == null ? null : ((valueParameterDescriptor = pair.getSecond()) == null ? null : Boolean.valueOf(valueParameterDescriptor.isCrossinline())), true);
    }
}

